/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class EntityId
implements TBase<EntityId, _Fields>,
Serializable,
Cloneable,
Comparable<EntityId> {
    private static final TStruct STRUCT_DESC = new TStruct("EntityId");
    private static final TField ID_FIELD_DESC = new TField("id", 10, 1);
    private static final TField TYPE_FIELD_DESC = new TField("type", 3, 2);
    private static final TField CONN_ID_FIELD_DESC = new TField("connId", 10, 3);
    private static final TField TOKEN_FIELD_DESC = new TField("token", 11, 4);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public long id;
    public byte type;
    public long connId;
    public ByteBuffer token;
    private static final int __ID_ISSET_ID = 0;
    private static final int __TYPE_ISSET_ID = 1;
    private static final int __CONNID_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public EntityId() {
    }

    public EntityId(long id, byte type, long connId, ByteBuffer token) {
        this();
        this.id = id;
        this.setIdIsSet(true);
        this.type = type;
        this.setTypeIsSet(true);
        this.connId = connId;
        this.setConnIdIsSet(true);
        this.token = TBaseHelper.copyBinary((ByteBuffer)token);
    }

    public EntityId(EntityId other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.id = other.id;
        this.type = other.type;
        this.connId = other.connId;
        if (other.isSetToken()) {
            this.token = TBaseHelper.copyBinary((ByteBuffer)other.token);
        }
    }

    public EntityId deepCopy() {
        return new EntityId(this);
    }

    public void clear() {
        this.setIdIsSet(false);
        this.id = 0L;
        this.setTypeIsSet(false);
        this.type = 0;
        this.setConnIdIsSet(false);
        this.connId = 0L;
        this.token = null;
    }

    public long getId() {
        return this.id;
    }

    public EntityId setId(long id) {
        this.id = id;
        this.setIdIsSet(true);
        return this;
    }

    public void unsetId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public byte getType() {
        return this.type;
    }

    public EntityId setType(byte type) {
        this.type = type;
        this.setTypeIsSet(true);
        return this;
    }

    public void unsetType() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetType() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setTypeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getConnId() {
        return this.connId;
    }

    public EntityId setConnId(long connId) {
        this.connId = connId;
        this.setConnIdIsSet(true);
        return this;
    }

    public void unsetConnId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetConnId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setConnIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public byte[] getToken() {
        this.setToken(TBaseHelper.rightSize((ByteBuffer)this.token));
        return this.token == null ? null : this.token.array();
    }

    public ByteBuffer bufferForToken() {
        return TBaseHelper.copyBinary((ByteBuffer)this.token);
    }

    public EntityId setToken(byte[] token) {
        this.token = token == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(token, token.length));
        return this;
    }

    public EntityId setToken(ByteBuffer token) {
        this.token = TBaseHelper.copyBinary((ByteBuffer)token);
        return this;
    }

    public void unsetToken() {
        this.token = null;
    }

    public boolean isSetToken() {
        return this.token != null;
    }

    public void setTokenIsSet(boolean value) {
        if (!value) {
            this.token = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ID: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Long)value);
                break;
            }
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((Byte)value);
                break;
            }
            case CONN_ID: {
                if (value == null) {
                    this.unsetConnId();
                    break;
                }
                this.setConnId((Long)value);
                break;
            }
            case TOKEN: {
                if (value == null) {
                    this.unsetToken();
                    break;
                }
                this.setToken((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ID: {
                return this.getId();
            }
            case TYPE: {
                return this.getType();
            }
            case CONN_ID: {
                return this.getConnId();
            }
            case TOKEN: {
                return this.getToken();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ID: {
                return this.isSetId();
            }
            case TYPE: {
                return this.isSetType();
            }
            case CONN_ID: {
                return this.isSetConnId();
            }
            case TOKEN: {
                return this.isSetToken();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof EntityId) {
            return this.equals((EntityId)that);
        }
        return false;
    }

    public boolean equals(EntityId that) {
        if (that == null) {
            return false;
        }
        boolean this_present_id = true;
        boolean that_present_id = true;
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
        }
        boolean this_present_type = true;
        boolean that_present_type = true;
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (this.type != that.type) {
                return false;
            }
        }
        boolean this_present_connId = true;
        boolean that_present_connId = true;
        if (this_present_connId || that_present_connId) {
            if (!this_present_connId || !that_present_connId) {
                return false;
            }
            if (this.connId != that.connId) {
                return false;
            }
        }
        boolean this_present_token = this.isSetToken();
        boolean that_present_token = that.isSetToken();
        if (this_present_token || that_present_token) {
            if (!this_present_token || !that_present_token) {
                return false;
            }
            if (!this.token.equals(that.token)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_id = true;
        list.add(Boolean.valueOf(present_id));
        if (present_id) {
            list.add(Long.valueOf(this.id));
        }
        boolean present_type = true;
        list.add(Boolean.valueOf(present_type));
        if (present_type) {
            list.add(Byte.valueOf(this.type));
        }
        boolean present_connId = true;
        list.add(Boolean.valueOf(present_connId));
        if (present_connId) {
            list.add(Long.valueOf(this.connId));
        }
        boolean present_token = this.isSetToken();
        list.add(Boolean.valueOf(present_token));
        if (present_token) {
            list.add(this.token);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(EntityId other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetId()).compareTo(other.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetId() && (lastComparison = TBaseHelper.compareTo((long)this.id, (long)other.id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetType()).compareTo(other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((byte)this.type, (byte)other.type)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetConnId()).compareTo(other.isSetConnId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetConnId() && (lastComparison = TBaseHelper.compareTo((long)this.connId, (long)other.connId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetToken()).compareTo(other.isSetToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetToken() && (lastComparison = TBaseHelper.compareTo((Comparable)this.token, (Comparable)other.token)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("EntityId(");
        boolean first = true;
        sb.append("id:");
        sb.append(this.id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("type:");
        sb.append(this.type);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("connId:");
        sb.append(this.connId);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("token:");
        if (this.token == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.token, (StringBuilder)sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.token == null) {
            throw new TProtocolException("Required field 'token' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new EntityIdStandardSchemeFactory());
        schemes.put(TupleScheme.class, new EntityIdTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ID, new FieldMetaData("id", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, new FieldValueMetaData(3)));
        tmpMap.put(_Fields.CONN_ID, new FieldMetaData("connId", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TOKEN, new FieldMetaData("token", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(EntityId.class, metaDataMap);
    }

    private static class EntityIdTupleScheme
    extends TupleScheme<EntityId> {
        private EntityIdTupleScheme() {
        }

        public void write(TProtocol prot, EntityId struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.id);
            oprot.writeByte(struct.type);
            oprot.writeI64(struct.connId);
            oprot.writeBinary(struct.token);
        }

        public void read(TProtocol prot, EntityId struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.id = iprot.readI64();
            struct.setIdIsSet(true);
            struct.type = iprot.readByte();
            struct.setTypeIsSet(true);
            struct.connId = iprot.readI64();
            struct.setConnIdIsSet(true);
            struct.token = iprot.readBinary();
            struct.setTokenIsSet(true);
        }
    }

    private static class EntityIdTupleSchemeFactory
    implements SchemeFactory {
        private EntityIdTupleSchemeFactory() {
        }

        public EntityIdTupleScheme getScheme() {
            return new EntityIdTupleScheme();
        }
    }

    private static class EntityIdStandardScheme
    extends StandardScheme<EntityId> {
        private EntityIdStandardScheme() {
        }

        public void read(TProtocol iprot, EntityId struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.id = iprot.readI64();
                            struct.setIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 3) {
                            struct.type = iprot.readByte();
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.connId = iprot.readI64();
                            struct.setConnIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.token = iprot.readBinary();
                            struct.setTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetId()) {
                throw new TProtocolException("Required field 'id' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetType()) {
                throw new TProtocolException("Required field 'type' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetConnId()) {
                throw new TProtocolException("Required field 'connId' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, EntityId struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(ID_FIELD_DESC);
            oprot.writeI64(struct.id);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(TYPE_FIELD_DESC);
            oprot.writeByte(struct.type);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(CONN_ID_FIELD_DESC);
            oprot.writeI64(struct.connId);
            oprot.writeFieldEnd();
            if (struct.token != null) {
                oprot.writeFieldBegin(TOKEN_FIELD_DESC);
                oprot.writeBinary(struct.token);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class EntityIdStandardSchemeFactory
    implements SchemeFactory {
        private EntityIdStandardSchemeFactory() {
        }

        public EntityIdStandardScheme getScheme() {
            return new EntityIdStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ID(1, "id"),
        TYPE(2, "type"),
        CONN_ID(3, "connId"),
        TOKEN(4, "token");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ID;
                }
                case 2: {
                    return TYPE;
                }
                case 3: {
                    return CONN_ID;
                }
                case 4: {
                    return TOKEN;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

