/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.gemstone.gnu.trove.TIntArrayList;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import io.snappydata.thrift.BlobChunk;
import io.snappydata.thrift.ClobChunk;
import io.snappydata.thrift.ColumnDescriptor;
import io.snappydata.thrift.ColumnValue;
import io.snappydata.thrift.DateTime;
import io.snappydata.thrift.Decimal;
import io.snappydata.thrift.JSONObject;
import io.snappydata.thrift.SnappyType;
import io.snappydata.thrift.Timestamp;
import io.snappydata.thrift.common.Converters;
import io.snappydata.thrift.common.CreateLobFinalizer;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;

public class OptimizedElementArray {
    protected static final int DEFAULT_CAPACITY = 4;
    protected byte[] primitives;
    protected BitSet primNulls;
    protected Object[] nonPrimitives;
    protected int[] positionMap;
    protected byte[] types;
    protected int primSize;
    protected int nonPrimSize;
    protected int size;
    protected transient int hash;

    protected OptimizedElementArray() {
        this(true);
    }

    protected OptimizedElementArray(boolean useTypes) {
        this.primitives = new byte[16];
        this.nonPrimitives = new Object[4];
        this.positionMap = new int[8];
        if (useTypes) {
            this.types = new byte[8];
        }
    }

    protected OptimizedElementArray(OptimizedElementArray other) {
        this(other, true);
    }

    protected OptimizedElementArray(OptimizedElementArray other, boolean copyValues) {
        byte[] prims = other.primitives;
        Object[] nonPrims = other.nonPrimitives;
        byte[] types = other.types;
        if (prims != null) {
            byte[] byArray = this.primitives = copyValues ? (byte[])prims.clone() : new byte[prims.length];
        }
        if (nonPrims != null) {
            this.nonPrimitives = copyValues ? (Object[])nonPrims.clone() : new Object[nonPrims.length];
        }
        this.positionMap = (int[])other.positionMap.clone();
        if (types != null) {
            this.types = (byte[])types.clone();
        }
        this.primSize = other.primSize;
        this.nonPrimSize = other.nonPrimSize;
        this.size = other.size;
    }

    public OptimizedElementArray(SnappyType[] types, boolean useTypes) {
        int index = 0;
        int primitivePosition = 0;
        int nonPrimitivePosition = 1;
        this.positionMap = new int[types.length];
        if (useTypes) {
            this.types = new byte[types.length];
        }
        block6: for (SnappyType type : types) {
            if (useTypes) {
                this.types[index] = (byte)type.getValue();
            }
            switch (type) {
                case INTEGER: 
                case REAL: {
                    this.positionMap[index++] = primitivePosition;
                    primitivePosition += 4;
                    continue block6;
                }
                case BIGINT: 
                case DOUBLE: 
                case FLOAT: {
                    this.positionMap[index++] = primitivePosition;
                    primitivePosition += 8;
                    continue block6;
                }
                case BOOLEAN: 
                case TINYINT: 
                case NULLTYPE: {
                    this.positionMap[index++] = primitivePosition++;
                    continue block6;
                }
                case SMALLINT: {
                    this.positionMap[index++] = primitivePosition;
                    primitivePosition += 2;
                    continue block6;
                }
                default: {
                    this.positionMap[index++] = -nonPrimitivePosition;
                    ++nonPrimitivePosition;
                }
            }
        }
        if (primitivePosition > 0) {
            this.primSize = primitivePosition;
            this.primitives = new byte[primitivePosition];
        }
        if (nonPrimitivePosition > 1) {
            this.nonPrimSize = nonPrimitivePosition - 1;
            this.nonPrimitives = new Object[this.nonPrimSize];
        }
        this.size = index;
    }

    public OptimizedElementArray(List<ColumnDescriptor> metadata, boolean useTypes) {
        this(OptimizedElementArray.getTypes(metadata), useTypes);
    }

    public static SnappyType[] getTypes(List<ColumnDescriptor> metadata) {
        SnappyType[] types = new SnappyType[metadata.size()];
        int index = 0;
        for (ColumnDescriptor cd : metadata) {
            types[index++] = cd.type;
        }
        return types;
    }

    public final SnappyType getSQLType(int index) {
        return SnappyType.findByValue(this.types[index]);
    }

    public final boolean getBoolean(int index) {
        return this.getByte(index) != 0;
    }

    public final boolean isNull(int index) {
        int pos = this.positionMap[index];
        if (pos < 0) {
            return this.nonPrimitives[-pos - 1] == null;
        }
        return this.primNulls != null && this.primNulls.get(index);
    }

    public final byte getByte(int index) {
        return this.primitives[this.positionMap[index]];
    }

    public final short getShort(int index) {
        byte[] prims = this.primitives;
        int primIndex = this.positionMap[index];
        int result = prims[primIndex++] & 0xFF;
        return (short)(result << 8 | prims[primIndex] & 0xFF);
    }

    public final int getInt(int index) {
        byte[] prims = this.primitives;
        int primIndex = this.positionMap[index];
        int result = prims[primIndex++] & 0xFF;
        result = result << 8 | prims[primIndex++] & 0xFF;
        result = result << 8 | prims[primIndex++] & 0xFF;
        return result << 8 | prims[primIndex] & 0xFF;
    }

    public final long getLong(int index) {
        byte[] prims = this.primitives;
        int primIndex = this.positionMap[index];
        long result = prims[primIndex++] & 0xFF;
        result = result << 8 | (long)(prims[primIndex++] & 0xFF);
        result = result << 8 | (long)(prims[primIndex++] & 0xFF);
        result = result << 8 | (long)(prims[primIndex++] & 0xFF);
        result = result << 8 | (long)(prims[primIndex++] & 0xFF);
        result = result << 8 | (long)(prims[primIndex++] & 0xFF);
        result = result << 8 | (long)(prims[primIndex++] & 0xFF);
        return result << 8 | (long)(prims[primIndex] & 0xFF);
    }

    public final float getFloat(int index) {
        return Float.intBitsToFloat(this.getInt(index));
    }

    public final double getDouble(int index) {
        return Double.longBitsToDouble(this.getLong(index));
    }

    public final Object getObject(int index) {
        return this.nonPrimitives[-this.positionMap[index] - 1];
    }

    public final TIntArrayList requiresLobFinalizers() {
        byte[] types = this.types;
        Object[] nonPrimitives = this.nonPrimitives;
        int[] positionMap = this.positionMap;
        int size = this.size;
        TIntArrayList lobIndices = null;
        int blobType = SnappyType.BLOB.getValue();
        int clobType = SnappyType.CLOB.getValue();
        for (int index = 0; index < size; ++index) {
            Comparable<BlobChunk> chunk;
            int lobIndex;
            byte type = types[index];
            if (type == blobType) {
                lobIndex = -positionMap[index] - 1;
                chunk = (BlobChunk)nonPrimitives[lobIndex];
                if (chunk == null || !((BlobChunk)chunk).isSetLobId()) continue;
                if (lobIndices == null) {
                    lobIndices = new TIntArrayList(4);
                }
                lobIndices.add(lobIndex);
                continue;
            }
            if (type != clobType || (chunk = (ClobChunk)nonPrimitives[lobIndex = -positionMap[index] - 1]) == null || !((ClobChunk)chunk).isSetLobId()) continue;
            if (lobIndices == null) {
                lobIndices = new TIntArrayList(4);
            }
            lobIndices.add(-lobIndex - 1);
        }
        return lobIndices;
    }

    public final void initializeLobFinalizers(TIntArrayList lobIndices, CreateLobFinalizer createLobFinalizer) {
        Object[] nonPrimitives = this.nonPrimitives;
        int size = lobIndices.size();
        for (int index = 0; index < size; ++index) {
            int lobIndex = lobIndices.getQuick(index);
            if (lobIndex >= 0) {
                nonPrimitives[lobIndex + 1] = createLobFinalizer.execute((BlobChunk)nonPrimitives[lobIndex]);
                continue;
            }
            lobIndex = -lobIndex - 1;
            nonPrimitives[lobIndex + 1] = createLobFinalizer.execute((ClobChunk)nonPrimitives[lobIndex]);
        }
    }

    public final BlobChunk getBlobChunk(int index, boolean clearFinalizer) {
        FinalizeObject finalizer;
        int lobIndex = -this.positionMap[index] - 1;
        BlobChunk chunk = (BlobChunk)this.nonPrimitives[lobIndex];
        if (clearFinalizer && chunk != null && chunk.isSetLobId() && (finalizer = (FinalizeObject)this.nonPrimitives[lobIndex + 1]) != null) {
            finalizer.clearAll();
            this.nonPrimitives[lobIndex + 1] = null;
        }
        return chunk;
    }

    public final ClobChunk getClobChunk(int index, boolean clearFinalizer) {
        FinalizeObject finalizer;
        int lobIndex = -this.positionMap[index] - 1;
        ClobChunk chunk = (ClobChunk)this.nonPrimitives[lobIndex];
        if (clearFinalizer && chunk != null && chunk.isSetLobId() && (finalizer = (FinalizeObject)this.nonPrimitives[lobIndex + 1]) != null) {
            finalizer.clearAll();
            this.nonPrimitives[lobIndex + 1] = null;
        }
        return chunk;
    }

    protected final void setType(int index, SnappyType sqlType) {
        if (this.types != null && this.types[index] == 0) {
            this.types[index] = (byte)sqlType.getValue();
        }
    }

    public final void setBoolean(int index, boolean value) {
        this.primitives[this.positionMap[index]] = value ? (byte)1 : 0;
    }

    protected final void setPrimBoolean(int primIndex, boolean value) {
        this.primitives[primIndex] = value ? (byte)1 : 0;
    }

    public final void setByte(int index, byte value) {
        this.primitives[this.positionMap[index]] = value;
    }

    protected final void setPrimByte(int primIndex, byte value) {
        this.primitives[primIndex] = value;
    }

    public final void setNull(int index) {
        int pos = this.positionMap[index];
        if (pos < 0) {
            this.nonPrimitives[-pos - 1] = null;
        } else {
            if (this.primNulls == null) {
                this.primNulls = new BitSet(this.positionMap.length);
            }
            this.primNulls.set(index);
        }
    }

    public final void setShort(int index, short value) {
        this.setPrimShort(this.positionMap[index], value);
    }

    protected final void setPrimShort(int primIndex, short value) {
        byte[] prims = this.primitives;
        prims[primIndex++] = (byte)(value >>> 8 & 0xFF);
        prims[primIndex] = (byte)(value & 0xFF);
    }

    public final void setInt(int index, int value) {
        this.setPrimInt(this.positionMap[index], value);
    }

    protected final void setPrimInt(int primIndex, int value) {
        byte[] prims = this.primitives;
        prims[primIndex++] = (byte)(value >>> 24 & 0xFF);
        prims[primIndex++] = (byte)(value >>> 16 & 0xFF);
        prims[primIndex++] = (byte)(value >>> 8 & 0xFF);
        prims[primIndex] = (byte)(value & 0xFF);
    }

    public final void setLong(int index, long value) {
        this.setPrimLong(this.positionMap[index], value);
    }

    protected final void setPrimLong(int primIndex, long value) {
        byte[] prims = this.primitives;
        prims[primIndex++] = (byte)(value >>> 56 & 0xFFL);
        prims[primIndex++] = (byte)(value >>> 48 & 0xFFL);
        prims[primIndex++] = (byte)(value >>> 40 & 0xFFL);
        prims[primIndex++] = (byte)(value >>> 32 & 0xFFL);
        prims[primIndex++] = (byte)(value >>> 24 & 0xFFL);
        prims[primIndex++] = (byte)(value >>> 16 & 0xFFL);
        prims[primIndex++] = (byte)(value >>> 8 & 0xFFL);
        prims[primIndex] = (byte)(value & 0xFFL);
    }

    public final void setFloat(int index, float value) {
        this.setPrimInt(this.positionMap[index], Float.floatToIntBits(value));
    }

    public final void setDouble(int index, double value) {
        this.setPrimLong(this.positionMap[index], Double.doubleToLongBits(value));
    }

    public final void setObject(int index, Object value, SnappyType type) {
        this.nonPrimitives[-this.positionMap[index] - 1] = value;
        if (this.types != null) {
            this.types[index] = (byte)type.getValue();
        }
    }

    public final void setInto(int index, ColumnValue cv) throws IOException {
        if (this.types != null) {
            cv.clear();
            if (this.primNulls != null && this.primNulls.get(index)) {
                cv.setNull_val(true);
                return;
            }
            SnappyType sqlType = SnappyType.findByValue(this.types[index]);
            assert (sqlType != null) : "setInto: unhandled type=" + this.types[index];
            switch (sqlType) {
                case CHAR: 
                case VARCHAR: 
                case LONGVARCHAR: {
                    String str = (String)this.getObject(index);
                    if (str != null) {
                        cv.setString_val(str);
                        break;
                    }
                    cv.setNull_val(true);
                    break;
                }
                case INTEGER: {
                    cv.setI32_val(this.getInt(index));
                    break;
                }
                case BIGINT: {
                    cv.setI64_val(this.getLong(index));
                    break;
                }
                case DECIMAL: {
                    BigDecimal decimal = (BigDecimal)this.getObject(index);
                    if (decimal != null) {
                        cv.setDecimal_val(Converters.getDecimal(decimal));
                        break;
                    }
                    cv.setNull_val(true);
                    break;
                }
                case SMALLINT: {
                    cv.setI16_val(this.getShort(index));
                    break;
                }
                case TINYINT: {
                    cv.setByte_val(this.getByte(index));
                    break;
                }
                case BOOLEAN: {
                    cv.setBool_val(this.getBoolean(index));
                    break;
                }
                case DATE: {
                    Date date = (Date)this.getObject(index);
                    if (date != null) {
                        cv.setDate_val(Converters.getDateTime(date));
                        break;
                    }
                    cv.setNull_val(true);
                    break;
                }
                case TIMESTAMP: {
                    java.sql.Timestamp ts = (java.sql.Timestamp)this.getObject(index);
                    if (ts != null) {
                        cv.setTimestamp_val(Converters.getTimestamp(ts));
                        break;
                    }
                    cv.setNull_val(true);
                    break;
                }
                case TIME: {
                    Time time = (Time)this.getObject(index);
                    if (time != null) {
                        cv.setTime_val(Converters.getDateTime(time));
                        break;
                    }
                    cv.setNull_val(true);
                    break;
                }
                case REAL: {
                    cv.setFloat_val(this.getInt(index));
                    break;
                }
                case DOUBLE: 
                case FLOAT: {
                    cv.setDouble_val(this.getDouble(index));
                    break;
                }
                case BINARY: 
                case VARBINARY: 
                case LONGVARBINARY: {
                    byte[] bytes = (byte[])this.getObject(index);
                    if (bytes != null) {
                        cv.setBinary_val(bytes);
                        break;
                    }
                    cv.setNull_val(true);
                    break;
                }
                case JAVA_OBJECT: {
                    Object o = this.getObject(index);
                    if (o != null) {
                        cv.setJava_val(Converters.getJavaObjectAsBytes(o));
                        break;
                    }
                    cv.setNull_val(true);
                    break;
                }
                case JSON: {
                    JSONObject jsonObject = (JSONObject)((Object)this.getObject(index));
                    if (jsonObject != null) {
                        cv.setJson_val(jsonObject);
                        break;
                    }
                    cv.setNull_val(true);
                    break;
                }
                case CLOB: {
                    ClobChunk clob = (ClobChunk)this.getObject(index);
                    if (clob != null) {
                        cv.setClob_val(clob);
                        break;
                    }
                    cv.setNull_val(true);
                    break;
                }
                case BLOB: {
                    BlobChunk blob = (BlobChunk)this.getObject(index);
                    if (blob != null) {
                        cv.setBlob_val(blob);
                        break;
                    }
                    cv.setNull_val(true);
                    break;
                }
                default: {
                    throw new IOException("setInto: unhandled type=" + (Object)((Object)sqlType));
                }
            }
        } else {
            throw new IOException("setInfo: unexpected invocation for types=null");
        }
    }

    public final void addColumnValue(ColumnValue cv) throws SQLException {
        block39: {
            block38: {
                this.ensureCapacity();
                ColumnValue._Fields setField = (ColumnValue._Fields)cv.getSetField();
                if (setField == null) break block38;
                switch (setField) {
                    case I32_VAL: {
                        this.ensurePrimCapacity(4);
                        this.positionMap[this.size] = this.primSize;
                        this.setPrimInt(this.primSize, cv.getI32_val());
                        this.setType(this.size, SnappyType.INTEGER);
                        ++this.size;
                        this.primSize += 4;
                        break block39;
                    }
                    case I64_VAL: {
                        this.ensurePrimCapacity(8);
                        this.positionMap[this.size] = this.primSize;
                        this.setPrimLong(this.primSize, cv.getI64_val());
                        this.setType(this.size, SnappyType.BIGINT);
                        ++this.size;
                        this.primSize += 8;
                        break block39;
                    }
                    case DOUBLE_VAL: {
                        this.ensurePrimCapacity(8);
                        this.positionMap[this.size] = this.primSize;
                        this.setPrimLong(this.primSize, Double.doubleToLongBits(cv.getDouble_val()));
                        this.setType(this.size, SnappyType.DOUBLE);
                        ++this.size;
                        this.primSize += 8;
                        break block39;
                    }
                    case STRING_VAL: {
                        this.ensureNonPrimCapacity();
                        String str = (String)cv.getFieldValue();
                        if (str != null) {
                            this.nonPrimitives[this.nonPrimSize++] = str;
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, str.length() <= 32672 ? SnappyType.VARCHAR : SnappyType.CLOB);
                            ++this.size;
                        }
                        break block39;
                    }
                    case DECIMAL_VAL: {
                        this.ensureNonPrimCapacity();
                        Decimal decimal = (Decimal)cv.getFieldValue();
                        if (decimal != null) {
                            this.nonPrimitives[this.nonPrimSize++] = Converters.getBigDecimal(decimal);
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, SnappyType.DECIMAL);
                            ++this.size;
                        }
                        break block39;
                    }
                    case TIMESTAMP_VAL: {
                        this.ensureNonPrimCapacity();
                        Timestamp ts = (Timestamp)cv.getFieldValue();
                        if (ts != null) {
                            this.nonPrimitives[this.nonPrimSize++] = Converters.getTimestamp(ts);
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, SnappyType.TIMESTAMP);
                            ++this.size;
                        }
                        break block39;
                    }
                    case DATE_VAL: {
                        this.ensureNonPrimCapacity();
                        DateTime date = (DateTime)cv.getFieldValue();
                        if (date != null) {
                            this.nonPrimitives[this.nonPrimSize++] = new Date(date.secsSinceEpoch * 1000L);
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, SnappyType.DATE);
                            ++this.size;
                        }
                        break block39;
                    }
                    case BOOL_VAL: {
                        this.ensurePrimCapacity(1);
                        this.positionMap[this.size] = this.primSize;
                        this.setPrimBoolean(this.primSize, cv.getBool_val());
                        this.setType(this.size, SnappyType.BOOLEAN);
                        ++this.size;
                        ++this.primSize;
                        break block39;
                    }
                    case BYTE_VAL: {
                        this.ensurePrimCapacity(1);
                        this.positionMap[this.size] = this.primSize;
                        this.setPrimByte(this.primSize, cv.getByte_val());
                        this.setType(this.size, SnappyType.TINYINT);
                        ++this.size;
                        ++this.primSize;
                        break block39;
                    }
                    case FLOAT_VAL: {
                        this.ensurePrimCapacity(4);
                        this.positionMap[this.size] = this.primSize;
                        this.setPrimInt(this.primSize, cv.getFloat_val());
                        this.setType(this.size, SnappyType.REAL);
                        ++this.size;
                        this.primSize += 4;
                        break block39;
                    }
                    case I16_VAL: {
                        this.ensurePrimCapacity(2);
                        this.positionMap[this.size] = this.primSize;
                        this.setPrimShort(this.primSize, cv.getI16_val());
                        this.setType(this.size, SnappyType.SMALLINT);
                        ++this.size;
                        this.primSize += 2;
                        break block39;
                    }
                    case TIME_VAL: {
                        this.ensureNonPrimCapacity();
                        DateTime time = (DateTime)cv.getFieldValue();
                        if (time != null) {
                            this.nonPrimitives[this.nonPrimSize++] = new Time(time.secsSinceEpoch * 1000L);
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, SnappyType.TIME);
                            ++this.size;
                        }
                        break block39;
                    }
                    case BINARY_VAL: {
                        this.ensureNonPrimCapacity();
                        byte[] bytes = cv.getBinary_val();
                        if (bytes != null) {
                            this.nonPrimitives[this.nonPrimSize++] = bytes;
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, bytes.length <= 32672 ? SnappyType.VARBINARY : SnappyType.BLOB);
                            ++this.size;
                        }
                        break block39;
                    }
                    case BLOB_VAL: {
                        this.ensureNonPrimCapacity();
                        BlobChunk blob = (BlobChunk)cv.getFieldValue();
                        if (blob != null) {
                            this.nonPrimitives[this.nonPrimSize++] = blob;
                            this.positionMap[this.size] = -this.nonPrimSize;
                            if (blob.isSetLobId()) {
                                this.ensureNonPrimCapacity();
                                ++this.nonPrimSize;
                            }
                            this.setType(this.size, SnappyType.BLOB);
                            ++this.size;
                        }
                        break block39;
                    }
                    case CLOB_VAL: {
                        this.ensureNonPrimCapacity();
                        ClobChunk clob = (ClobChunk)cv.getFieldValue();
                        if (clob != null) {
                            this.nonPrimitives[this.nonPrimSize++] = clob;
                            this.positionMap[this.size] = -this.nonPrimSize;
                            if (clob.isSetLobId()) {
                                this.ensureNonPrimCapacity();
                                ++this.nonPrimSize;
                            }
                            this.setType(this.size, SnappyType.CLOB);
                            ++this.size;
                        }
                        break block39;
                    }
                    case ARRAY_VAL: {
                        this.ensureNonPrimCapacity();
                        List arr = (List)cv.getFieldValue();
                        if (arr != null) {
                            this.nonPrimitives[this.nonPrimSize++] = arr;
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, SnappyType.ARRAY);
                            ++this.size;
                        }
                        break block39;
                    }
                    case MAP_VAL: {
                        this.ensureNonPrimCapacity();
                        Map map = (Map)cv.getFieldValue();
                        if (map != null) {
                            this.nonPrimitives[this.nonPrimSize++] = map;
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, SnappyType.MAP);
                            ++this.size;
                        }
                        break block39;
                    }
                    case STRUCT_VAL: {
                        this.ensureNonPrimCapacity();
                        List struct = (List)cv.getFieldValue();
                        if (struct != null) {
                            this.nonPrimitives[this.nonPrimSize++] = struct;
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, SnappyType.STRUCT);
                            ++this.size;
                        }
                        break block39;
                    }
                    case JSON_VAL: {
                        this.ensureNonPrimCapacity();
                        JSONObject jsonObj = (JSONObject)((Object)cv.getFieldValue());
                        if (jsonObj != null) {
                            this.nonPrimitives[this.nonPrimSize++] = jsonObj;
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, SnappyType.JSON);
                            ++this.size;
                        }
                        break block39;
                    }
                    case JAVA_VAL: {
                        this.ensureNonPrimCapacity();
                        byte[] serializedBytes = cv.getJava_val();
                        if (serializedBytes != null) {
                            this.nonPrimitives[this.nonPrimSize++] = Converters.getJavaObject(serializedBytes, this.size);
                            this.positionMap[this.size] = -this.nonPrimSize;
                            this.setType(this.size, SnappyType.JAVA_OBJECT);
                            ++this.size;
                        }
                        break block39;
                    }
                    case NULL_VAL: {
                        this.ensureNonPrimCapacity();
                        this.nonPrimitives[this.nonPrimSize++] = null;
                        this.positionMap[this.size] = -this.nonPrimSize;
                        this.setType(this.size, SnappyType.NULLTYPE);
                        ++this.size;
                        break block39;
                    }
                    default: {
                        throw ClientSharedUtils.newRuntimeException((String)("unknown column value: " + (cv.getFieldValue() != null ? cv : "null")), null);
                    }
                }
            }
            this.ensureNonPrimCapacity();
            this.nonPrimitives[this.nonPrimSize++] = null;
            this.positionMap[this.size] = -this.nonPrimSize;
            this.setType(this.size, SnappyType.NULLTYPE);
            ++this.size;
        }
    }

    protected final void ensureCapacity() {
        int capacity = this.positionMap.length;
        if (this.size >= capacity) {
            int newCapacity = capacity + (capacity >>> 1);
            int[] newMap = new int[newCapacity];
            System.arraycopy(this.positionMap, 0, newMap, 0, capacity);
            this.positionMap = newMap;
            if (this.types != null) {
                byte[] newTypes = new byte[newCapacity];
                System.arraycopy(this.types, 0, newTypes, 0, capacity);
                this.types = newTypes;
            }
        }
    }

    protected final void ensurePrimCapacity(int minCapacity) {
        if (this.primitives != null) {
            int capacity = this.primitives.length;
            if (this.primSize + minCapacity > capacity) {
                int newCapacity = capacity + (capacity >>> 1);
                byte[] newPrims = new byte[newCapacity];
                System.arraycopy(this.primitives, 0, newPrims, 0, capacity);
                this.primitives = newPrims;
            }
        } else {
            this.primitives = new byte[16];
        }
    }

    protected final void ensureNonPrimCapacity() {
        if (this.nonPrimitives != null) {
            int capacity = this.nonPrimitives.length;
            if (this.nonPrimSize >= capacity) {
                int newCapacity = capacity + (capacity >>> 1);
                Object[] newNonPrims = new Object[newCapacity];
                System.arraycopy(this.nonPrimitives, 0, newNonPrims, 0, capacity);
                this.nonPrimitives = newNonPrims;
            }
        } else {
            this.nonPrimitives = new Object[4];
        }
    }

    public final int size() {
        return this.size;
    }

    public void clear() {
        Arrays.fill(this.positionMap, 0);
        Arrays.fill(this.nonPrimitives, null);
        this.primSize = 0;
        this.nonPrimSize = 0;
        this.size = 0;
    }

    public int hashCode() {
        Object[] nps;
        byte[] b;
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        int[] posMap = this.positionMap;
        if (posMap != null && posMap.length > 0) {
            for (int pos : posMap) {
                h = 31 * h + pos;
            }
        }
        if ((b = this.types) != null && b.length > 0) {
            h = ResolverUtils.addBytesToHash((byte[])b, (int)h);
        }
        if ((b = this.primitives) != null && b.length > 0) {
            h = ResolverUtils.addBytesToHash((byte[])b, (int)h);
        }
        if ((nps = this.nonPrimitives) != null && nps.length > 0) {
            for (Object o : nps) {
                if (o == null) continue;
                h = 31 * h + o.hashCode();
            }
        }
        this.hash = h;
        return this.hash;
    }

    public boolean equals(Object other) {
        return other instanceof OptimizedElementArray && this.equals((OptimizedElementArray)other);
    }

    public boolean equals(OptimizedElementArray other) {
        return Arrays.equals(this.positionMap, other.positionMap) && Arrays.equals(this.types, other.types) && Arrays.equals(this.primitives, other.primitives) && Arrays.equals(this.nonPrimitives, other.nonPrimitives);
    }
}

