/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import io.snappydata.thrift.BlobChunk;
import io.snappydata.thrift.ClobChunk;
import io.snappydata.thrift.DateTime;
import io.snappydata.thrift.Decimal;
import io.snappydata.thrift.JSONObject;
import io.snappydata.thrift.SnappyType;
import io.snappydata.thrift.Timestamp;
import io.snappydata.thrift.common.ColumnValueConverter;
import io.snappydata.thrift.common.LobService;
import io.snappydata.thrift.common.OptimizedElementArray;
import io.snappydata.thrift.common.ThriftExceptionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class Converters {
    static final BigDecimal MAXLONG_PLUS_ONE = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
    static final BigDecimal MINLONG_MINUS_ONE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE);
    public static final ColumnValueConverter BOOLEAN_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.BOOLEAN;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getBoolean(columnIndex - 1);
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getBoolean(columnIndex - 1) ? BigDecimal.ONE : BigDecimal.ZERO;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getBoolean(columnIndex - 1) ? "true" : "false";
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getBoolean(columnIndex - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
            row.setBoolean(columnIndex - 1, x);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
            row.setBoolean(columnIndex - 1, x != 0);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
            row.setBoolean(columnIndex - 1, x != 0);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
            row.setBoolean(columnIndex - 1, x != 0);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
            row.setBoolean(columnIndex - 1, x != 0L);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
            row.setBoolean(columnIndex - 1, x != 0.0f);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
            row.setBoolean(columnIndex - 1, x != 0.0);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
            row.setBoolean(columnIndex - 1, !BigDecimal.ZERO.equals(x));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            row.setBoolean(columnIndex - 1, x != null && !x.equals("0") && !x.equalsIgnoreCase("false"));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            Class<?> c = o.getClass();
            if (c == Boolean.class) {
                this.setBoolean(row, columnIndex, (Boolean)o);
            } else if (c == Byte.class) {
                this.setByte(row, columnIndex, (Byte)o);
            } else if (c == Integer.class) {
                this.setInteger(row, columnIndex, (Integer)o);
            } else if (c == Short.class) {
                this.setShort(row, columnIndex, (Short)o);
            } else if (c == Long.class) {
                this.setLong(row, columnIndex, (Long)o);
            } else if (c == Float.class) {
                this.setFloat(row, columnIndex, ((Float)o).floatValue());
            } else if (c == Double.class) {
                this.setDouble(row, columnIndex, (Double)o);
            } else if (o instanceof BigDecimal) {
                this.setBigDecimal(row, columnIndex, (BigDecimal)o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(c.getName(), "boolean");
            }
        }
    };
    public static final ColumnValueConverter BYTE_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.TINYINT;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1) != 0;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            return new BigDecimal(row.getByte(columnIndex - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return Byte.toString(row.getByte(columnIndex - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getByte(columnIndex - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
            row.setByte(columnIndex - 1, x ? (byte)1 : 0);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
            row.setByte(columnIndex - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
            if (x < -128 || x > 127) {
                throw Converters.newOutOfRangeException("byte", columnIndex);
            }
            row.setByte(columnIndex - 1, (byte)x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
            if (x < -128 || x > 127) {
                throw Converters.newOutOfRangeException("byte", columnIndex);
            }
            row.setByte(columnIndex - 1, (byte)x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
            if (x < -128L || x > 127L) {
                throw Converters.newOutOfRangeException("byte", columnIndex);
            }
            row.setByte(columnIndex - 1, (byte)x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
            if (!(x >= -128.0f) || !(x <= 127.0f)) {
                throw Converters.newOutOfRangeException("byte", columnIndex);
            }
            row.setByte(columnIndex - 1, (byte)x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
            if (!(x >= -128.0) || !(x <= 127.0)) {
                throw Converters.newOutOfRangeException("byte", columnIndex);
            }
            row.setByte(columnIndex - 1, (byte)x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
            this.setLong(row, columnIndex, Converters.getLong(x, columnIndex));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            this.setLong(row, columnIndex, Converters.getLong(x, columnIndex));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            Class<?> c = o.getClass();
            if (c == Byte.class) {
                this.setByte(row, columnIndex, (Byte)o);
            } else if (c == Integer.class) {
                this.setInteger(row, columnIndex, (Integer)o);
            } else if (c == Short.class) {
                this.setShort(row, columnIndex, (Short)o);
            } else if (c == Long.class) {
                this.setLong(row, columnIndex, (Long)o);
            } else if (c == Boolean.class) {
                this.setBoolean(row, columnIndex, (Boolean)o);
            } else if (c == Float.class) {
                this.setFloat(row, columnIndex, ((Float)o).floatValue());
            } else if (c == Double.class) {
                this.setDouble(row, columnIndex, (Double)o);
            } else if (o instanceof BigDecimal) {
                this.setBigDecimal(row, columnIndex, (BigDecimal)o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(c.getName(), "byte");
            }
        }
    };
    public static final ColumnValueConverter SHORT_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.SMALLINT;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getShort(columnIndex - 1) != 0;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            short v = row.getShort(columnIndex - 1);
            if (v >= -128 && v <= 127) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnIndex);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getShort(columnIndex - 1);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getShort(columnIndex - 1);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getShort(columnIndex - 1);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getShort(columnIndex - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getShort(columnIndex - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            return new BigDecimal(row.getShort(columnIndex - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return Short.toString(row.getShort(columnIndex - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return (int)row.getShort(columnIndex - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
            row.setShort(columnIndex - 1, x ? (short)1 : 0);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
            row.setShort(columnIndex - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
            row.setShort(columnIndex - 1, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
            if (x < Short.MIN_VALUE || x > Short.MAX_VALUE) {
                throw Converters.newOutOfRangeException("short", columnIndex);
            }
            row.setShort(columnIndex - 1, (short)x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
            if (x < -32768L || x > 32767L) {
                throw Converters.newOutOfRangeException("short", columnIndex);
            }
            row.setShort(columnIndex - 1, (short)x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
            if (!(x >= -32768.0f) || !(x <= 32767.0f)) {
                throw Converters.newOutOfRangeException("short", columnIndex);
            }
            row.setShort(columnIndex - 1, (short)x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
            if (!(x >= -32768.0) || !(x <= 32767.0)) {
                throw Converters.newOutOfRangeException("short", columnIndex);
            }
            row.setShort(columnIndex - 1, (short)x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
            this.setLong(row, columnIndex, Converters.getLong(x, columnIndex));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            this.setLong(row, columnIndex, Converters.getLong(x, columnIndex));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            Class<?> c = o.getClass();
            if (c == Short.class) {
                this.setShort(row, columnIndex, (Short)o);
            } else if (c == Integer.class) {
                this.setInteger(row, columnIndex, (Integer)o);
            } else if (c == Byte.class) {
                this.setByte(row, columnIndex, (Byte)o);
            } else if (c == Long.class) {
                this.setLong(row, columnIndex, (Long)o);
            } else if (c == Boolean.class) {
                this.setBoolean(row, columnIndex, (Boolean)o);
            } else if (c == Float.class) {
                this.setFloat(row, columnIndex, ((Float)o).floatValue());
            } else if (c == Double.class) {
                this.setDouble(row, columnIndex, (Double)o);
            } else if (o instanceof BigDecimal) {
                this.setBigDecimal(row, columnIndex, (BigDecimal)o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(c.getName(), "short");
            }
        }
    };
    public static final ColumnValueConverter INT_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.INTEGER;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getInt(columnIndex - 1) != 0;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            int v = row.getInt(columnIndex - 1);
            if (v >= -128 && v <= 127) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnIndex);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            int v = row.getInt(columnIndex - 1);
            if (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnIndex);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getInt(columnIndex - 1);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getInt(columnIndex - 1);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getInt(columnIndex - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getInt(columnIndex - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            return new BigDecimal(row.getInt(columnIndex - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return Integer.toString(row.getInt(columnIndex - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getInt(columnIndex - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
            row.setInt(columnIndex - 1, x ? 1 : 0);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
            row.setInt(columnIndex - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
            row.setInt(columnIndex - 1, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
            row.setInt(columnIndex - 1, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
            if (x < Integer.MIN_VALUE || x > Integer.MAX_VALUE) {
                throw Converters.newOutOfRangeException("int", columnIndex);
            }
            row.setInt(columnIndex - 1, (int)x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
            if (!(x >= -2.1474836E9f) || !(x <= 2.1474836E9f)) {
                throw Converters.newOutOfRangeException("int", columnIndex);
            }
            row.setInt(columnIndex - 1, (int)x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
            if (!(x >= -2.147483648E9) || !(x <= 2.147483647E9)) {
                throw Converters.newOutOfRangeException("int", columnIndex);
            }
            row.setInt(columnIndex - 1, (int)x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
            this.setLong(row, columnIndex, Converters.getLong(x, columnIndex));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            this.setLong(row, columnIndex, Converters.getLong(x, columnIndex));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            Class<?> c = o.getClass();
            if (c == Integer.class) {
                this.setInteger(row, columnIndex, (Integer)o);
            } else if (c == Byte.class) {
                this.setByte(row, columnIndex, (Byte)o);
            } else if (c == Short.class) {
                this.setShort(row, columnIndex, (Short)o);
            } else if (c == Long.class) {
                this.setLong(row, columnIndex, (Long)o);
            } else if (c == Boolean.class) {
                this.setBoolean(row, columnIndex, (Boolean)o);
            } else if (c == Float.class) {
                this.setFloat(row, columnIndex, ((Float)o).floatValue());
            } else if (c == Double.class) {
                this.setDouble(row, columnIndex, (Double)o);
            } else if (o instanceof BigDecimal) {
                this.setBigDecimal(row, columnIndex, (BigDecimal)o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(c.getName(), "int");
            }
        }
    };
    public static final ColumnValueConverter LONG_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.BIGINT;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getLong(columnIndex - 1) != 0L;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            long v = row.getLong(columnIndex - 1);
            if (v >= -128L && v <= 127L) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnIndex);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            long v = row.getLong(columnIndex - 1);
            if (v >= -32768L && v <= 32767L) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnIndex);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            long v = row.getLong(columnIndex - 1);
            if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                return (int)v;
            }
            throw Converters.newOutOfRangeException("int", columnIndex);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getLong(columnIndex - 1);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getLong(columnIndex - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getLong(columnIndex - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            return new BigDecimal(row.getLong(columnIndex - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return Long.toString(row.getLong(columnIndex - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getLong(columnIndex - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
            row.setLong(columnIndex - 1, x ? 1L : 0L);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
            row.setLong(columnIndex - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
            row.setLong(columnIndex - 1, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
            row.setLong(columnIndex - 1, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
            row.setLong(columnIndex - 1, x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
            if (!(x >= -9.223372E18f) || !(x <= 9.223372E18f)) {
                throw Converters.newOutOfRangeException("long", columnIndex);
            }
            row.setLong(columnIndex - 1, (long)x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
            if (!(x >= -9.223372036854776E18) || !(x <= 9.223372036854776E18)) {
                throw Converters.newOutOfRangeException("long", columnIndex);
            }
            row.setLong(columnIndex - 1, (long)x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
            this.setLong(row, columnIndex, Converters.getLong(x, columnIndex));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            this.setLong(row, columnIndex, Converters.getLong(x, columnIndex));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            Class<?> c = o.getClass();
            if (c == Long.class) {
                this.setLong(row, columnIndex, (Long)o);
            } else if (c == Integer.class) {
                this.setInteger(row, columnIndex, (Integer)o);
            } else if (c == Byte.class) {
                this.setByte(row, columnIndex, (Byte)o);
            } else if (c == Short.class) {
                this.setShort(row, columnIndex, (Short)o);
            } else if (c == Boolean.class) {
                this.setBoolean(row, columnIndex, (Boolean)o);
            } else if (c == Float.class) {
                this.setFloat(row, columnIndex, ((Float)o).floatValue());
            } else if (c == Double.class) {
                this.setDouble(row, columnIndex, (Double)o);
            } else if (o instanceof BigDecimal) {
                this.setBigDecimal(row, columnIndex, (BigDecimal)o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(c.getName(), "long");
            }
        }
    };
    public static final ColumnValueConverter REAL_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.REAL;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getFloat(columnIndex - 1) != 0.0f;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            float v = row.getFloat(columnIndex - 1);
            if (v >= -128.0f && v <= 127.0f) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnIndex);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            float v = row.getFloat(columnIndex - 1);
            if (v >= -32768.0f && v <= 32767.0f) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnIndex);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            float v = row.getFloat(columnIndex - 1);
            if (v >= -2.1474836E9f && v <= 2.1474836E9f) {
                return (int)v;
            }
            throw Converters.newOutOfRangeException("int", columnIndex);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            float v = row.getFloat(columnIndex - 1);
            if (v >= -9.223372E18f && v <= 9.223372E18f) {
                return (long)v;
            }
            throw Converters.newOutOfRangeException("long", columnIndex);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getFloat(columnIndex - 1);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getFloat(columnIndex - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            return new BigDecimal(row.getFloat(columnIndex - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return Float.toString(row.getFloat(columnIndex - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return Float.valueOf(row.getFloat(columnIndex - 1));
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
            row.setFloat(columnIndex - 1, x ? 1.0f : 0.0f);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
            row.setFloat(columnIndex - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
            row.setFloat(columnIndex - 1, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
            row.setFloat(columnIndex - 1, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
            if (!((float)x >= Float.MIN_VALUE)) {
                throw Converters.newOutOfRangeException("float", columnIndex);
            }
            row.setFloat(columnIndex - 1, x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
            row.setFloat(columnIndex - 1, x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
            if (!(x >= (double)1.4E-45f) || !(x <= 3.4028234663852886E38)) {
                throw Converters.newOutOfRangeException("float", columnIndex);
            }
            row.setFloat(columnIndex - 1, (float)x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
            this.setDouble(row, columnIndex, Converters.getDouble(x, columnIndex));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            this.setDouble(row, columnIndex, Converters.getDouble(x, columnIndex));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            Class<?> c = o.getClass();
            if (c == Float.class) {
                this.setFloat(row, columnIndex, ((Float)o).floatValue());
            } else if (c == Double.class) {
                this.setDouble(row, columnIndex, (Double)o);
            } else if (c == Integer.class) {
                this.setInteger(row, columnIndex, (Integer)o);
            } else if (c == Byte.class) {
                this.setByte(row, columnIndex, (Byte)o);
            } else if (c == Short.class) {
                this.setShort(row, columnIndex, (Short)o);
            } else if (c == Long.class) {
                this.setLong(row, columnIndex, (Long)o);
            } else if (c == Boolean.class) {
                this.setBoolean(row, columnIndex, (Boolean)o);
            } else if (o instanceof BigDecimal) {
                this.setBigDecimal(row, columnIndex, (BigDecimal)o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(c.getName(), "float");
            }
        }
    };
    public static final ColumnValueConverter DOUBLE_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.DOUBLE;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getDouble(columnIndex - 1) != 0.0;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            double v = row.getDouble(columnIndex - 1);
            if (v >= -128.0 && v <= 127.0) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnIndex);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            double v = row.getDouble(columnIndex - 1);
            if (v >= -32768.0 && v <= 32767.0) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnIndex);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            double v = row.getDouble(columnIndex - 1);
            if (v >= -2.147483648E9 && v <= 2.147483647E9) {
                return (int)v;
            }
            throw Converters.newOutOfRangeException("int", columnIndex);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            double v = row.getDouble(columnIndex - 1);
            if (v >= -9.223372036854776E18 && v <= 9.223372036854776E18) {
                return (long)v;
            }
            throw Converters.newOutOfRangeException("long", columnIndex);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            double v = row.getDouble(columnIndex - 1);
            if (v >= (double)1.4E-45f && v <= 3.4028234663852886E38) {
                return (float)v;
            }
            throw Converters.newOutOfRangeException("float", columnIndex);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            return row.getDouble(columnIndex - 1);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            return new BigDecimal(row.getDouble(columnIndex - 1));
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return Double.toString(row.getDouble(columnIndex - 1));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getDouble(columnIndex - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
            row.setDouble(columnIndex - 1, x ? 1.0 : 0.0);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
            row.setDouble(columnIndex - 1, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
            row.setDouble(columnIndex - 1, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
            row.setDouble(columnIndex - 1, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
            row.setDouble(columnIndex - 1, x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
            row.setDouble(columnIndex - 1, x);
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
            row.setDouble(columnIndex - 1, x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
            this.setDouble(row, columnIndex, Converters.getDouble(x, columnIndex));
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            this.setDouble(row, columnIndex, Converters.getDouble(x, columnIndex));
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            Class<?> c = o.getClass();
            if (c == Double.class) {
                this.setDouble(row, columnIndex, (Double)o);
            } else if (c == Float.class) {
                this.setFloat(row, columnIndex, ((Float)o).floatValue());
            } else if (c == Integer.class) {
                this.setInteger(row, columnIndex, (Integer)o);
            } else if (c == Byte.class) {
                this.setByte(row, columnIndex, (Byte)o);
            } else if (c == Short.class) {
                this.setShort(row, columnIndex, (Short)o);
            } else if (c == Long.class) {
                this.setLong(row, columnIndex, (Long)o);
            } else if (c == Boolean.class) {
                this.setBoolean(row, columnIndex, (Boolean)o);
            } else if (o instanceof BigDecimal) {
                this.setBigDecimal(row, columnIndex, (BigDecimal)o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(c.getName(), "double");
            }
        }
    };
    public static final ColumnValueConverter DECIMAL_TYPE = new ColumnValueConverter(){

        @Override
        public final SnappyType getType() {
            return SnappyType.DECIMAL;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            BigDecimal bd = (BigDecimal)row.getObject(columnIndex - 1);
            return bd != null && !bd.equals(BigDecimal.ZERO);
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            long v = this.toLong(row, columnIndex);
            if (v >= -128L && v <= 127L) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnIndex);
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            long v = this.toLong(row, columnIndex);
            if (v >= -32768L && v <= 32767L) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnIndex);
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            long v = this.toLong(row, columnIndex);
            if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                return (int)v;
            }
            throw Converters.newOutOfRangeException("int", columnIndex);
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            BigDecimal decimal = (BigDecimal)row.getObject(columnIndex - 1);
            return Converters.getLong(decimal, columnIndex);
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            double v = Converters.getDouble((BigDecimal)row.getObject(columnIndex - 1), columnIndex);
            if (v >= (double)1.4E-45f && v <= 3.4028234663852886E38) {
                return (float)v;
            }
            throw Converters.newOutOfRangeException("float", columnIndex);
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            return Converters.getDouble((BigDecimal)row.getObject(columnIndex - 1), columnIndex);
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            return (BigDecimal)row.getObject(columnIndex - 1);
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            BigDecimal bd = (BigDecimal)row.getObject(columnIndex - 1);
            if (bd != null) {
                return bd.toPlainString();
            }
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
            this.setBigDecimal(row, columnIndex, x ? BigDecimal.ONE : BigDecimal.ZERO);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
            this.setBigDecimal(row, columnIndex, new BigDecimal(x));
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
            this.setBigDecimal(row, columnIndex, new BigDecimal(x));
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
            this.setBigDecimal(row, columnIndex, new BigDecimal(x));
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
            this.setBigDecimal(row, columnIndex, new BigDecimal(x));
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
            this.setBigDecimal(row, columnIndex, new BigDecimal(x));
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
            this.setBigDecimal(row, columnIndex, new BigDecimal(x));
        }

        @Override
        public final void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.DECIMAL);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            if (o instanceof BigDecimal) {
                this.setBigDecimal(row, columnIndex, (BigDecimal)o);
            } else {
                Class<?> c = o.getClass();
                if (c == Double.class) {
                    this.setDouble(row, columnIndex, (Double)o);
                } else if (c == Float.class) {
                    this.setFloat(row, columnIndex, ((Float)o).floatValue());
                } else if (c == Integer.class) {
                    this.setInteger(row, columnIndex, (Integer)o);
                } else if (c == Byte.class) {
                    this.setByte(row, columnIndex, (Byte)o);
                } else if (c == Short.class) {
                    this.setShort(row, columnIndex, (Short)o);
                } else if (c == Long.class) {
                    this.setLong(row, columnIndex, (Long)o);
                } else if (c == Boolean.class) {
                    this.setBoolean(row, columnIndex, (Boolean)o);
                } else if (o instanceof String) {
                    this.setString(row, columnIndex, (String)o);
                } else {
                    throw Converters.newTypeConversionException(c.getName(), "BigDecimal");
                }
            }
        }
    };
    public static final ColumnValueConverter DATE_TYPE = new ColumnValueConverter(){

        @Override
        public final SnappyType getType() {
            return SnappyType.DATE;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            Date date = (Date)row.getObject(columnIndex - 1);
            if (date != null) {
                return date.toString();
            }
            return null;
        }

        @Override
        public Date toDate(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            Date date = (Date)row.getObject(columnIndex - 1);
            if (cal == null) {
                return date;
            }
            cal.setTime(date);
            return new Date(cal.getTimeInMillis());
        }

        @Override
        public java.sql.Timestamp toTimestamp(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            Date date = (Date)row.getObject(columnIndex - 1);
            if (cal == null) {
                return new java.sql.Timestamp(date.getTime());
            }
            cal.setTime(date);
            return new java.sql.Timestamp(cal.getTimeInMillis());
        }

        @Override
        public Time toTime(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            Date date = (Date)row.getObject(columnIndex - 1);
            if (cal == null) {
                return new Time(date.getTime());
            }
            cal.setTime(date);
            return new Time(cal.getTimeInMillis());
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnIndex, Date x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.DATE);
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnIndex, java.sql.Timestamp x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.TIMESTAMP);
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnIndex, Time x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.TIME);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            if (o instanceof Date) {
                this.setDate(row, columnIndex, (Date)o);
            } else if (o instanceof Time) {
                this.setTime(row, columnIndex, (Time)o);
            } else if (o instanceof java.sql.Timestamp) {
                this.setTimestamp(row, columnIndex, (java.sql.Timestamp)o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(o.getClass().getName(), "Date");
            }
        }
    };
    public static final ColumnValueConverter TIME_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.TIME;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            Time time = (Time)row.getObject(columnIndex - 1);
            if (time != null) {
                return time.toString();
            }
            return null;
        }

        @Override
        public Date toDate(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            Time time = (Time)row.getObject(columnIndex - 1);
            if (cal == null) {
                return new Date(time.getTime());
            }
            cal.setTime(time);
            return new Date(cal.getTimeInMillis());
        }

        @Override
        public java.sql.Timestamp toTimestamp(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            Time time = (Time)row.getObject(columnIndex - 1);
            if (cal == null) {
                return new java.sql.Timestamp(time.getTime());
            }
            cal.setTime(time);
            return new java.sql.Timestamp(cal.getTimeInMillis());
        }

        @Override
        public Time toTime(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            Time time = (Time)row.getObject(columnIndex - 1);
            if (cal == null) {
                return time;
            }
            cal.setTime(time);
            return new Time(cal.getTimeInMillis());
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnIndex, Date x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.DATE);
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnIndex, java.sql.Timestamp x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.TIMESTAMP);
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnIndex, Time x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.TIME);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            if (o instanceof Time) {
                this.setTime(row, columnIndex, (Time)o);
            } else if (o instanceof Date) {
                this.setDate(row, columnIndex, (Date)o);
            } else if (o instanceof java.sql.Timestamp) {
                this.setTimestamp(row, columnIndex, (java.sql.Timestamp)o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(o.getClass().getName(), "Time");
            }
        }
    };
    public static final ColumnValueConverter TIMESTAMP_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.TIMESTAMP;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            java.sql.Timestamp ts = (java.sql.Timestamp)row.getObject(columnIndex - 1);
            if (ts != null) {
                return ts.toString();
            }
            return null;
        }

        @Override
        public Date toDate(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            java.sql.Timestamp ts = (java.sql.Timestamp)row.getObject(columnIndex - 1);
            if (cal == null) {
                return new Date(ts.getTime());
            }
            cal.setTime(ts);
            return new Date(cal.getTimeInMillis());
        }

        @Override
        public java.sql.Timestamp toTimestamp(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            java.sql.Timestamp ts = (java.sql.Timestamp)row.getObject(columnIndex - 1);
            if (cal == null) {
                return ts;
            }
            cal.setTime(ts);
            return new java.sql.Timestamp(cal.getTimeInMillis());
        }

        @Override
        public Time toTime(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            java.sql.Timestamp ts = (java.sql.Timestamp)row.getObject(columnIndex - 1);
            if (cal == null) {
                return new Time(ts.getTime());
            }
            cal.setTime(ts);
            return new Time(cal.getTimeInMillis());
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnIndex, Date x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.DATE);
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnIndex, java.sql.Timestamp x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.TIMESTAMP);
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnIndex, Time x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.TIME);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            if (o instanceof java.sql.Timestamp) {
                this.setTimestamp(row, columnIndex, (java.sql.Timestamp)o);
            } else if (o instanceof Date) {
                this.setDate(row, columnIndex, (Date)o);
            } else if (o instanceof Time) {
                this.setTime(row, columnIndex, (Time)o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(o.getClass().getName(), "Timestamp");
            }
        }
    };
    public static final ColumnValueConverter STRING_TYPE = new StringConverter();
    public static final ColumnValueConverter CLOB_TYPE = new StringConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.CLOB;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return Converters.getClobAsString(row.getClobChunk(columnIndex - 1, true), lobService);
        }

        @Override
        public final Clob toClob(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return lobService.createClob(row.getClobChunk(columnIndex - 1, true));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return this.toClob(row, columnIndex, lobService);
        }
    };
    public static final ColumnValueConverter BINARY_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.VARBINARY;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            byte[] bytes = (byte[])row.getObject(columnIndex - 1);
            if (bytes != null) {
                return ClientSharedUtils.toHexString((byte[])bytes, (int)0, (int)bytes.length);
            }
            return null;
        }

        @Override
        public byte[] toBytes(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return (byte[])row.getObject(columnIndex - 1);
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public final void setBytes(OptimizedElementArray row, int columnIndex, byte[] x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARBINARY);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            try {
                byte[] bytes = ClientSharedUtils.fromHexString((String)x, (int)0, (int)x.length());
                this.setBytes(row, columnIndex, bytes);
            }
            catch (IllegalArgumentException iae) {
                throw Converters.newTypeConversionException("String", this.getType().toString(), iae);
            }
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            if (o instanceof byte[]) {
                this.setBytes(row, columnIndex, (byte[])o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(o.getClass().getName(), "byte[]");
            }
        }
    };
    public static final ColumnValueConverter BLOB_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.BLOB;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            byte[] bytes = this.toBytes(row, columnIndex, lobService);
            if (bytes != null) {
                return ClientSharedUtils.toHexString((byte[])bytes, (int)0, (int)bytes.length);
            }
            return null;
        }

        @Override
        public final byte[] toBytes(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return Converters.getBlobAsBytes(row.getBlobChunk(columnIndex - 1, true), lobService);
        }

        @Override
        public final Blob toBlob(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return lobService.createBlob(row.getBlobChunk(columnIndex - 1, true));
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return this.toBlob(row, columnIndex, lobService);
        }

        @Override
        public final void setBytes(OptimizedElementArray row, int columnIndex, byte[] x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARBINARY);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            try {
                byte[] bytes = ClientSharedUtils.fromHexString((String)x, (int)0, (int)x.length());
                this.setBytes(row, columnIndex, bytes);
            }
            catch (IllegalArgumentException iae) {
                throw Converters.newTypeConversionException("String", this.getType().toString(), iae);
            }
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            if (o instanceof byte[]) {
                this.setBytes(row, columnIndex, (byte[])o);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(o.getClass().getName(), "Blob");
            }
        }
    };
    public static final ColumnValueConverter OBJECT_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.JAVA_OBJECT;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            if (o instanceof Byte) {
                return (Byte)o != 0;
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "boolean");
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof Number) {
                return ((Number)o).byteValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "byte");
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof Number) {
                return ((Number)o).shortValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "short");
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof Number) {
                return ((Number)o).intValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "int");
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "long");
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof Number) {
                return ((Number)o).floatValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "float");
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof Number) {
                return ((Number)o).doubleValue();
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "double");
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof BigDecimal) {
                return (BigDecimal)o;
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "BigDecimal");
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o != null) {
                return o.toString();
            }
            return null;
        }

        @Override
        public Date toDate(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof Date) {
                return (Date)o;
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "Date");
        }

        @Override
        public java.sql.Timestamp toTimestamp(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof java.sql.Timestamp) {
                return (java.sql.Timestamp)o;
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "Timestamp");
        }

        @Override
        public Time toTime(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof Time) {
                return (Time)o;
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "Time");
        }

        @Override
        public byte[] toBytes(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o instanceof byte[]) {
                return (byte[])o;
            }
            throw Converters.newTypeConversionException(this.getType().toString(), "byte[]");
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
            this.setObject(row, columnIndex, Float.valueOf(x));
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public final void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnIndex, Date x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnIndex, java.sql.Timestamp x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnIndex, Time x) throws SQLException {
            this.setObject(row, columnIndex, x);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            row.setObject(columnIndex - 1, o, SnappyType.JAVA_OBJECT);
        }
    };
    public static final ColumnValueConverter ARRAY_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.ARRAY;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o != null) {
                return o.toString();
            }
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            if (o instanceof List) {
                row.setObject(columnIndex - 1, o, SnappyType.ARRAY);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(o.getClass().getName(), "ARRAY");
            }
        }
    };
    public static final ColumnValueConverter MAP_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.MAP;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o != null) {
                return o.toString();
            }
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            if (o instanceof Map) {
                row.setObject(columnIndex - 1, o, SnappyType.MAP);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(o.getClass().getName(), "MAP");
            }
        }
    };
    public static final ColumnValueConverter STRUCT_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.STRUCT;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o != null) {
                return o.toString();
            }
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            if (o instanceof List) {
                row.setObject(columnIndex - 1, o, SnappyType.STRUCT);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(o.getClass().getName(), "STRUCT");
            }
        }
    };
    public static final ColumnValueConverter JSON_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.JSON;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            Object o = row.getObject(columnIndex - 1);
            if (o != null) {
                return o.toString();
            }
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            if (o instanceof JSONObject) {
                row.setObject(columnIndex - 1, o, SnappyType.JSON);
            } else if (o instanceof String) {
                this.setString(row, columnIndex, (String)o);
            } else {
                throw Converters.newTypeConversionException(o.getClass().getName(), "JSON");
            }
        }
    };
    public static final ColumnValueConverter NULL_TYPE = new ColumnValueConverter(){

        @Override
        public SnappyType getType() {
            return SnappyType.NULLTYPE;
        }

        @Override
        public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            return false;
        }

        @Override
        public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            return 0;
        }

        @Override
        public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            return 0;
        }

        @Override
        public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            return 0;
        }

        @Override
        public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            return 0L;
        }

        @Override
        public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            return 0.0f;
        }

        @Override
        public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            return 0.0;
        }

        @Override
        public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            return BigDecimal.ZERO;
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public Date toDate(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            return null;
        }

        @Override
        public java.sql.Timestamp toTimestamp(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            return null;
        }

        @Override
        public Time toTime(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            return null;
        }

        @Override
        public byte[] toBytes(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return null;
        }

        @Override
        public void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            throw new AssertionError((Object)"unexpected invocation");
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object x) throws SQLException {
            throw new AssertionError((Object)"unexpected invocation");
        }

        @Override
        public boolean isNull() {
            return true;
        }
    };
    static final ColumnValueConverter[] typeConverters;

    private Converters() {
    }

    public static SQLException newTypeConversionException(String sourceType, String targetType, Throwable cause) {
        return ThriftExceptionUtil.newSQLException("22005", cause, sourceType, targetType, null);
    }

    public static SQLException newTypeConversionException(String sourceType, String targetType) {
        return Converters.newTypeConversionException(sourceType, targetType, null);
    }

    public static SQLException newOutOfRangeException(String type, int column) {
        return Converters.newOutOfRangeException(type, column, null);
    }

    public static SQLException newOutOfRangeException(String type, int column, Throwable cause) {
        return ThriftExceptionUtil.newSQLException("22003", cause, type, column);
    }

    public static SQLException newFormatException(String type, int column, Throwable cause) {
        return ThriftExceptionUtil.newSQLException("22018", cause, type, column);
    }

    public static ColumnValueConverter getConverter(SnappyType type, String targetType) throws SQLException {
        ColumnValueConverter converter = typeConverters[type.ordinal()];
        if (converter != null) {
            return converter;
        }
        throw Converters.newTypeConversionException(type.toString(), targetType);
    }

    public static BigDecimal getBigDecimal(Decimal decimal) {
        return new BigDecimal(new BigInteger((int)decimal.signum, decimal.getMagnitude()), decimal.scale);
    }

    public static Decimal getDecimal(BigDecimal decimal) {
        decimal = Converters.adjustScale(decimal);
        BigInteger bi = decimal.unscaledValue();
        return new Decimal((byte)bi.signum(), decimal.scale(), ByteBuffer.wrap(bi.abs().toByteArray()));
    }

    public static DateTime getDateTime(java.util.Date date) {
        return new DateTime(date.getTime() / 1000L);
    }

    public static BigDecimal adjustScale(BigDecimal decimal) {
        if (decimal.scale() >= 0) {
            return decimal;
        }
        return decimal.setScale(0, 7);
    }

    public static long getLong(String str, int columnIndex) throws SQLException {
        if (str != null) {
            try {
                return Long.parseLong(str.trim());
            }
            catch (NumberFormatException nfe) {
                throw Converters.newFormatException("long", columnIndex, nfe);
            }
        }
        return 0L;
    }

    public static long getLong(BigDecimal decimal, int columnIndex) throws SQLException {
        if (decimal != null) {
            if (decimal.compareTo(MINLONG_MINUS_ONE) == 1 && decimal.compareTo(MAXLONG_PLUS_ONE) == -1) {
                return decimal.longValue();
            }
            throw Converters.newOutOfRangeException("long", columnIndex);
        }
        return 0L;
    }

    public static double getDouble(String str, int columnIndex) throws SQLException {
        if (str != null) {
            try {
                return Double.parseDouble(str.trim());
            }
            catch (NumberFormatException nfe) {
                throw Converters.newFormatException("double", columnIndex, nfe);
            }
        }
        return 0.0;
    }

    public static double getDouble(BigDecimal decimal, int columnIndex) throws SQLException {
        if (decimal != null) {
            double v = decimal.doubleValue();
            if (!Double.isNaN(v) && !Double.isInfinite(v)) {
                return v;
            }
            throw Converters.newOutOfRangeException("double", columnIndex);
        }
        return 0.0;
    }

    public static java.sql.Timestamp getTimestamp(Timestamp ts) {
        java.sql.Timestamp jts = new java.sql.Timestamp(ts.secsSinceEpoch * 1000L);
        if (ts.isSetNanos()) {
            jts.setNanos(ts.nanos);
        }
        return jts;
    }

    public static Timestamp getTimestamp(java.sql.Timestamp jts) {
        Timestamp ts = new Timestamp(jts.getTime() / 1000L);
        int nanos = jts.getNanos();
        if (nanos != 0) {
            ts.setNanos(nanos);
        }
        return ts;
    }

    public static String getClobAsString(ClobChunk clob, LobService lobService) throws SQLException {
        if (clob.last) {
            return clob.chunk;
        }
        long totalLength = clob.getTotalLength();
        if (totalLength <= 0L) {
            throw ThriftExceptionUtil.newSQLException("XJ071.S", null, totalLength);
        }
        if (totalLength > Integer.MAX_VALUE) {
            throw ThriftExceptionUtil.newSQLException("XJ093.S", null, Long.toString(totalLength), Long.toString(Integer.MAX_VALUE));
        }
        if (!clob.isSetLobId()) {
            throw ThriftExceptionUtil.newSQLException("XJ217.S", new RuntimeException("missing LOB id"), new Object[0]);
        }
        int lobId = clob.lobId;
        StringBuilder sb = new StringBuilder((int)totalLength);
        String chunk = clob.chunk;
        sb.append(chunk);
        int offset = 0;
        while (!clob.last) {
            int chunkSize = chunk.length();
            clob = lobService.getClobChunk(lobId, offset += chunkSize, chunkSize, true);
            chunk = clob.chunk;
            sb.append(chunk);
        }
        return sb.toString();
    }

    public static byte[] getBlobAsBytes(BlobChunk blob, LobService lobService) throws SQLException {
        if (blob.last) {
            return blob.getChunk();
        }
        long totalLength = blob.getTotalLength();
        if (totalLength <= 0L) {
            throw ThriftExceptionUtil.newSQLException("XJ071.S", null, totalLength);
        }
        if (totalLength > Integer.MAX_VALUE) {
            throw ThriftExceptionUtil.newSQLException("XJ093.S", null, Long.toString(totalLength), Long.toString(Integer.MAX_VALUE));
        }
        if (!blob.isSetLobId()) {
            throw ThriftExceptionUtil.newSQLException("XJ217.S", new RuntimeException("missing LOB id"), new Object[0]);
        }
        int lobId = blob.lobId;
        byte[] fullBytes = new byte[(int)totalLength];
        byte[] chunk = blob.getChunk();
        int chunkSize = chunk.length;
        System.arraycopy(chunk, 0, fullBytes, 0, chunkSize);
        int offset = 0;
        while (!blob.last) {
            blob = lobService.getBlobChunk(lobId, offset += chunkSize, chunkSize, true);
            chunk = blob.getChunk();
            chunkSize = chunk.length;
            System.arraycopy(chunk, 0, fullBytes, offset, chunkSize);
        }
        return fullBytes;
    }

    public static Object getJavaObject(byte[] bytes, int columnIndex) throws SQLException {
        Object obj;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            obj = new ObjectInputStream(in).readObject();
        }
        catch (Exception e) {
            throw ThriftExceptionUtil.newSQLException("XCL30.S", e, columnIndex);
        }
        return obj;
    }

    public static byte[] getJavaObjectAsBytes(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bos);
        os.writeObject(o);
        os.flush();
        return bos.toByteArray();
    }

    public static int getJdbcType(SnappyType type) {
        switch (type) {
            case ARRAY: {
                return 2003;
            }
            case BIGINT: {
                return -5;
            }
            case BINARY: {
                return -2;
            }
            case BLOB: {
                return 2004;
            }
            case BOOLEAN: {
                return 16;
            }
            case CHAR: {
                return 1;
            }
            case CLOB: {
                return 2005;
            }
            case DATE: {
                return 91;
            }
            case DECIMAL: {
                return 3;
            }
            case DOUBLE: {
                return 8;
            }
            case FLOAT: {
                return 6;
            }
            case INTEGER: {
                return 4;
            }
            case JAVA_OBJECT: {
                return 2000;
            }
            case JSON: {
                return 4002;
            }
            case LONGVARBINARY: {
                return -4;
            }
            case LONGVARCHAR: {
                return -1;
            }
            case MAP: {
                return 4001;
            }
            case NULLTYPE: {
                return 0;
            }
            case OTHER: {
                return 1111;
            }
            case REAL: {
                return 7;
            }
            case SMALLINT: {
                return 5;
            }
            case SQLXML: {
                return 2009;
            }
            case STRUCT: {
                return 2002;
            }
            case TIME: {
                return 92;
            }
            case TIMESTAMP: {
                return 93;
            }
            case TINYINT: {
                return -6;
            }
            case VARBINARY: {
                return -3;
            }
            case VARCHAR: {
                return 12;
            }
        }
        return 1111;
    }

    public static SnappyType getThriftSQLType(int jdbcType) {
        switch (jdbcType) {
            case 2003: {
                return SnappyType.ARRAY;
            }
            case -5: {
                return SnappyType.BIGINT;
            }
            case -2: {
                return SnappyType.BINARY;
            }
            case -7: {
                return SnappyType.BOOLEAN;
            }
            case 2004: {
                return SnappyType.BLOB;
            }
            case 16: {
                return SnappyType.BOOLEAN;
            }
            case 1: {
                return SnappyType.CHAR;
            }
            case 2005: {
                return SnappyType.CLOB;
            }
            case 91: {
                return SnappyType.DATE;
            }
            case 3: {
                return SnappyType.DECIMAL;
            }
            case 8: {
                return SnappyType.DOUBLE;
            }
            case 6: {
                return SnappyType.FLOAT;
            }
            case 4: {
                return SnappyType.INTEGER;
            }
            case 2000: {
                return SnappyType.JAVA_OBJECT;
            }
            case 4002: {
                return SnappyType.JSON;
            }
            case -4: {
                return SnappyType.LONGVARBINARY;
            }
            case -1: {
                return SnappyType.LONGVARCHAR;
            }
            case 4001: {
                return SnappyType.MAP;
            }
            case 0: {
                return SnappyType.NULLTYPE;
            }
            case 2: {
                return SnappyType.DECIMAL;
            }
            case 1111: {
                return SnappyType.OTHER;
            }
            case 7: {
                return SnappyType.REAL;
            }
            case 5: {
                return SnappyType.SMALLINT;
            }
            case 2009: {
                return SnappyType.SQLXML;
            }
            case 2002: {
                return SnappyType.STRUCT;
            }
            case 92: {
                return SnappyType.TIME;
            }
            case 93: {
                return SnappyType.TIMESTAMP;
            }
            case -6: {
                return SnappyType.TINYINT;
            }
            case -3: {
                return SnappyType.VARBINARY;
            }
            case 12: {
                return SnappyType.VARCHAR;
            }
        }
        return SnappyType.OTHER;
    }

    public static int getJdbcResultSetType(byte thriftType) {
        switch (thriftType) {
            case 1: {
                return 1003;
            }
            case 2: {
                return 1004;
            }
            case 3: {
                return 1005;
            }
        }
        throw new IllegalArgumentException("Thrift ResultSet type=" + thriftType);
    }

    public static int getThriftResultSetType(int jdbcType) {
        switch (jdbcType) {
            case 1003: {
                return 1;
            }
            case 1004: {
                return 2;
            }
            case 1005: {
                return 3;
            }
        }
        return 4;
    }

    public static int getJdbcIsolation(int thriftIsolationLevel) {
        switch (thriftIsolationLevel) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Thrift isolation level=" + thriftIsolationLevel);
    }

    public static byte getThriftTransactionIsolation(int jdbcIsolationLevel) {
        switch (jdbcIsolationLevel) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        return 64;
    }

    static {
        SnappyType[] universe = SnappyType.values();
        typeConverters = new ColumnValueConverter[universe.length + 2];
        block23: for (SnappyType type : universe) {
            switch (type) {
                case CHAR: 
                case VARCHAR: 
                case LONGVARCHAR: {
                    Converters.typeConverters[type.ordinal()] = STRING_TYPE;
                    continue block23;
                }
                case INTEGER: {
                    Converters.typeConverters[type.ordinal()] = INT_TYPE;
                    continue block23;
                }
                case BOOLEAN: {
                    Converters.typeConverters[type.ordinal()] = BOOLEAN_TYPE;
                    continue block23;
                }
                case TINYINT: {
                    Converters.typeConverters[type.ordinal()] = BYTE_TYPE;
                    continue block23;
                }
                case SMALLINT: {
                    Converters.typeConverters[type.ordinal()] = SHORT_TYPE;
                    continue block23;
                }
                case BIGINT: {
                    Converters.typeConverters[type.ordinal()] = LONG_TYPE;
                    continue block23;
                }
                case REAL: {
                    Converters.typeConverters[type.ordinal()] = REAL_TYPE;
                    continue block23;
                }
                case DOUBLE: 
                case FLOAT: {
                    Converters.typeConverters[type.ordinal()] = DOUBLE_TYPE;
                    continue block23;
                }
                case DECIMAL: {
                    Converters.typeConverters[type.ordinal()] = DECIMAL_TYPE;
                    continue block23;
                }
                case DATE: {
                    Converters.typeConverters[type.ordinal()] = DATE_TYPE;
                    continue block23;
                }
                case TIME: {
                    Converters.typeConverters[type.ordinal()] = TIME_TYPE;
                    continue block23;
                }
                case TIMESTAMP: {
                    Converters.typeConverters[type.ordinal()] = TIMESTAMP_TYPE;
                    continue block23;
                }
                case BINARY: 
                case VARBINARY: 
                case LONGVARBINARY: {
                    Converters.typeConverters[type.ordinal()] = BINARY_TYPE;
                    continue block23;
                }
                case CLOB: {
                    Converters.typeConverters[type.ordinal()] = CLOB_TYPE;
                    continue block23;
                }
                case BLOB: {
                    Converters.typeConverters[type.ordinal()] = BLOB_TYPE;
                    continue block23;
                }
                case ARRAY: {
                    Converters.typeConverters[type.ordinal()] = ARRAY_TYPE;
                    continue block23;
                }
                case MAP: {
                    Converters.typeConverters[type.ordinal()] = MAP_TYPE;
                }
                case STRUCT: {
                    Converters.typeConverters[type.ordinal()] = STRUCT_TYPE;
                }
                case JSON: {
                    Converters.typeConverters[type.ordinal()] = JSON_TYPE;
                    continue block23;
                }
                case NULLTYPE: {
                    Converters.typeConverters[type.ordinal()] = NULL_TYPE;
                    continue block23;
                }
                case JAVA_OBJECT: 
                case OTHER: {
                    Converters.typeConverters[type.ordinal()] = OBJECT_TYPE;
                    continue block23;
                }
            }
        }
    }

    public static class StringConverter
    extends ColumnValueConverter {
        @Override
        public SnappyType getType() {
            return SnappyType.VARCHAR;
        }

        @Override
        public final boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
            String str = this.toString(row, columnIndex);
            if (str != null) {
                return !(str = str.trim()).equals("0") && !str.equalsIgnoreCase("false");
            }
            return false;
        }

        @Override
        public final byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
            long v = this.toLong(row, columnIndex);
            if (v >= -128L && v <= 127L) {
                return (byte)v;
            }
            throw Converters.newOutOfRangeException("byte", columnIndex);
        }

        @Override
        public final short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
            long v = this.toLong(row, columnIndex);
            if (v >= -32768L && v <= 32767L) {
                return (short)v;
            }
            throw Converters.newOutOfRangeException("short", columnIndex);
        }

        @Override
        public final int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
            long v = this.toLong(row, columnIndex);
            if (v >= Integer.MIN_VALUE && v <= Integer.MAX_VALUE) {
                return (int)v;
            }
            throw Converters.newOutOfRangeException("int", columnIndex);
        }

        @Override
        public final long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
            return Converters.getLong(this.toString(row, columnIndex), columnIndex);
        }

        @Override
        public final float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
            double v = this.toDouble(row, columnIndex);
            if (v >= (double)1.4E-45f && v <= 3.4028234663852886E38) {
                return (float)v;
            }
            throw Converters.newOutOfRangeException("float", columnIndex);
        }

        @Override
        public final double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
            return Converters.getDouble(this.toString(row, columnIndex), columnIndex);
        }

        @Override
        public final BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
            String str = this.toString(row, columnIndex);
            try {
                return new BigDecimal(str.trim());
            }
            catch (NumberFormatException nfe) {
                throw Converters.newFormatException("BigDecimal", columnIndex, nfe);
            }
        }

        private String toString(OptimizedElementArray row, int columnIndex) throws SQLException {
            return (String)row.getObject(columnIndex - 1);
        }

        @Override
        public String toString(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return this.toString(row, columnIndex);
        }

        @Override
        public final Date toDate(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            String str = this.toString(row, columnIndex);
            if (str != null) {
                Date date;
                try {
                    date = Date.valueOf(str);
                }
                catch (IllegalArgumentException iae) {
                    throw ThriftExceptionUtil.newSQLException("22007.S.181", iae, str);
                }
                if (cal == null) {
                    return date;
                }
                cal.setTime(date);
                return new Date(cal.getTimeInMillis());
            }
            throw ThriftExceptionUtil.newSQLException("22007.S.181", null, "<NULL>");
        }

        @Override
        public final java.sql.Timestamp toTimestamp(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            String str = this.toString(row, columnIndex);
            if (str != null) {
                java.sql.Timestamp ts;
                try {
                    ts = java.sql.Timestamp.valueOf(str);
                }
                catch (IllegalArgumentException iae) {
                    throw ThriftExceptionUtil.newSQLException("22007.S.181", iae, str);
                }
                if (cal == null) {
                    return ts;
                }
                cal.setTime(ts);
                return new java.sql.Timestamp(cal.getTimeInMillis());
            }
            throw ThriftExceptionUtil.newSQLException("22007.S.181", null, "<NULL>");
        }

        @Override
        public final Time toTime(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
            String str = this.toString(row, columnIndex);
            if (str != null) {
                Time time;
                try {
                    time = Time.valueOf(str);
                }
                catch (IllegalArgumentException iae) {
                    throw ThriftExceptionUtil.newSQLException("22007.S.181", iae, str);
                }
                if (cal == null) {
                    return time;
                }
                cal.setTime(time);
                return new Time(cal.getTimeInMillis());
            }
            throw ThriftExceptionUtil.newSQLException("22007.S.181", null, "<NULL>");
        }

        @Override
        public Object toObject(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
            return row.getObject(columnIndex - 1);
        }

        @Override
        public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
            this.setString(row, columnIndex, x ? "true" : "false");
        }

        @Override
        public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
            this.setString(row, columnIndex, Byte.toString(x));
        }

        @Override
        public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
            this.setString(row, columnIndex, Short.toString(x));
        }

        @Override
        public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
            this.setString(row, columnIndex, Integer.toString(x));
        }

        @Override
        public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
            this.setString(row, columnIndex, Long.toString(x));
        }

        @Override
        public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
            this.setString(row, columnIndex, Float.toString(x));
        }

        @Override
        public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
            this.setString(row, columnIndex, Double.toString(x));
        }

        @Override
        public void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
            this.setString(row, columnIndex, x.toPlainString());
        }

        @Override
        public final void setString(OptimizedElementArray row, int columnIndex, String x) throws SQLException {
            row.setObject(columnIndex - 1, x, SnappyType.VARCHAR);
        }

        @Override
        public void setDate(OptimizedElementArray row, int columnIndex, Date x) throws SQLException {
            this.setString(row, columnIndex, x.toString());
        }

        @Override
        public void setTimestamp(OptimizedElementArray row, int columnIndex, java.sql.Timestamp x) throws SQLException {
            this.setString(row, columnIndex, x.toString());
        }

        @Override
        public void setTime(OptimizedElementArray row, int columnIndex, Time x) throws SQLException {
            this.setString(row, columnIndex, x.toString());
        }

        @Override
        public void setObject(OptimizedElementArray row, int columnIndex, Object o) throws SQLException {
            Class<?> c = o.getClass();
            if (c == String.class) {
                this.setString(row, columnIndex, (String)o);
            } else if (c == Double.class) {
                this.setDouble(row, columnIndex, (Double)o);
            } else if (c == Float.class) {
                this.setFloat(row, columnIndex, ((Float)o).floatValue());
            } else if (c == Integer.class) {
                this.setInteger(row, columnIndex, (Integer)o);
            } else if (c == Byte.class) {
                this.setByte(row, columnIndex, (Byte)o);
            } else if (c == Short.class) {
                this.setShort(row, columnIndex, (Short)o);
            } else if (c == Long.class) {
                this.setLong(row, columnIndex, (Long)o);
            } else if (c == Boolean.class) {
                this.setBoolean(row, columnIndex, (Boolean)o);
            } else if (o instanceof BigDecimal) {
                this.setBigDecimal(row, columnIndex, (BigDecimal)o);
            } else {
                throw Converters.newTypeConversionException(c.getName(), this.getType().toString());
            }
        }
    }
}

