/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import io.snappydata.thrift.SnappyType;
import io.snappydata.thrift.common.Converters;
import io.snappydata.thrift.common.LobService;
import io.snappydata.thrift.common.OptimizedElementArray;
import io.snappydata.thrift.common.ThriftExceptionUtil;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class ColumnValueConverter {
    public abstract SnappyType getType();

    public boolean toBoolean(OptimizedElementArray row, int columnIndex) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "boolean");
    }

    public byte toByte(OptimizedElementArray row, int columnIndex) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "byte");
    }

    public short toShort(OptimizedElementArray row, int columnIndex) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "short");
    }

    public int toInteger(OptimizedElementArray row, int columnIndex) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "int");
    }

    public long toLong(OptimizedElementArray row, int columnIndex) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "long");
    }

    public float toFloat(OptimizedElementArray row, int columnIndex) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "float");
    }

    public double toDouble(OptimizedElementArray row, int columnIndex) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "double");
    }

    public BigDecimal toBigDecimal(OptimizedElementArray row, int columnIndex) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "BigDecimal");
    }

    public abstract String toString(OptimizedElementArray var1, int var2, LobService var3) throws SQLException;

    public Date toDate(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Date");
    }

    public Time toTime(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Time");
    }

    public Timestamp toTimestamp(OptimizedElementArray row, int columnIndex, Calendar cal) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Timestamp");
    }

    public byte[] toBytes(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "byte[]");
    }

    public Blob toBlob(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Blob");
    }

    public InputStream toBinaryStream(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "InputStream");
    }

    public Clob toClob(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Clob");
    }

    public Reader toCharacterStream(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "CharacterStream");
    }

    public InputStream toAsciiStream(OptimizedElementArray row, int columnIndex, LobService lobService) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "AsciiStream");
    }

    public abstract Object toObject(OptimizedElementArray var1, int var2, LobService var3) throws SQLException;

    public void setBoolean(OptimizedElementArray row, int columnIndex, boolean x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "boolean");
    }

    public void setByte(OptimizedElementArray row, int columnIndex, byte x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "byte");
    }

    public void setShort(OptimizedElementArray row, int columnIndex, short x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "short");
    }

    public void setInteger(OptimizedElementArray row, int columnIndex, int x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "int");
    }

    public void setLong(OptimizedElementArray row, int columnIndex, long x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "long");
    }

    public void setFloat(OptimizedElementArray row, int columnIndex, float x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "float");
    }

    public void setDouble(OptimizedElementArray row, int columnIndex, double x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "double");
    }

    public void setBigDecimal(OptimizedElementArray row, int columnIndex, BigDecimal x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "BigDecimal");
    }

    public abstract void setString(OptimizedElementArray var1, int var2, String var3) throws SQLException;

    public void setDate(OptimizedElementArray row, int columnIndex, Date x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Date");
    }

    public void setTime(OptimizedElementArray row, int columnIndex, Time x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Time");
    }

    public void setTimestamp(OptimizedElementArray row, int columnIndex, Timestamp x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "Timestamp");
    }

    public void setBytes(OptimizedElementArray row, int columnIndex, byte[] x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "byte[]");
    }

    public void setBlob(OptimizedElementArray row, int columnIndex, Blob x) throws SQLException {
        long len = x.length();
        if (len > Integer.MAX_VALUE) {
            throw ThriftExceptionUtil.newSQLException("XJ093.S", null, len, Integer.MAX_VALUE);
        }
        this.setBytes(row, columnIndex, x.getBytes(1L, (int)len));
    }

    public void setBinaryStream(OptimizedElementArray row, int columnIndex, InputStream x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "InputStream");
    }

    public void setClob(OptimizedElementArray row, int columnIndex, Clob x) throws SQLException {
        long len = x.length();
        if (len > Integer.MAX_VALUE) {
            throw ThriftExceptionUtil.newSQLException("XJ093.S", null, len, Integer.MAX_VALUE);
        }
        this.setString(row, columnIndex, x.getSubString(1L, (int)len));
    }

    public void setCharacterStream(OptimizedElementArray row, int columnIndex, Reader x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "CharacterStream");
    }

    public void setAsciiStream(OptimizedElementArray row, int columnIndex, InputStream x) throws SQLException {
        throw Converters.newTypeConversionException(this.getType().toString(), "AsciiStream");
    }

    public abstract void setObject(OptimizedElementArray var1, int var2, Object var3) throws SQLException;

    public boolean isNull() {
        return false;
    }
}

