/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamUtil {
    private static final int SKIP_FRAGMENT_SIZE = Integer.MAX_VALUE;

    public static int readUnsignedByte(InputStream in) throws IOException {
        int b = in.read();
        if (b < 0) {
            throw new EOFException();
        }
        return b;
    }

    public static void readFully(InputStream in, byte[] b, int offset, int len) throws IOException {
        int bytesRead;
        do {
            if ((bytesRead = in.read(b, offset, len)) < 0) {
                throw new EOFException();
            }
            offset += bytesRead;
        } while ((len -= bytesRead) != 0);
    }

    public static int readLoop(InputStream in, byte[] b, int offset, int len) throws IOException {
        int bytesRead;
        int firstOffset = offset;
        while ((bytesRead = in.read(b, offset, len)) > 0) {
            offset += bytesRead;
            if ((len -= bytesRead) != 0) continue;
        }
        return offset - firstOffset;
    }

    public static long skipUntilEOF(InputStream is) throws IOException {
        long r;
        if (is == null) {
            throw new NullPointerException();
        }
        long bytes = 0L;
        do {
            r = InputStreamUtil.skipPersistent(is, Integer.MAX_VALUE);
            bytes += r;
        } while (r >= Integer.MAX_VALUE);
        return bytes;
    }

    public static void skipFully(InputStream is, long skippedBytes) throws IOException {
        if (is == null) {
            throw new NullPointerException();
        }
        if (skippedBytes <= 0L) {
            return;
        }
        long bytes = InputStreamUtil.skipPersistent(is, skippedBytes);
        if (bytes < skippedBytes) {
            throw new EOFException();
        }
    }

    public static final long skipPersistent(InputStream in, long bytesToSkip) throws IOException {
        long skipped;
        long skippedNow;
        for (skipped = 0L; skipped < bytesToSkip; skipped += skippedNow) {
            skippedNow = in.skip(bytesToSkip - skipped);
            if (skippedNow != 0L) continue;
            if (in.read() == -1) break;
            skippedNow = 1L;
        }
        return skipped;
    }
}

