/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import io.snappydata.thrift.HostAddress;
import io.snappydata.thrift.SnappyException;
import io.snappydata.thrift.TransactionAttribute;
import io.snappydata.thrift.common.SocketParameters;
import java.util.EnumMap;

public abstract class ThriftUtils {
    private static final SharedUtils.CSVVisitor<SocketParameters, Void> parseSSLParams = new SharedUtils.CSVVisitor<SocketParameters, Void>(){

        @Override
        public void visit(String str, SocketParameters sslParams, Void ignore) {
            int eqIndex = str.indexOf(61);
            if (eqIndex <= 0) {
                throw new IllegalArgumentException("Missing equality: expected comma-separated <property>=<value> pairs");
            }
            String key = str.substring(0, eqIndex).trim();
            String value = str.substring(eqIndex + 1).trim();
            SocketParameters.findSSLParameterByPropertyName(key, true).setParameter(sslParams, value);
        }
    };

    private ThriftUtils() {
    }

    public static boolean isThriftSelectorServer() {
        return SystemProperties.getServerInstance().getBoolean("thrift-selector", false);
    }

    public static HostAddress getHostAddress(String hostNameAndAddress, int port) {
        int slashIndex = hostNameAndAddress.indexOf(47);
        if (slashIndex > 0) {
            String hostName = hostNameAndAddress.substring(0, slashIndex);
            String ipAddress = hostNameAndAddress.substring(slashIndex + 1);
            if (ipAddress.length() > 0 && !hostName.equals(ipAddress)) {
                return new HostAddress(hostName, port).setIpAddress(ipAddress);
            }
            return new HostAddress(hostName, port);
        }
        if (slashIndex == 0) {
            return new HostAddress(hostNameAndAddress.substring(1), port);
        }
        return new HostAddress(hostNameAndAddress, port);
    }

    public static void getSSLParameters(SocketParameters socketParams, String sslProperties) throws SnappyException {
        if (sslProperties != null && sslProperties.length() > 0) {
            socketParams.setHasSSLParams(true);
            SharedUtils.splitCSV(sslProperties, parseSSLParams, socketParams, null);
        }
    }

    public static EnumMap<TransactionAttribute, Boolean> newTransactionFlags() {
        return new EnumMap<TransactionAttribute, Boolean>(TransactionAttribute.class);
    }
}

