/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.InputStreamChannel;
import com.gemstone.gemfire.internal.shared.OutputStreamChannel;
import com.gemstone.gemfire.internal.shared.SystemProperties;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import io.snappydata.thrift.HostAddress;
import io.snappydata.thrift.common.SocketParameters;
import io.snappydata.thrift.common.SocketTimeout;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.thrift.transport.TNonblockingTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnappyTSocket
extends TNonblockingTransport
implements SocketTimeout {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SnappyTSocket.class.getName());
    private final SocketChannel socketChannel;
    private InetSocketAddress socketAddress;
    private volatile int timeout;
    private int inputBufferSize = SystemProperties.getClientInstance().getSocketInputBufferSize();
    private int outputBufferSize = SystemProperties.getClientInstance().getSocketOutputBufferSize();
    private InputStreamChannel inputStream;
    private OutputStreamChannel outputStream;
    private final boolean framedWrites;

    public SnappyTSocket(SocketChannel socketChannel, boolean blocking, int timeout, SocketParameters params, SystemProperties props) throws TTransportException {
        this.socketChannel = socketChannel;
        if (!socketChannel.isConnected()) {
            throw new TTransportException(1, "Socket must already be connected");
        }
        try {
            socketChannel.configureBlocking(blocking);
            this.setProperties(socketChannel.socket(), timeout, params, props);
            this.inputStream = UnsafeHolder.newChannelBufferFramedInputStream((ReadableByteChannel)socketChannel, (int)this.inputBufferSize);
            this.outputStream = UnsafeHolder.newChannelBufferOutputStream((WritableByteChannel)socketChannel, (int)this.outputBufferSize);
            this.framedWrites = false;
        }
        catch (IOException ioe) {
            this.close();
            throw new TTransportException(1, (Throwable)ioe);
        }
    }

    public SnappyTSocket(HostAddress host, boolean blocking, boolean framedWrites, SocketParameters params, SystemProperties props) throws TTransportException {
        this(host.resolveHost(), host.getPort(), blocking, framedWrites, params, props, params.getReadTimeout(0));
    }

    public SnappyTSocket(InetAddress hostAddress, int port, boolean blocking, boolean framedWrites, SocketParameters params, SystemProperties props, int timeout) throws TTransportException {
        this.socketChannel = SnappyTSocket.initSocket(blocking);
        this.socketAddress = new InetSocketAddress(hostAddress, port);
        this.framedWrites = framedWrites;
        this.setProperties(this.socketChannel.socket(), timeout, params, props);
        this.open();
    }

    private static SocketChannel initSocket(boolean blocking) throws TTransportException {
        try {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(blocking);
            return socketChannel;
        }
        catch (SocketException se) {
            LOGGER.error("Could not configure socket.", (Throwable)se);
            throw new TTransportException(1, "Could not configure socket.", (Throwable)se);
        }
        catch (IOException ioe) {
            throw new TTransportException(1, "Could not open socket channel.", (Throwable)ioe);
        }
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.getSocket().getSoTimeout();
    }

    @Override
    public int getRawTimeout() {
        return this.timeout;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.getSocket().setSoTimeout(timeout);
        this.timeout = timeout;
    }

    @Override
    public void setTimeout(int timeout, SocketParameters params, SystemProperties props) throws SocketException {
        this.timeout = SnappyTSocket.setTimeout(this.getSocket(), timeout, params, props);
    }

    protected static int setTimeout(Socket socket, int timeout, SocketParameters params, SystemProperties props) throws SocketException {
        socket.setSoTimeout(timeout);
        ClientSharedUtils.setKeepAliveOptions((Socket)socket, null, (int)params.getKeepAliveIdle(props.getKeepAliveIdle()), (int)params.getKeepAliveInterval(props.getKeepAliveInterval()), (int)params.getKeepAliveCount(props.getKeepAliveCount()));
        return timeout;
    }

    protected void setProperties(Socket socket, int timeout, SocketParameters params, SystemProperties props) throws TTransportException {
        this.inputBufferSize = params.getInputBufferSize(props.getSocketInputBufferSize());
        this.outputBufferSize = params.getOutputBufferSize(props.getSocketOutputBufferSize());
        try {
            socket.setSoLinger(false, 0);
            socket.setTcpNoDelay(true);
            this.timeout = SnappyTSocket.setTimeout(socket, timeout, params, props);
        }
        catch (SocketException se) {
            LOGGER.warn("Could not set socket timeout.", (Throwable)se);
            throw new TTransportException(1, "Could not set socket timeout.", (Throwable)se);
        }
    }

    public final Socket getSocket() {
        return this.socketChannel.socket();
    }

    public final SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    public final InputStreamChannel getInputStream() {
        return this.inputStream;
    }

    public final OutputStreamChannel getOutputStream() {
        return this.outputStream;
    }

    public boolean isOpen() {
        SocketChannel channel = this.socketChannel;
        return channel != null && channel.isConnected();
    }

    public void open() throws TTransportException {
        if (this.isOpen()) {
            throw new TTransportException(2, "Socket already connected.");
        }
        if (this.socketAddress == null) {
            throw new TTransportException(1, "Cannot open null host.");
        }
        if (this.socketAddress.getPort() <= 0) {
            throw new TTransportException(1, "Cannot open without port.");
        }
        Socket socket = this.getSocket();
        try {
            socket.connect(this.socketAddress, this.timeout);
            this.inputStream = UnsafeHolder.newChannelBufferFramedInputStream((ReadableByteChannel)this.socketChannel, (int)this.inputBufferSize);
            this.outputStream = this.framedWrites ? UnsafeHolder.newChannelBufferFramedOutputStream((WritableByteChannel)this.socketChannel, (int)this.outputBufferSize) : UnsafeHolder.newChannelBufferOutputStream((WritableByteChannel)this.socketChannel, (int)this.outputBufferSize);
        }
        catch (IOException ioe) {
            this.close();
            throw new TTransportException(1, (Throwable)ioe);
        }
    }

    public boolean startConnect() throws IOException {
        return this.socketChannel.connect(this.socketAddress);
    }

    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    public SelectionKey registerSelector(Selector selector, int interests) throws IOException {
        return this.socketChannel.register(selector, interests);
    }

    public final int read(ByteBuffer buffer) throws IOException {
        return this.inputStream.read(buffer);
    }

    public final int read(byte[] buf, int off, int len) throws TTransportException {
        int bytesRead;
        try {
            bytesRead = this.inputStream.read(buf, off, len);
        }
        catch (ClosedChannelException cce) {
            throw new TTransportException(1, "Cannot read from closed channel.");
        }
        catch (IOException ioe) {
            throw new TTransportException(0, (Throwable)ioe);
        }
        if (bytesRead >= 0) {
            return bytesRead;
        }
        throw new TTransportException(4, "Channel closed.");
    }

    public final int write(ByteBuffer buffer) throws IOException {
        OutputStreamChannel outStream = this.outputStream;
        int numWritten = outStream.write(buffer);
        if (buffer.position() >= buffer.limit()) {
            outStream.flush();
        }
        return numWritten;
    }

    public final void write(byte[] buf, int off, int len) throws TTransportException {
        try {
            this.outputStream.write(buf, off, len);
        }
        catch (ClosedChannelException cce) {
            throw new TTransportException(1, "Cannot write to closed channel.");
        }
        catch (IOException ioe) {
            throw new TTransportException(0, (Throwable)ioe);
        }
    }

    public void flush() throws TTransportException {
        try {
            this.outputStream.flush();
        }
        catch (ClosedChannelException cce) {
            throw new TTransportException(1, "Cannot write to closed channel.");
        }
        catch (IOException ioe) {
            throw new TTransportException(0, (Throwable)ioe);
        }
    }

    @Override
    public void close() {
        if (!this.socketChannel.isOpen()) {
            return;
        }
        InputStreamChannel inStream = this.inputStream;
        OutputStreamChannel outStream = this.outputStream;
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (outStream != null) {
            try {
                outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

