/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift;

import com.gemstone.gemfire.internal.shared.HostLocationBase;
import io.snappydata.thrift.ServerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public final class HostAddress
extends HostLocationBase<HostAddress>
implements TBase<HostAddress, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("HostAddress");
    private static final TField HOST_NAME_FIELD_DESC = new TField("hostName", 11, 1);
    private static final TField PORT_FIELD_DESC = new TField("port", 8, 2);
    private static final TField IP_ADDRESS_FIELD_DESC = new TField("ipAddress", 11, 3);
    private static final TField SERVER_TYPE_FIELD_DESC = new TField("serverType", 8, 4);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new HostAddressStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new HostAddressTupleSchemeFactory();
    public static final HostAddress NULL_ADDRESS = new HostAddress("", -1);
    protected String ipAddress;
    protected ServerType serverType;
    private static final int __PORT_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private _Fields[] optionals = new _Fields[]{_Fields.IP_ADDRESS, _Fields.SERVER_TYPE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public HostAddress() {
    }

    public HostAddress(String hostName, int port) {
        super(hostName, port);
        this.setPortIsSet(true);
    }

    public HostAddress(HostAddress other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetHostName()) {
            this.hostName = other.hostName;
        }
        this.port = other.port;
        if (other.isSetIpAddress()) {
            this.ipAddress = other.ipAddress;
        }
        if (other.isSetServerType()) {
            this.serverType = other.serverType;
        }
    }

    public InetAddress resolveHost() throws TTransportException {
        try {
            return InetAddress.getByName(this.hostName);
        }
        catch (UnknownHostException uhe) {
            if (this.ipAddress != null) {
                try {
                    return InetAddress.getByName(this.ipAddress);
                }
                catch (UnknownHostException e) {
                    throw new TTransportException((Throwable)e);
                }
            }
            throw new TTransportException((Throwable)uhe);
        }
    }

    public HostAddress deepCopy() {
        return new HostAddress(this);
    }

    public void clear() {
        this.hostName = null;
        this.setPortIsSet(false);
        this.port = 0;
        this.ipAddress = null;
        this.serverType = null;
    }

    public HostAddress setHostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    public void unsetHostName() {
        this.hostName = null;
    }

    public boolean isSetHostName() {
        return this.hostName != null;
    }

    public void setHostNameIsSet(boolean value) {
        if (!value) {
            this.hostName = null;
        }
    }

    public HostAddress setPort(int port) {
        this.port = port;
        this.setPortIsSet(true);
        return this;
    }

    public void unsetPort() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetPort() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setPortIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public HostAddress setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public void unsetIpAddress() {
        this.ipAddress = null;
    }

    public boolean isSetIpAddress() {
        return this.ipAddress != null;
    }

    public void setIpAddressIsSet(boolean value) {
        if (!value) {
            this.ipAddress = null;
        }
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public HostAddress setServerType(ServerType serverType) {
        this.serverType = serverType;
        return this;
    }

    public void unsetServerType() {
        this.serverType = null;
    }

    public boolean isSetServerType() {
        return this.serverType != null;
    }

    public void setServerTypeIsSet(boolean value) {
        if (!value) {
            this.serverType = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case HOST_NAME: {
                if (value == null) {
                    this.unsetHostName();
                    break;
                }
                this.setHostName((String)value);
                break;
            }
            case PORT: {
                if (value == null) {
                    this.unsetPort();
                    break;
                }
                this.setPort((Integer)value);
                break;
            }
            case IP_ADDRESS: {
                if (value == null) {
                    this.unsetIpAddress();
                    break;
                }
                this.setIpAddress((String)value);
                break;
            }
            case SERVER_TYPE: {
                if (value == null) {
                    this.unsetServerType();
                    break;
                }
                this.setServerType((ServerType)((Object)value));
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case HOST_NAME: {
                return this.getHostName();
            }
            case PORT: {
                return this.getPort();
            }
            case IP_ADDRESS: {
                return this.getIpAddress();
            }
            case SERVER_TYPE: {
                return this.getServerType();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case HOST_NAME: {
                return this.isSetHostName();
            }
            case PORT: {
                return this.isSetPort();
            }
            case IP_ADDRESS: {
                return this.isSetIpAddress();
            }
            case SERVER_TYPE: {
                return this.isSetServerType();
            }
        }
        throw new IllegalStateException();
    }

    public final boolean equals(HostLocationBase<?> other) {
        if (this == other) {
            return true;
        }
        if (this.port != other.getPort()) {
            return false;
        }
        if (other instanceof HostAddress) {
            HostAddress otherAddr = (HostAddress)other;
            if (super.equalsHostName((HostLocationBase)otherAddr)) {
                return this.ipAddress == null || otherAddr.ipAddress == null || this.ipAddress.equals(otherAddr.ipAddress);
            }
            if (this.ipAddress != null) {
                return this.ipAddress.equals(otherAddr.hostName);
            }
            if (otherAddr.ipAddress != null) {
                return otherAddr.ipAddress.equals(this.hostName);
            }
            return false;
        }
        return super.equalsHostName(other);
    }

    public int compareTo(HostAddress other) {
        if (!this.equals(other)) {
            return super.compareTo((HostLocationBase)other);
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        HostAddress.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        HostAddress.scheme(oprot).write(oprot, (TBase)this);
    }

    public String getHostString() {
        return super.toString();
    }

    public String toString() {
        ServerType serverType = this.serverType;
        if (serverType != null && serverType.isThriftWithDefaults()) {
            serverType = null;
        }
        if (this.ipAddress == null) {
            if (serverType == null) {
                return super.toString();
            }
            return this.hostName + '[' + this.port + "]{" + serverType.toString() + '}';
        }
        if (serverType == null) {
            return this.hostName + '/' + this.ipAddress + '[' + this.port + ']';
        }
        return this.hostName + '/' + this.ipAddress + '[' + this.port + "]{" + serverType.toString() + '}';
    }

    public void validate() throws TException {
        if (this.hostName == null) {
            throw new TProtocolException("Required field 'hostName' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.HOST_NAME, new FieldMetaData("hostName", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PORT, new FieldMetaData("port", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.IP_ADDRESS, new FieldMetaData("ipAddress", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SERVER_TYPE, new FieldMetaData("serverType", 2, (FieldValueMetaData)new EnumMetaData(16, ServerType.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(HostAddress.class, metaDataMap);
    }

    private static class HostAddressTupleScheme
    extends TupleScheme<HostAddress> {
        private HostAddressTupleScheme() {
        }

        public void write(TProtocol prot, HostAddress struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeString(struct.hostName);
            oprot.writeI32(struct.port);
            BitSet optionals = new BitSet();
            if (struct.isSetIpAddress()) {
                optionals.set(0);
            }
            if (struct.isSetServerType()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetIpAddress()) {
                oprot.writeString(struct.ipAddress);
            }
            if (struct.isSetServerType()) {
                oprot.writeI32(struct.serverType.getValue());
            }
        }

        public void read(TProtocol prot, HostAddress struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.hostName = iprot.readString();
            struct.setHostNameIsSet(true);
            struct.port = iprot.readI32();
            struct.setPortIsSet(true);
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.ipAddress = iprot.readString();
                struct.setIpAddressIsSet(true);
            }
            if (incoming.get(1)) {
                struct.serverType = ServerType.findByValue(iprot.readI32());
                struct.setServerTypeIsSet(true);
            }
        }
    }

    private static class HostAddressTupleSchemeFactory
    implements SchemeFactory {
        private HostAddressTupleSchemeFactory() {
        }

        public HostAddressTupleScheme getScheme() {
            return new HostAddressTupleScheme();
        }
    }

    private static class HostAddressStandardScheme
    extends StandardScheme<HostAddress> {
        private HostAddressStandardScheme() {
        }

        public void read(TProtocol iprot, HostAddress struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.hostName = iprot.readString();
                            struct.setHostNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.port = iprot.readI32();
                            struct.setPortIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.ipAddress = iprot.readString();
                            struct.setIpAddressIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.serverType = ServerType.findByValue(iprot.readI32());
                            struct.setServerTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetPort()) {
                throw new TProtocolException("Required field 'port' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, HostAddress struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.hostName != null) {
                oprot.writeFieldBegin(HOST_NAME_FIELD_DESC);
                oprot.writeString(struct.hostName);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(PORT_FIELD_DESC);
            oprot.writeI32(struct.port);
            oprot.writeFieldEnd();
            if (struct.ipAddress != null && struct.isSetIpAddress()) {
                oprot.writeFieldBegin(IP_ADDRESS_FIELD_DESC);
                oprot.writeString(struct.ipAddress);
                oprot.writeFieldEnd();
            }
            if (struct.serverType != null && struct.isSetServerType()) {
                oprot.writeFieldBegin(SERVER_TYPE_FIELD_DESC);
                oprot.writeI32(struct.serverType.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class HostAddressStandardSchemeFactory
    implements SchemeFactory {
        private HostAddressStandardSchemeFactory() {
        }

        public HostAddressStandardScheme getScheme() {
            return new HostAddressStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        HOST_NAME(1, "hostName"),
        PORT(2, "port"),
        IP_ADDRESS(3, "ipAddress"),
        SERVER_TYPE(4, "serverType");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return HOST_NAME;
                }
                case 2: {
                    return PORT;
                }
                case 3: {
                    return IP_ADDRESS;
                }
                case 4: {
                    return SERVER_TYPE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

