/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.Converter;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class DecimalColumnRoutingObjectInfo
extends ColumnRoutingObjectInfo {
    private BigDecimal actualValue;

    public DecimalColumnRoutingObjectInfo(int isParameter, Object val, Object resolver) {
        super(isParameter, val, resolver);
    }

    public DecimalColumnRoutingObjectInfo() {
    }

    @Override
    public int computeHashCode(int hash, int resolverType, boolean requiresSerializedHash) {
        BigDecimal val = null;
        if (this.isValueAConstant()) {
            this.actualValue = val = (BigDecimal)this.value;
        } else {
            val = this.actualValue;
        }
        if (requiresSerializedHash && resolverType == 4 || resolverType == 2) {
            if (this.actualValue != null) {
                int scale = this.actualValue.scale();
                if (scale < 0) {
                    this.actualValue = this.actualValue.setScale(0);
                    scale = 0;
                }
                BigInteger bi = this.actualValue.unscaledValue();
                hash = ResolverUtils.addByteToBucketHash((byte)scale, hash, 200);
                hash = ResolverUtils.addByteToBucketHash((byte)bi.signum(), hash, 200);
                int[] magnitude = ClientSharedUtils.getBigIntInternalMagnitude((BigInteger)bi);
                if (magnitude != null) {
                    return ResolverUtils.computeHashCode(magnitude, hash, 200);
                }
                return ResolverUtils.addBytesToBucketHash(bi.abs().toByteArray(), hash, 200);
            }
            return ResolverUtils.addByteToBucketHash((byte)0, hash, 200);
        }
        return this.dvdEquivalenthashCode();
    }

    @Override
    public void setActualValue(Object[] parameters, Converter crossConverter) throws SQLException {
        if (!this.isValueAConstant()) {
            this.actualValue = (BigDecimal)crossConverter.getJavaObjectOfType(3, parameters[(Integer)this.value]);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 200;
    }

    @Override
    public Object getActualValue() {
        if (this.actualValue != null) {
            return this.actualValue;
        }
        if (this.isValueAConstant()) {
            this.actualValue = (BigDecimal)this.value;
            return this.actualValue;
        }
        return null;
    }

    @Override
    public int dvdEquivalenthashCode() {
        long longVal;
        double doubleVal;
        double d = doubleVal = this.actualValue != null ? this.actualValue.doubleValue() : 0.0;
        if (Double.isInfinite(doubleVal)) {
            longVal = this.actualValue.longValue();
        } else {
            longVal = (long)doubleVal;
            if ((double)longVal != doubleVal) {
                longVal = Double.doubleToLongBits(doubleVal);
            }
        }
        return (int)(longVal ^ longVal >> 32);
    }

    public static void dummy() {
    }
}

