/*
 * Copyright (c) 2010-2015 Pivotal Software, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */
/*
 * Changes for SnappyData data platform.
 *
 * Portions Copyright (c) 2016 SnappyData, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License. You
 * may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * permissions and limitations under the License. See accompanying
 * LICENSE file.
 */

/**
 * Modified to use {@link OptimizedElementArray} from the autogenerated code by
 * Thrift Compiler (1.0.0-dev).
 */
package io.snappydata.thrift.common;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;

import io.snappydata.thrift.ColumnDescriptor;
import io.snappydata.thrift.ColumnValue;
import io.snappydata.thrift.SnappyException;
import io.snappydata.thrift.SnappyExceptionData;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;

/**
 * Compact storage for a row in SQL. This extends {@link OptimizedElementArray}
 * to add Thrift specific serialization code.
 */
@SuppressWarnings({"rawtypes", "serial", "unchecked"})
public class ThriftRow extends OptimizedElementArray implements
    org.apache.thrift.TBase<ThriftRow, ThriftRow._Fields>,
    java.io.Serializable, Comparable<ThriftRow> {

  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC =
      new org.apache.thrift.protocol.TStruct("Row");

  private static final org.apache.thrift.protocol.TField VALUES_FIELD_DESC =
      new org.apache.thrift.protocol.TField("values",
          org.apache.thrift.protocol.TType.LIST, (short)1);

  private static final SchemeFactory STANDARD_SCHEME_FACTORY =
    new RowStandardSchemeFactory();
  private static final SchemeFactory TUPLE_SCHEME_FACTORY =
    new RowTupleSchemeFactory();

  private BitSet changedColumns;
  // public List<ColumnValue> values; // required

  /**
   * The set of fields this struct contains, along with convenience methods for
   * finding and manipulating them.
   */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    ;

    private final short _thriftId;

    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  public ThriftRow() {
    super(true);
  }

  public ThriftRow(List<ColumnDescriptor> metadata) {
    super(metadata, true);
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public ThriftRow(ThriftRow other) {
    super(other);
    final BitSet changedCols = other.changedColumns;
    this.changedColumns = changedCols == null ? null : (BitSet)changedCols
        .clone();
  }

  /**
   * Performs a deep copy on <i>other</i> if copyValues is true else don't copy
   * values.
   */
  public ThriftRow(ThriftRow other, boolean copyValues) {
    super(other, copyValues);
    if (copyValues) {
      final BitSet changedCols = other.changedColumns;
      this.changedColumns = changedCols == null ? null : (BitSet)changedCols
          .clone();
    }
    else {
      this.changedColumns = other.changedColumns;
    }
  }

  @Override
  public ThriftRow deepCopy() {
    return new ThriftRow(this);
  }

  @Override
  public void clear() {
    super.clear();
    this.changedColumns = null;
  }

  @Override
  public void setFieldValue(_Fields field, Object value) {
  }

  @Override
  public Object getFieldValue(_Fields field) {
    throw new IllegalStateException();
  }

  /**
   * Returns true if field corresponding to fieldID is set (has been assigned a
   * value) and false otherwise
   */
  @Override
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    throw new IllegalStateException();
  }

  public final void setChangedColumns(BitSet changedColumns) {
    this.changedColumns = changedColumns;
  }

  protected final int compare(Object o1, Object o2) {
    if (o1 != null) {
      if (o2 != null) {
        return org.apache.thrift.TBaseHelper.compareTo(o1, o2);
      }
      else {
        return 1;
      }
    }
    else if (o2 != null) {
      return -1;
    }
    else {
      return 0;
    }
  }

  public int compareTo(ThriftRow other) {
    int lastComparison = compare(this.primitives, other.primitives);
    if (lastComparison != 0) {
      return lastComparison;
    }
    else {
      return compare(this.nonPrimitives, other.nonPrimitives);
    }
  }

  @Override
  public _Fields fieldForId(int fieldId) {
    // nothing here
    return null;
  }

  @SuppressWarnings("unchecked")
  @Override
  public void read(org.apache.thrift.protocol.TProtocol iprot)
      throws org.apache.thrift.TException {
    scheme(iprot).read(iprot, this);
  }

  @SuppressWarnings("unchecked")
  @Override
  public void write(org.apache.thrift.protocol.TProtocol oprot)
      throws org.apache.thrift.TException {
    scheme(oprot).write(oprot, this);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("Row(");

    sb.append("values:");
    if (this.size == 0) {
      sb.append("null");
    }
    else {
      ColumnValue cv = new ColumnValue();
      for (int index = 0; index < this.size; index++) {
        cv.clear();
        try {
          setInto(index, cv);
        } catch (IOException ioe) {
          sb.append(ioe.toString());
          continue;
        }
        if (index > 0) {
          sb.append(',');
        }
        sb.append(cv.toString());
      }
    }
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    if (positionMap == null) {
      throw new org.apache.thrift.protocol.TProtocolException("Required "
          + "field 'positionMap' was not present! Struct: " + toString());
    }
    // check for sub-struct validity
  }

  private void writeObject(java.io.ObjectOutputStream out)
      throws java.io.IOException {
    try {
      write(new org.apache.thrift.protocol.TCompactProtocol(
          new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in)
      throws java.io.IOException, ClassNotFoundException {
    try {
      read(new org.apache.thrift.protocol.TCompactProtocol(
          new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class RowStandardSchemeFactory implements SchemeFactory {
    public RowStandardScheme getScheme() {
      return new RowStandardScheme();
    }
  }

  private static class RowStandardScheme extends StandardScheme<ThriftRow> {

    @Override
    public void read(org.apache.thrift.protocol.TProtocol iprot, ThriftRow struct)
        throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      ColumnValue _elem266 = new ColumnValue();
      iprot.readStructBegin();
      while (true) {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) {
          break;
        }
        switch (schemeField.id) {
          case 1: // VALUES
            if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
              {
                org.apache.thrift.protocol.TList _list264 = iprot
                    .readListBegin();
                for (int _i265 = 0; _i265 < _list264.size; ++_i265) {
                  _elem266.clear();
                  _elem266.read(iprot);
                  try {
                    struct.addColumnValue(_elem266);
                  } catch (java.sql.SQLException sqle) {
                    throw new SnappyException(new SnappyExceptionData(
                        sqle.getMessage(), sqle.getSQLState(),
                        sqle.getErrorCode()), null);
                  }
                }
                iprot.readListEnd();
              }
            }
            else {
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot,
                  schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot,
                schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in
      // the validate method
      struct.validate();
    }

    @Override
    public void write(org.apache.thrift.protocol.TProtocol oprot, ThriftRow struct)
        throws org.apache.thrift.TException {
      struct.validate();

      ColumnValue _iter267 = new ColumnValue();
      oprot.writeStructBegin(STRUCT_DESC);
      if (struct.size > 0) {
        oprot.writeFieldBegin(VALUES_FIELD_DESC);
        {
          final BitSet cols = struct.changedColumns;
          if (cols == null) {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(
                org.apache.thrift.protocol.TType.STRUCT, struct.size));
            for (int index = 0; index < struct.size; index++) {
              try {
                struct.setInto(index, _iter267);
              } catch (IOException ioe) {
                throw new org.apache.thrift.transport.TTransportException(ioe);
              }
              _iter267.write(oprot);
            }
          }
          else {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(
                org.apache.thrift.protocol.TType.STRUCT, cols.cardinality()));
            for (int index = cols.nextSetBit(0); index >= 0; index = cols
                .nextSetBit(index + 1)) {
              try {
                struct.setInto(index, _iter267);
              } catch (IOException ioe) {
                throw new org.apache.thrift.transport.TTransportException(ioe);
              }
              _iter267.write(oprot);
            }
          }
          oprot.writeListEnd();
        }
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }
  }

  private static class RowTupleSchemeFactory implements SchemeFactory {
    public RowTupleScheme getScheme() {
      return new RowTupleScheme();
    }
  }

  private static class RowTupleScheme extends TupleScheme<ThriftRow> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, ThriftRow struct)
        throws org.apache.thrift.TException {
      TTupleProtocol oprot = (TTupleProtocol)prot;
      {
        ColumnValue _iter268 = new ColumnValue();
        final BitSet cols = struct.changedColumns;
        if (cols == null) {
          oprot.writeI32(struct.size);
          for (int index = 0; index < struct.size; index++) {
            try {
              struct.setInto(index, _iter268);
            } catch (IOException ioe) {
              throw new org.apache.thrift.transport.TTransportException(ioe);
            }
            _iter268.write(oprot);
          }
        }
        else {
          oprot.writeI32(cols.cardinality());
          for (int index = cols.nextSetBit(0); index >= 0; index = cols
              .nextSetBit(index + 1)) {
            try {
              struct.setInto(index, _iter268);
            } catch (IOException ioe) {
              throw new org.apache.thrift.transport.TTransportException(ioe);
            }
            _iter268.write(oprot);
          }
        }
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, ThriftRow struct)
        throws org.apache.thrift.TException {
      TTupleProtocol iprot = (TTupleProtocol)prot;
      {
        final int size = iprot.readI32();
        ColumnValue _elem271 = new ColumnValue(); // required
        for (int _i270 = 0; _i270 < size; ++_i270) {
          _elem271.clear();
          _elem271.read(iprot);
          try {
            struct.addColumnValue(_elem271);
          } catch (java.sql.SQLException sqle) {
            throw new SnappyException(new SnappyExceptionData(sqle.getMessage(),
                sqle.getSQLState(), sqle.getErrorCode()), null);
          }
        }
      }
    }
  }

  private static <S extends IScheme> S scheme(
      org.apache.thrift.protocol.TProtocol proto) {
    return (StandardScheme.class.equals(proto.getScheme())
        ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
  }
}
