/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.pivotal.gemfirexd.internal.shared.common.error.ClientExceptionUtil;
import io.snappydata.thrift.SnappyException;
import io.snappydata.thrift.SnappyExceptionData;
import java.rmi.ServerException;
import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.transport.TTransportException;

public abstract class ThriftExceptionUtil
extends ClientExceptionUtil {
    protected ThriftExceptionUtil() {
    }

    public static SQLException newSQLException(SnappyException se) {
        SnappyExceptionData payload = se.getExceptionData();
        SQLException sqle = ThriftExceptionUtil.newSQLException(payload, se.getCause(), se.getServerInfo());
        sqle.setStackTrace(se.getStackTrace());
        List<SnappyExceptionData> nextList = se.getNextExceptions();
        SQLException current = sqle;
        if (nextList != null) {
            for (SnappyExceptionData nextData : nextList) {
                if ("X0Z35".equals(nextData.getSqlState())) {
                    Throwable cause = sqle;
                    while (cause.getCause() != null) {
                        cause = cause.getCause();
                    }
                    cause.initCause(new ServerException(nextData.getReason()));
                    continue;
                }
                SQLException next = ThriftExceptionUtil.newSQLException(nextData, null, null);
                current.setNextException(next);
                current = next;
            }
        }
        return sqle;
    }

    public static SQLException newSQLException(SnappyExceptionData payload, Throwable cause, String serverInfo) {
        String message = payload.getReason();
        if (serverInfo != null) {
            message = "(" + serverInfo + ") " + message;
        }
        return factory.getSQLException(message, payload.getSqlState(), payload.getSeverity(), null, cause);
    }

    public static SQLClientInfoException newSQLClientInfoException(String sqlState, Map<String, ClientInfoStatus> failedProperties, Throwable t, Object ... args) {
        return new SQLClientInfoException(ThriftExceptionUtil.getMessageUtil().getCompleteMessage(sqlState, args), ThriftExceptionUtil.getSQLStateFromIdentifier(sqlState), ThriftExceptionUtil.getSeverityFromIdentifier(sqlState), failedProperties, t);
    }

    public static SQLWarning newSQLWarning(SnappyExceptionData payload, Throwable cause) {
        return new SQLWarning(payload.getReason(), payload.getSqlState(), payload.getSeverity(), cause);
    }

    public static SnappyException newSnappyException(String sqlState, Throwable t, String serverInfo, Object ... args) {
        SnappyExceptionData payload = new SnappyExceptionData(ThriftExceptionUtil.getMessageUtil().getCompleteMessage(sqlState, args), ThriftExceptionUtil.getSQLStateFromIdentifier(sqlState), ThriftExceptionUtil.getSeverityFromIdentifier(sqlState));
        SnappyException se = new SnappyException(payload, serverInfo);
        if (t != null) {
            if (t instanceof SnappyException) {
                SnappyException next = (SnappyException)((Object)t);
                se.addToNextExceptions(next.getExceptionData());
                if (next.getNextExceptions() != null) {
                    se.getNextExceptions().addAll(next.getNextExceptions());
                }
            } else {
                se.initCause(t);
            }
        }
        return se;
    }

    public static String getExceptionString(Throwable t) {
        String message;
        String typeMessage = null;
        if (t instanceof TTransportException) {
            TTransportException tte = (TTransportException)t;
            switch (tte.getType()) {
                case 2: {
                    typeMessage = "SOCKET ALREADY OPEN";
                    break;
                }
                case 4: {
                    typeMessage = "SOCKET END OF TRANSMISSION";
                    break;
                }
                case 1: {
                    typeMessage = "SOCKET NOT OPEN";
                    break;
                }
                case 3: {
                    typeMessage = "SOCKET TIMED OUT";
                    break;
                }
                default: {
                    typeMessage = "UNKNOWN SOCKET ERROR";
                    break;
                }
            }
        } else if (t instanceof TProtocolException) {
            TProtocolException tpe = (TProtocolException)t;
            switch (tpe.getType()) {
                case 4: {
                    typeMessage = "BAD PROTOCOL VERSION";
                    break;
                }
                case 1: {
                    typeMessage = "INVALID DATA IN PROTOCOL";
                    break;
                }
                case 2: {
                    typeMessage = "NEGATIVE SIZE IN PROTOCOL";
                    break;
                }
                case 5: {
                    typeMessage = "NOT IMPLEMENTED";
                    break;
                }
                case 3: {
                    typeMessage = "PROTOCOL SIZE LIMIT HIT";
                    break;
                }
                default: {
                    typeMessage = "UNKNOWN PROTOCOL ERROR";
                    break;
                }
            }
        } else if (t instanceof TApplicationException) {
            TApplicationException tae = (TApplicationException)t;
            switch (tae.getType()) {
                case 4: {
                    typeMessage = "BAD SEQUENCE ID";
                    break;
                }
                case 6: {
                    typeMessage = "INTERNAL ERROR";
                    break;
                }
                case 2: {
                    typeMessage = "INVALID MESSAGE TYPE";
                    break;
                }
                case 5: {
                    typeMessage = "MISSING RESULT";
                    break;
                }
                case 7: {
                    typeMessage = "PROTOCOL ERROR";
                    break;
                }
                case 1: {
                    typeMessage = "UNKNOWN METHOD";
                    break;
                }
                case 3: {
                    typeMessage = "WRONG METHOD NAME";
                    break;
                }
                default: {
                    typeMessage = "UNKNOWN APPLICATION ERROR";
                }
            }
        }
        if ((message = t.getLocalizedMessage()) == null || message.length() == 0) {
            message = t.getClass().getName();
        }
        if (typeMessage != null) {
            return message + " [" + typeMessage + ']';
        }
        return message;
    }
}

