/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import io.snappydata.thrift.ServerType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.apache.thrift.transport.TSSLTransportFactory;

public class SocketParameters
extends TSSLTransportFactory.TSSLTransportParameters {
    private static final HashMap<String, Param> paramsMap = new HashMap();
    private static final HashMap<String, Param> sslParamsMap = new HashMap();
    private static final String[] EMPTY_CIPHERS = new String[0];
    private volatile ServerType serverType;
    private boolean hasSSLParams;
    private String[] sslEnabledProtocols;
    private int inputBufferSize = -1;
    private int outputBufferSize = -1;
    private int readTimeout;
    private int keepAliveIdle = -1;
    private int keepAliveInterval = -1;
    private int keepAliveCount = -1;

    public static Collection<Param> getAllParamsNoSSL() {
        return paramsMap.values();
    }

    public static Param findSSLParameterByPropertyName(String propertyName, boolean throwIfNotFound) {
        Param p = sslParamsMap.get(propertyName.toLowerCase(Locale.ENGLISH));
        if (p != null || !throwIfNotFound) {
            return p;
        }
        throw new IllegalArgumentException("Unknown SSL property '" + propertyName + "'; expected one of: " + sslParamsMap.keySet());
    }

    public SocketParameters() {
        super(null, EMPTY_CIPHERS, false);
        this.protocol = null;
    }

    public SocketParameters(ServerType serverType) {
        this();
        this.serverType = serverType;
    }

    public void setServerType(ServerType serverType) {
        this.serverType = serverType;
    }

    public final ServerType getServerType() {
        return this.serverType;
    }

    public final int getInputBufferSize(int defaultValue) {
        if (this.inputBufferSize > 0) {
            return this.inputBufferSize;
        }
        return defaultValue;
    }

    public final int getOutputBufferSize(int defaultValue) {
        if (this.outputBufferSize > 0) {
            return this.outputBufferSize;
        }
        return defaultValue;
    }

    public final int getReadTimeout(int defaultValue) {
        if (this.readTimeout != 0) {
            return this.readTimeout;
        }
        return defaultValue;
    }

    public final int getKeepAliveIdle(int defaultValue) {
        if (this.keepAliveIdle >= 0) {
            return this.keepAliveIdle;
        }
        return defaultValue;
    }

    public final int getKeepAliveInterval(int defaultValue) {
        if (this.keepAliveInterval >= 0) {
            return this.keepAliveInterval;
        }
        return defaultValue;
    }

    public final int getKeepAliveCount(int defaultValue) {
        if (this.keepAliveCount >= 0) {
            return this.keepAliveCount;
        }
        return defaultValue;
    }

    void setHasSSLParams(boolean hasSSLParams) {
        this.hasSSLParams = hasSSLParams;
    }

    public final boolean hasSSLParams() {
        return this.hasSSLParams;
    }

    public final String getSSLProtocol() {
        return this.protocol;
    }

    public final String[] getSSLEnabledProtocols() {
        return this.sslEnabledProtocols;
    }

    public final String getSSLKeyStore() {
        return this.keyStore;
    }

    public final String getSSLKeyPass() {
        return this.keyPass;
    }

    public final String getSSLKeyManagerType() {
        return this.keyManagerType;
    }

    public final String getSSLKeyStoreType() {
        return this.keyStoreType;
    }

    public final String getSSLTrustStore() {
        return this.trustStore;
    }

    public final String getSSLTrustPass() {
        return this.trustPass;
    }

    public final String getSSLTrustManagerType() {
        return this.trustManagerType;
    }

    public final String getSSLTrustStoreType() {
        return this.trustStoreType;
    }

    public final String[] getSSLCipherSuites() {
        return this.cipherSuites;
    }

    public final boolean getSSLClientAuth() {
        return this.clientAuth;
    }

    public final boolean isSSLKeyStoreSet() {
        return this.isKeyStoreSet;
    }

    public final boolean isSSLTrustStoreSet() {
        return this.isTrustStoreSet;
    }

    static /* synthetic */ String[] access$802(SocketParameters x0, String[] x1) {
        x0.sslEnabledProtocols = x1;
        return x1;
    }

    static /* synthetic */ String[] access$902(SocketParameters x0, String[] x1) {
        x0.cipherSuites = x1;
        return x1;
    }

    public static enum Param {
        INPUT_BUFFER_SIZE("socket-input-buffer-size", false){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.inputBufferSize = Integer.parseInt(value);
            }
        }
        ,
        OUTPUT_BUFFER_SIZE("socket-output-buffer-size", false){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.outputBufferSize = Integer.parseInt(value);
            }
        }
        ,
        READ_TIMEOUT("read-timeout", false){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.readTimeout = Integer.parseInt(value);
            }
        }
        ,
        KEEPALIVE_IDLE("keepalive-idle", false){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.keepAliveIdle = Integer.parseInt(value);
            }
        }
        ,
        KEEPALIVE_INTERVAL("keepalive-interval", false){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.keepAliveInterval = Integer.parseInt(value);
            }
        }
        ,
        KEEPALIVE_COUNT("keepalive-count", false){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.keepAliveCount = Integer.parseInt(value);
            }
        }
        ,
        SSL_PROTOCOL("protocol", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.protocol = value;
            }
        }
        ,
        SSL_ENABLED_PROTOCOLS("enabled-protocols", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                SocketParameters.access$802(params, value.split(":"));
            }
        }
        ,
        SSL_CIPHER_SUITES("cipher-suites", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                SocketParameters.access$902(params, value.split(":"));
            }
        }
        ,
        SSL_CLIENT_AUTH("client-auth", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.clientAuth = Boolean.parseBoolean(value);
            }
        }
        ,
        SSL_KEYSTORE("keystore", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.keyStore = value;
            }
        }
        ,
        SSL_KEYSTORE_TYPE("keystore-type", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.keyStoreType = value;
            }
        }
        ,
        SSL_KEYSTORE_PASSWORD("keystore-password", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.keyPass = value;
            }
        }
        ,
        SSL_KEYMANAGER_TYPE("keymanager-type", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.keyManagerType = value;
            }
        }
        ,
        SSL_TRUSTSTORE("truststore", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.trustStore = value;
            }
        }
        ,
        SSL_TRUSTSTORE_TYPE("truststore-type", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.trustStoreType = value;
            }
        }
        ,
        SSL_TRUSTSTORE_PASSWORD("truststore-password", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.trustPass = value;
            }
        }
        ,
        SSL_TRUSTMANAGER_TYPE("trustmanager-type", true){

            @Override
            public void setParameter(SocketParameters params, String value) {
                params.trustManagerType = value;
            }
        };

        private final String propertyName;

        private Param(String propertyName, boolean ssl) {
            this.propertyName = propertyName;
            if (ssl) {
                sslParamsMap.put(propertyName, this);
            } else {
                paramsMap.put(propertyName, this);
            }
        }

        public abstract void setParameter(SocketParameters var1, String var2);

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

