/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import com.gemstone.gemfire.internal.shared.SystemProperties;
import io.snappydata.thrift.HostAddress;
import io.snappydata.thrift.common.SnappyTSSLSocketFactory;
import io.snappydata.thrift.common.SnappyTSocket;
import io.snappydata.thrift.common.SocketParameters;
import io.snappydata.thrift.common.SocketTimeout;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnappyTSSLSocket
extends TSocket
implements SocketTimeout {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SnappyTSSLSocket.class.getName());
    private InetAddress hostAddress;
    private int port;
    private volatile int timeout;
    private int inputBufferSize = SystemProperties.getClientInstance().getSocketInputBufferSize();
    private int outputBufferSize = SystemProperties.getClientInstance().getSocketOutputBufferSize();

    public SnappyTSSLSocket(Socket socket, int timeout, SocketParameters params, SystemProperties props) throws TTransportException {
        super(socket);
        if (this.isOpen()) {
            try {
                this.setProperties(socket, timeout, params, props);
                this.inputStream_ = new BufferedInputStream(socket.getInputStream(), this.inputBufferSize);
                this.outputStream_ = new BufferedOutputStream(socket.getOutputStream(), this.outputBufferSize);
            }
            catch (IOException ioe) {
                this.close();
                throw new TTransportException(1, (Throwable)ioe);
            }
        }
    }

    public SnappyTSSLSocket(HostAddress host, SocketParameters params, SystemProperties props) throws TTransportException {
        this(host.resolveHost(), host.getPort(), params, props, params.getReadTimeout(0));
    }

    public SnappyTSSLSocket(InetAddress hostAddress, int port, SocketParameters params, SystemProperties props, int timeout) throws TTransportException {
        super(SnappyTSSLSocket.initSSLSocket(hostAddress, port, params, timeout));
        this.hostAddress = hostAddress;
        this.port = port;
        this.setProperties(this.getSocket(), timeout, params, props);
        if (!this.isOpen()) {
            this.open();
        }
    }

    private static Socket initSSLSocket(InetAddress hostAddress, int port, SocketParameters sockParams, int timeout) throws TTransportException {
        return SnappyTSSLSocketFactory.getClientSocket(hostAddress, port, timeout, sockParams);
    }

    public void setTimeout(int timeout) {
        try {
            this.getSocket().setSoTimeout(timeout);
            this.timeout = timeout;
        }
        catch (SocketException se) {
            LOGGER.warn("Could not set socket timeout.", (Throwable)se);
        }
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.getSocket().getSoTimeout();
    }

    @Override
    public int getRawTimeout() {
        return this.timeout;
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.getSocket().setSoTimeout(timeout);
        this.timeout = timeout;
    }

    @Override
    public void setTimeout(int timeout, SocketParameters params, SystemProperties props) throws SocketException {
        this.timeout = SnappyTSocket.setTimeout(this.getSocket(), timeout, params, props);
    }

    protected void setProperties(Socket socket, int timeout, SocketParameters params, SystemProperties props) throws TTransportException {
        this.inputBufferSize = params.getInputBufferSize(props.getSocketInputBufferSize());
        this.outputBufferSize = params.getOutputBufferSize(props.getSocketOutputBufferSize());
        try {
            socket.setSoLinger(false, 0);
            socket.setTcpNoDelay(true);
            this.timeout = SnappyTSocket.setTimeout(socket, timeout, params, props);
        }
        catch (SocketException se) {
            LOGGER.warn("Could not set socket timeout.", (Throwable)se);
            throw new TTransportException(1, "Could not set socket timeout.", (Throwable)se);
        }
    }

    public void open() throws TTransportException {
        if (this.isOpen()) {
            throw new TTransportException(2, "Socket already connected.");
        }
        if (this.hostAddress == null) {
            throw new TTransportException(1, "Cannot open null host.");
        }
        if (this.port <= 0) {
            throw new TTransportException(1, "Cannot open without port.");
        }
        Socket socket = this.getSocket();
        try {
            socket.connect(new InetSocketAddress(this.hostAddress, this.port), this.timeout);
            this.inputStream_ = new BufferedInputStream(socket.getInputStream(), this.inputBufferSize);
            this.outputStream_ = new BufferedOutputStream(socket.getOutputStream(), this.outputBufferSize);
        }
        catch (IOException ioe) {
            this.close();
            throw new TTransportException(1, (Throwable)ioe);
        }
    }
}

