/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift;

import org.apache.thrift.TEnum;

public enum ServerType implements TEnum
{
    DRDA(1){

        @Override
        public String getProtocolString() {
            return "DRDA";
        }
    }
    ,
    THRIFT_LOCATOR_CP(2){

        @Override
        public boolean isThriftLocator() {
            return true;
        }

        @Override
        public boolean isThriftWithDefaults() {
            return true;
        }

        @Override
        public String getProtocolString() {
            return "Compact Protocol";
        }
    }
    ,
    THRIFT_LOCATOR_BP(3){

        @Override
        public boolean isThriftLocator() {
            return true;
        }

        @Override
        public boolean isThriftBinaryProtocol() {
            return true;
        }

        @Override
        public String getProtocolString() {
            return "Binary Protocol";
        }
    }
    ,
    THRIFT_LOCATOR_CP_SSL(4){

        @Override
        public boolean isThriftLocator() {
            return true;
        }

        @Override
        public boolean isThriftSSL() {
            return true;
        }

        @Override
        public String getProtocolString() {
            return "Compact Protocol with SSL";
        }
    }
    ,
    THRIFT_LOCATOR_BP_SSL(5){

        @Override
        public boolean isThriftLocator() {
            return true;
        }

        @Override
        public boolean isThriftBinaryProtocol() {
            return true;
        }

        @Override
        public boolean isThriftSSL() {
            return true;
        }

        @Override
        public String getProtocolString() {
            return "Binary Protocol with SSL";
        }
    }
    ,
    THRIFT_SNAPPY_CP(6){

        @Override
        public boolean isThriftSnappy() {
            return true;
        }

        @Override
        public boolean isThriftWithDefaults() {
            return true;
        }

        @Override
        public ServerType getCorrespondingLocatorType() {
            return THRIFT_LOCATOR_CP;
        }

        @Override
        public String getProtocolString() {
            return "Compact Protocol";
        }
    }
    ,
    THRIFT_SNAPPY_BP(7){

        @Override
        public boolean isThriftSnappy() {
            return true;
        }

        @Override
        public boolean isThriftBinaryProtocol() {
            return true;
        }

        @Override
        public ServerType getCorrespondingLocatorType() {
            return THRIFT_LOCATOR_BP;
        }

        @Override
        public String getProtocolString() {
            return "Binary Protocol";
        }
    }
    ,
    THRIFT_SNAPPY_CP_SSL(8){

        @Override
        public boolean isThriftSnappy() {
            return true;
        }

        @Override
        public boolean isThriftSSL() {
            return true;
        }

        @Override
        public ServerType getCorrespondingLocatorType() {
            return THRIFT_LOCATOR_CP_SSL;
        }

        @Override
        public String getProtocolString() {
            return "Compact Protocol with SSL";
        }
    }
    ,
    THRIFT_SNAPPY_BP_SSL(9){

        @Override
        public boolean isThriftSnappy() {
            return true;
        }

        @Override
        public boolean isThriftBinaryProtocol() {
            return true;
        }

        @Override
        public boolean isThriftSSL() {
            return true;
        }

        @Override
        public ServerType getCorrespondingLocatorType() {
            return THRIFT_LOCATOR_BP_SSL;
        }

        @Override
        public String getProtocolString() {
            return "Binary Protocol with SSL";
        }
    };

    public static final String NETSERVER_GROUP_PREFIX = "__SNAPPY_NETWORKSERVICE_";
    private final int value;
    private final String groupName;

    private ServerType(int value) {
        this.value = value;
        this.groupName = NETSERVER_GROUP_PREFIX + this.name();
    }

    public final int getValue() {
        return this.value;
    }

    public static ServerType findByValue(int value) {
        switch (value) {
            case 1: {
                return DRDA;
            }
            case 2: {
                return THRIFT_LOCATOR_CP;
            }
            case 3: {
                return THRIFT_LOCATOR_BP;
            }
            case 4: {
                return THRIFT_LOCATOR_CP_SSL;
            }
            case 5: {
                return THRIFT_LOCATOR_BP_SSL;
            }
            case 6: {
                return THRIFT_SNAPPY_CP;
            }
            case 7: {
                return THRIFT_SNAPPY_BP;
            }
            case 8: {
                return THRIFT_SNAPPY_CP_SSL;
            }
            case 9: {
                return THRIFT_SNAPPY_BP_SSL;
            }
        }
        return null;
    }

    public final String getServerGroupName() {
        return this.groupName;
    }

    public final boolean isDRDA() {
        return this == DRDA;
    }

    public final boolean isThrift() {
        return this != DRDA;
    }

    public boolean isThriftLocator() {
        return false;
    }

    public boolean isThriftSnappy() {
        return false;
    }

    public boolean isThriftWithDefaults() {
        return false;
    }

    public boolean isThriftBinaryProtocol() {
        return false;
    }

    public boolean isThriftSSL() {
        return false;
    }

    public static ServerType getServerType(boolean isServer, boolean useBinaryProtocol, boolean useSSL) {
        if (isServer) {
            if (useSSL) {
                return useBinaryProtocol ? THRIFT_SNAPPY_BP_SSL : THRIFT_SNAPPY_CP_SSL;
            }
            return useBinaryProtocol ? THRIFT_SNAPPY_BP : THRIFT_SNAPPY_CP;
        }
        if (useSSL) {
            return useBinaryProtocol ? THRIFT_LOCATOR_BP_SSL : THRIFT_LOCATOR_CP_SSL;
        }
        return useBinaryProtocol ? THRIFT_LOCATOR_BP : THRIFT_LOCATOR_CP;
    }

    public ServerType getCorrespondingLocatorType() {
        return null;
    }

    public abstract String getProtocolString();

    public static final ServerType findByGroupName(String serverGroupName) {
        if (serverGroupName.startsWith(NETSERVER_GROUP_PREFIX)) {
            String serverType = serverGroupName.substring(NETSERVER_GROUP_PREFIX.length());
            return ServerType.valueOf(serverType);
        }
        return DRDA;
    }
}

