/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common.i18n;

import com.pivotal.gemfirexd.internal.shared.common.i18n.SQLMessageFormat;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageUtil
implements SQLMessageFormat {
    public static final Locale US = new Locale("en", "US");
    private String resourceBundleName;

    public MessageUtil(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    @Override
    public final String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getTextMessage(String messageID) {
        return this.getCompleteMessage(messageID, null);
    }

    public String getTextMessage(String messageID, Object a1) {
        return this.getCompleteMessage(messageID, new Object[]{a1});
    }

    public String getTextMessage(String messageID, Object a1, Object a2) {
        return this.getCompleteMessage(messageID, new Object[]{a1, a2});
    }

    public String getTextMessage(String messageID, Object a1, Object a2, Object a3) {
        return this.getCompleteMessage(messageID, new Object[]{a1, a2, a3});
    }

    public String getTextMessage(String messageID, Object a1, Object a2, Object a3, Object a4) {
        return this.getCompleteMessage(messageID, new Object[]{a1, a2, a3, a4});
    }

    @Override
    public String getCompleteMessage(String messageID, Object[] args) {
        return MessageUtil.getCompleteMessage(messageID, this.resourceBundleName, args);
    }

    public static String getCompleteMessage(Locale locale, String resourceBundleName, String messageId, Object[] arguments, boolean composeDefault) throws MissingResourceException {
        try {
            return MessageUtil.formatMessage(resourceBundleName != null ? ResourceBundle.getBundle(resourceBundleName, locale) : null, messageId, arguments, false);
        }
        catch (MissingResourceException mre) {
            return MessageUtil.formatMessage(resourceBundleName != null ? ResourceBundle.getBundle(resourceBundleName, US) : null, messageId, arguments, composeDefault);
        }
    }

    public static String getCompleteMessage(String messageId, String resourceBundleName, Object[] arguments) throws MissingResourceException {
        return MessageUtil.getCompleteMessage(Locale.getDefault(), resourceBundleName, messageId, arguments, true);
    }

    public static String formatMessage(ResourceBundle bundle, String messageId, Object[] arguments, boolean composeDefault) {
        block8: {
            String message = null;
            Object badArgsMessage = null;
            if (arguments == null) {
                arguments = new Object[]{};
            }
            if (bundle != null) {
                try {
                    message = bundle.getString(messageId);
                    int numExpected = MessageUtil.countParams(message);
                    if (numExpected != arguments.length) {
                        SanityManager.ASSERT(numExpected == arguments.length, "Number of parameters expected for message id " + messageId + " (" + numExpected + ") does not match number of arguments received (" + arguments.length + ")");
                    }
                    try {
                        return MessageFormat.format(message, arguments);
                    }
                    catch (IllegalArgumentException iae) {
                        throw iae;
                    }
                    catch (NullPointerException npe) {
                        throw npe;
                    }
                }
                catch (MissingResourceException mre) {
                    if (composeDefault) break block8;
                    throw mre;
                }
            }
        }
        return MessageUtil.composeDefaultMessage("UNKNOWN MESSAGE, id " + messageId, arguments);
    }

    private static int countParams(String message) {
        boolean openFound = false;
        int numparams = 0;
        for (int i = 0; i < message.length(); ++i) {
            char ch = message.charAt(i);
            if (ch == '{') {
                openFound = true;
            }
            if (ch != '}' || !openFound) continue;
            ++numparams;
            openFound = false;
        }
        return numparams;
    }

    public static String composeDefaultMessage(String message, Object[] arguments) {
        if (message == null) {
            message = "UNKNOWN";
        }
        StringBuilder sb = new StringBuilder(message);
        if (arguments == null) {
            return sb.toString();
        }
        sb.append(" : ");
        int len = arguments.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('[');
            sb.append(i);
            sb.append("] ");
            if (arguments[i] == null) {
                sb.append("null");
                continue;
            }
            sb.append(arguments[i].toString());
        }
        return sb.toString();
    }
}

