/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common;

import com.pivotal.gemfirexd.internal.shared.common.StopWatch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SharedUtils {
    public static final int TIMESTAMP_RLENGTH = 26;
    public static final String VM_DATASTORE = "datastore";
    public static final String VM_ACCESSOR = "accessor";
    public static final String VM_LOCATOR = "locator";
    public static final String VM_AGENT = "agent";
    public static final String VM_ADMIN = "admin";
    private static final Pattern csvPattern = Pattern.compile("[\\s]*(,[\\s]*)|$");
    public static final int HA_RETRY_SLEEP_MILLIS = 10;
    public static final String GFXD_PRODUCT_NAME = "SnappyData";
    public static final String GFXD_VERSION_PROPERTIES = "com/pivotal/gemfirexd/internal/GemFireXDVersion.properties";
    public static final CSVVisitor<Collection<String>, Boolean> stringAggregator = new CSVVisitor<Collection<String>, Boolean>(){

        @Override
        public void visit(String str, Collection<String> strings, Boolean caseSensitive) {
            if (caseSensitive.booleanValue()) {
                strings.add(str);
            } else {
                strings.add(SharedUtils.SQLToUpperCase(str));
            }
        }
    };

    private SharedUtils() {
    }

    public static int parseTimestampString(String timestamp, Calendar cal) {
        int zeroBase = 48;
        cal.set(1, 1000 * (timestamp.charAt(0) - 48) + 100 * (timestamp.charAt(1) - 48) + 10 * (timestamp.charAt(2) - 48) + (timestamp.charAt(3) - 48));
        cal.set(2, 10 * (timestamp.charAt(5) - 48) + (timestamp.charAt(6) - 48) - 1);
        cal.set(5, 10 * (timestamp.charAt(8) - 48) + (timestamp.charAt(9) - 48));
        cal.set(11, 10 * (timestamp.charAt(11) - 48) + (timestamp.charAt(12) - 48));
        cal.set(12, 10 * (timestamp.charAt(14) - 48) + (timestamp.charAt(15) - 48));
        cal.set(13, 10 * (timestamp.charAt(17) - 48) + (timestamp.charAt(18) - 48));
        int micros = 100000 * (timestamp.charAt(20) - 48) + 10000 * (timestamp.charAt(21) - 48) + 1000 * (timestamp.charAt(22) - 48) + 100 * (timestamp.charAt(23) - 48) + 10 * (timestamp.charAt(24) - 48) + (timestamp.charAt(25) - 48);
        cal.set(14, micros / 1000);
        return micros;
    }

    public static byte[] timestampToTimestampChars(Timestamp timestamp, Calendar cal) {
        byte[] bytes = new byte[26];
        int len = SharedUtils.timestampToTimestampChars(bytes, 0, timestamp, cal, true);
        assert (len == 26);
        return bytes;
    }

    public static int timestampToTimestampChars(byte[] buffer, int offset, Timestamp timestamp, Calendar cal) {
        return SharedUtils.timestampToTimestampChars(buffer, offset, timestamp, cal, false);
    }

    public static int dateTimeToString(char[] buffer, int offset, int year, int month, int day, int hour, int minute, int second, int microsecond, int nanos, boolean clientFormat) {
        int timeSep;
        int dateTimeSep;
        int zeroBase = 48;
        if (clientFormat) {
            dateTimeSep = 45;
            timeSep = 46;
        } else {
            dateTimeSep = 32;
            timeSep = 58;
        }
        if (month >= 0) {
            if (year > 9999) {
                year = 9999;
            }
            buffer[offset++] = (char)(year / 1000 + 48);
            buffer[offset++] = (char)(year % 1000 / 100 + 48);
            buffer[offset++] = (char)(year % 100 / 10 + 48);
            buffer[offset++] = (char)(year % 10 + 48);
            buffer[offset++] = 45;
            buffer[offset++] = (char)(month / 10 + 48);
            buffer[offset++] = (char)(month % 10 + 48);
            buffer[offset++] = 45;
            buffer[offset++] = (char)(day / 10 + 48);
            buffer[offset++] = (char)(day % 10 + 48);
            if (hour >= 0) {
                buffer[offset++] = dateTimeSep;
            }
        }
        if (hour >= 0) {
            buffer[offset++] = (char)(hour / 10 + 48);
            buffer[offset++] = (char)(hour % 10 + 48);
            buffer[offset++] = timeSep;
            buffer[offset++] = (char)(minute / 10 + 48);
            buffer[offset++] = (char)(minute % 10 + 48);
            buffer[offset++] = timeSep;
            buffer[offset++] = (char)(second / 10 + 48);
            buffer[offset++] = (char)(second % 10 + 48);
        }
        if (nanos < 0) {
            if (microsecond >= 0) {
                buffer[offset++] = 46;
                buffer[offset++] = (char)(microsecond / 100000 + 48);
                buffer[offset++] = (char)(microsecond % 100000 / 10000 + 48);
                buffer[offset++] = (char)(microsecond % 10000 / 1000 + 48);
                buffer[offset++] = (char)(microsecond % 1000 / 100 + 48);
                buffer[offset++] = (char)(microsecond % 100 / 10 + 48);
                buffer[offset] = (char)(microsecond % 10 + 48);
            }
        } else {
            buffer[offset++] = 46;
            buffer[offset++] = (char)(nanos / 100000000 + 48);
            if (nanos > 0) {
                int startDivisor;
                int startFactor = 100000000;
                if (!clientFormat) {
                    for (startDivisor = 10000000; nanos % 10 == 0 && startDivisor > 0; startDivisor /= 10) {
                        nanos /= 10;
                        startFactor /= 10;
                    }
                }
                while (startDivisor > 0) {
                    buffer[offset++] = (char)(nanos % startFactor / startDivisor + 48);
                    startFactor /= 10;
                    startDivisor /= 10;
                }
            }
        }
        return offset;
    }

    public static int dateTimeToChars(byte[] buffer, int offset, int year, int month, int day, int hour, int minute, int second, int microsecond, int nanos, boolean clientFormat) {
        int timeSep;
        int dateTimeSep;
        int zeroBase = 48;
        if (clientFormat) {
            dateTimeSep = 45;
            timeSep = 46;
        } else {
            dateTimeSep = 32;
            timeSep = 58;
        }
        if (month >= 0) {
            if (year > 9999) {
                year = 9999;
            }
            buffer[offset++] = (byte)(year / 1000 + 48);
            buffer[offset++] = (byte)(year % 1000 / 100 + 48);
            buffer[offset++] = (byte)(year % 100 / 10 + 48);
            buffer[offset++] = (byte)(year % 10 + 48);
            buffer[offset++] = 45;
            buffer[offset++] = (byte)(month / 10 + 48);
            buffer[offset++] = (byte)(month % 10 + 48);
            buffer[offset++] = 45;
            buffer[offset++] = (byte)(day / 10 + 48);
            buffer[offset++] = (byte)(day % 10 + 48);
            if (hour >= 0) {
                buffer[offset++] = dateTimeSep;
            }
        }
        if (hour >= 0) {
            buffer[offset++] = (byte)(hour / 10 + 48);
            buffer[offset++] = (byte)(hour % 10 + 48);
            buffer[offset++] = timeSep;
            buffer[offset++] = (byte)(minute / 10 + 48);
            buffer[offset++] = (byte)(minute % 10 + 48);
            buffer[offset++] = timeSep;
            buffer[offset++] = (byte)(second / 10 + 48);
            buffer[offset++] = (byte)(second % 10 + 48);
        }
        if (nanos < 0) {
            if (microsecond >= 0) {
                buffer[offset++] = 46;
                buffer[offset++] = (byte)(microsecond / 100000 + 48);
                buffer[offset++] = (byte)(microsecond % 100000 / 10000 + 48);
                buffer[offset++] = (byte)(microsecond % 10000 / 1000 + 48);
                buffer[offset++] = (byte)(microsecond % 1000 / 100 + 48);
                buffer[offset++] = (byte)(microsecond % 100 / 10 + 48);
                buffer[offset] = (byte)(microsecond % 10 + 48);
            }
        } else {
            buffer[offset++] = 46;
            buffer[offset++] = (byte)(nanos / 100000000 + 48);
            buffer[offset++] = (byte)(nanos % 100000000 / 10000000 + 48);
            buffer[offset++] = (byte)(nanos % 10000000 / 1000000 + 48);
            buffer[offset++] = (byte)(nanos % 1000000 / 100000 + 48);
            buffer[offset++] = (byte)(nanos % 100000 / 10000 + 48);
            buffer[offset++] = (byte)(nanos % 10000 / 1000 + 48);
            buffer[offset++] = (byte)(nanos % 1000 / 100 + 48);
            buffer[offset++] = (byte)(nanos % 100 / 10 + 48);
            buffer[offset] = (byte)(nanos % 10 + 48);
        }
        return offset;
    }

    private static int timestampToTimestampChars(byte[] buffer, int offset, Timestamp timestamp, Calendar cal, boolean truncateYear) {
        cal.setTime(timestamp);
        int year = cal.get(1);
        if (year > 9999) {
            if (truncateYear) {
                year = 9999;
            } else {
                return -year;
            }
        }
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = timestamp.getNanos() / 1000;
        SharedUtils.dateTimeToChars(buffer, offset, year, month, day, hour, minute, second, microsecond, -1, true);
        return 26;
    }

    public static String SQLToUpperCase(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    public static InputStream openURL(String externalPath) throws IOException {
        return SharedUtils.openURL(null, externalPath);
    }

    public static InputStream openURL(final String scriptPath, final String externalPath) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    try {
                        return new URL(externalPath).openStream();
                    }
                    catch (MalformedURLException mfurle) {
                        try {
                            return new FileInputStream(externalPath);
                        }
                        catch (FileNotFoundException fnfe) {
                            return new FileInputStream(new File(scriptPath, externalPath));
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            IOException ioe = new IOException();
            ioe.initCause(e.getException());
            throw ioe;
        }
    }

    public static SortedSet<String> toSortedSet(String csv, boolean caseSensitive) {
        TreeSet<String> strings = new TreeSet<String>();
        SharedUtils.splitCSV(csv, stringAggregator, strings, caseSensitive);
        return strings;
    }

    public static <A, C> void splitCSV(String csv, CSVVisitor<A, C> visitor, A action, C context) {
        int csvLen;
        if (csv != null && (csvLen = csv.length()) > 0) {
            int start;
            for (start = 0; start < csvLen && Character.isWhitespace(csv.charAt(start)); ++start) {
            }
            if (start < csvLen) {
                Matcher mt = csvPattern.matcher(csv);
                while (mt.find()) {
                    int end;
                    for (end = mt.start(); end > 0 && Character.isWhitespace(csv.charAt(end - 1)); --end) {
                    }
                    String str = csv.substring(start, end);
                    if (str.length() > 0) {
                        visitor.visit(str, action, context);
                    }
                    start = mt.end();
                }
            }
        }
    }

    public static String toCSV(Collection<?> collection) {
        StringBuilder csv = new StringBuilder();
        if (collection != null) {
            boolean firstObj = true;
            Iterator<?> iter = collection.iterator();
            while (iter.hasNext()) {
                if (!firstObj) {
                    csv.append(',');
                } else {
                    firstObj = false;
                }
                csv.append(iter.next());
            }
        }
        return csv.toString();
    }

    public static String getHostPort(String hostPort, int[] port) {
        int len = hostPort.length();
        try {
            int spos;
            if (hostPort.charAt(len - 1) == ']' && (spos = hostPort.indexOf(91)) >= 0) {
                port[0] = Integer.parseInt(hostPort.substring(spos + 1, len - 1));
                return hostPort.substring(0, spos);
            }
            spos = hostPort.indexOf(58);
            if (spos >= 0) {
                port[0] = Integer.parseInt(hostPort.substring(spos + 1));
                return hostPort.substring(0, spos);
            }
        }
        catch (NumberFormatException nfe) {
            throw new NumberFormatException("failed to parse integer port in given host[port] string '" + hostPort + "': " + nfe.getLocalizedMessage());
        }
        throw new NumberFormatException("failed to split given host[port] string: " + hostPort);
    }

    public static Properties getAttributes(String url, Properties info) throws SQLException {
        Properties finfo = new Properties(info);
        info = null;
        StringTokenizer st = new StringTokenizer(url, ";");
        st.nextToken();
        while (st.hasMoreTokens()) {
            String v = st.nextToken();
            int eqPos = v.indexOf(61);
            if (eqPos == -1) {
                throw new SQLException("The URL '" + url + "' is not properly formed.", "XJ028", 40000);
            }
            finfo.put(v.substring(0, eqPos).trim(), v.substring(eqPos + 1).trim());
        }
        return finfo;
    }

    public static void printStackTrace(Throwable t, PrintWriter pw, boolean onlyStack) {
        int level = 0;
        int commonTraceIndex = 0;
        int commonTraceCauseIndex = 0;
        int framesInCommon = 0;
        StackTraceElement[] causedTrace = null;
        while (t != null) {
            SQLException next;
            StackTraceElement[] trace = t.getStackTrace();
            if (level > 0) {
                commonTraceIndex = trace.length - 1;
                for (commonTraceCauseIndex = causedTrace.length - 1; commonTraceIndex >= 0 && commonTraceCauseIndex >= 0 && trace[commonTraceIndex].equals(causedTrace[commonTraceCauseIndex]); --commonTraceIndex, --commonTraceCauseIndex) {
                }
                framesInCommon = trace.length - 1 - commonTraceIndex;
                pw.println("============= begin nested exception, level (" + level + ") ===========");
            }
            if (onlyStack) {
                pw.println(t.getClass());
            } else {
                pw.println(t.toString());
            }
            for (StackTraceElement traceElement : trace) {
                pw.print("\tat ");
                pw.println(traceElement);
                if (level > 0 && commonTraceIndex-- == 0) break;
            }
            if (framesInCommon > 0) {
                pw.println("\t... " + framesInCommon + " more");
            }
            t = t instanceof SQLException ? ((next = ((SQLException)t).getNextException()) == null ? t.getCause() : next) : t.getCause();
            if (level > 0) {
                pw.println("============= end nested exception, level (" + level + ") ===========");
            }
            ++level;
            causedTrace = trace;
        }
    }

    public static StopWatch newTimer(long startTime) {
        return startTime > 0L ? new StopWatch(startTime) : null;
    }

    public static String quoteString(String source, char quote) {
        StringBuilder quoted = new StringBuilder(source.length() + 2);
        quoted.append(quote);
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            if (c == quote) {
                quoted.append(quote);
            }
            quoted.append(c);
        }
        quoted.append(quote);
        return quoted.toString();
    }

    public static interface CSVVisitor<A, C> {
        public void visit(String var1, A var2, C var3);
    }
}

