/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common;

import com.pivotal.gemfirexd.internal.shared.common.QueueObjectCreator;
import java.sql.SQLException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class BoundedLinkedQueue
extends LinkedBlockingQueue {
    private static final long serialVersionUID = -1140833386102748319L;
    AtomicInteger createdCnt = new AtomicInteger(0);
    final int maxQueueSize;
    private final QueueObjectCreator objectCreator;
    final long MAX_POLL_MILLIS = 1000L;
    final int MAX_POLL_TRIES = 360;

    public BoundedLinkedQueue(int capacity, QueueObjectCreator c) {
        super(capacity);
        this.maxQueueSize = capacity;
        this.objectCreator = c;
    }

    public void returnBack(Object o) throws InterruptedException {
        this.put(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createOrGetExisting() throws SQLException, InterruptedException {
        int tries = 1;
        while (true) {
            Object ret;
            if ((ret = this.poll()) != null) {
                return ret;
            }
            int currCnt = this.createdCnt.intValue();
            if (currCnt >= this.maxQueueSize) {
                ret = this.poll(1000L, TimeUnit.MILLISECONDS);
                if (ret != null) {
                    return ret;
                }
                if (tries++ < 360) continue;
                throw new SQLException("A connection could not be obtained within the time (360000ms) requested", "40XL1", 40000);
            }
            if (this.createdCnt.compareAndSet(currCnt, currCnt + 1)) break;
        }
        Object conn = null;
        try {
            Object object = conn = this.objectCreator.create();
            return object;
        }
        finally {
            if (conn == null) {
                this.createdCnt.decrementAndGet();
            }
        }
    }

    public void removeConnection(Object conn) throws InterruptedException {
        this.createdCnt.decrementAndGet();
        this.remove(conn);
    }
}

