/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.thrift.common;

import io.snappydata.thrift.common.SocketParameters;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.thrift.transport.TTransportException;

public abstract class SnappyTSSLSocketFactory {
    private static final String[] DEFAULT_PROTOCOLS = new String[]{"TLSv1.2", "Default", "TLSv1", "TLS"};

    private SnappyTSSLSocketFactory() {
    }

    public static SSLSocket getClientSocket(InetAddress hostAddress, int port, int timeout, SocketParameters params) throws TTransportException {
        if (params == null) {
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            return SnappyTSSLSocketFactory.createClient(factory, hostAddress, port, timeout, null);
        }
        if (!params.isSSLKeyStoreSet() && !params.isSSLTrustStoreSet()) {
            throw new TTransportException("Either one of the KeyStore or TrustStore must be set for SSLSocketParameters");
        }
        SSLContext ctx = SnappyTSSLSocketFactory.createSSLContext(params);
        return SnappyTSSLSocketFactory.createClient(ctx.getSocketFactory(), hostAddress, port, timeout, params);
    }

    private static SSLSocket createClient(SSLSocketFactory factory, InetAddress hostAddress, int port, int timeout, SocketParameters params) throws TTransportException {
        try {
            SSLSocket socket = (SSLSocket)factory.createSocket(hostAddress, port);
            socket.setSoTimeout(timeout);
            if (params != null) {
                if (params.getSSLEnabledProtocols() != null) {
                    socket.setEnabledProtocols(params.getSSLEnabledProtocols());
                }
                if (params.getSSLCipherSuites() != null) {
                    socket.setEnabledCipherSuites(params.getSSLCipherSuites());
                }
            }
            return socket;
        }
        catch (IOException ioe) {
            throw new TTransportException(1, (Throwable)ioe);
        }
        catch (Exception e) {
            throw new TTransportException(1, "Could not connect to " + hostAddress + " on port " + port, (Throwable)e);
        }
    }

    public static SSLContext createSSLContext(SocketParameters params) throws TTransportException {
        SSLContext ctx;
        FileInputStream tsInput = null;
        FileInputStream ksInput = null;
        try {
            if (params.getSSLProtocol() != null) {
                ctx = SSLContext.getInstance(params.getSSLProtocol());
            } else {
                ctx = null;
                NoSuchAlgorithmException failure = null;
                for (String protocol : DEFAULT_PROTOCOLS) {
                    try {
                        ctx = SSLContext.getInstance(protocol);
                        break;
                    }
                    catch (NoSuchAlgorithmException nsae) {
                        failure = nsae;
                    }
                }
                if (ctx == null) {
                    throw failure;
                }
            }
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            if (params.isSSLTrustStoreSet()) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(params.getSSLTrustManagerType());
                KeyStore ts = KeyStore.getInstance(params.getSSLTrustStoreType());
                tsInput = new FileInputStream(params.getSSLTrustStore());
                ts.load(tsInput, params.getSSLTrustPass().toCharArray());
                tmf.init(ts);
                trustManagers = tmf.getTrustManagers();
            }
            if (params.isSSLKeyStoreSet()) {
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(params.getSSLKeyManagerType());
                KeyStore ks = KeyStore.getInstance(params.getSSLKeyStoreType());
                char[] keyPass = params.getSSLKeyPass() != null ? params.getSSLKeyPass().toCharArray() : null;
                ksInput = new FileInputStream(params.getSSLKeyStore());
                ks.load(ksInput, keyPass);
                kmf.init(ks, keyPass);
                keyManagers = kmf.getKeyManagers();
            }
            ctx.init(keyManagers, trustManagers, null);
        }
        catch (Exception e) {
            throw new TTransportException("Error creating the transport", (Throwable)e);
        }
        finally {
            if (tsInput != null) {
                try {
                    tsInput.close();
                }
                catch (Exception exception) {}
            }
            if (ksInput != null) {
                try {
                    ksInput.close();
                }
                catch (Exception exception) {}
            }
        }
        return ctx;
    }
}

