/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common.sanity;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.AssertFailure;
import com.pivotal.gemfirexd.internal.shared.common.sanity.GfxdHeaderPrintWriter;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SanityManager {
    public static final boolean ASSERT = true;
    public static final boolean DEBUG = true;
    public static final String DEBUGDEBUG = "DumpSanityDebug";
    public static final boolean DEBUG_ASSERT = false;
    private static final PrintWriter DEFAULT_WRITER;
    private static PrintWriter debugStream;
    private static Map DebugFlags;
    public static final String TRACE_CLIENT_HA = "TraceClientHA";
    public static final String TRACE_CLIENT_CONN = "TraceClientConn";
    public static final String TRACE_CLIENT_STMT = "TraceClientStatement";
    public static final String TRACE_CLIENT_STMT_MS = "TraceClientStatementMillis";
    public static final String TRACE_MEMORY_LEAK = "TraceMemoryLeak";
    public static final String TRACE_CACHE = "TraceCache";
    public static final String TRACE_SINGLE_HOP = "TraceSingleHop";
    public static final String TEST_MODE_NON_TX = "TEST_MODE_NON_TX";
    public static boolean TraceClientHA;
    public static boolean TraceClientConn;
    public static boolean TraceClientStatement;
    public static boolean TraceClientStatementMillis;
    public static boolean TraceClientStatementHA;
    public static boolean TraceMemoryLeak;
    public static boolean TraceCache;
    public static boolean TraceSingleHop;
    public static final String DEBUG_TRUE = "gemfirexd.debug.true";
    public static final String DEBUG_FALSE = "gemfirexd.debug.false";
    public static boolean isFineEnabled;
    public static boolean isFinerEnabled;
    private static boolean AllDebugOn;
    private static boolean AllDebugOff;
    public static final String lineSeparator;
    public static final String DEBUG_LEVEL_STRING = "TRACE";
    public static final String LOGGER_NAME = "com.pivotal.gemfirexd";
    public static String clientGfxdLogFile;
    public static final int DEFAULT_MAX_OUT_LINES = 23;
    private static volatile ConcurrentHashMap<Object, Long> sqlIdMap;
    private static volatile ConcurrentHashMap<Object, Long> connIdMap;
    private static final AtomicLong currSeqId;
    private static volatile ConcurrentHashMap<String, String> threadIdMap;
    private static final int MAX_COMPACT_LOG_CACHE_SIZE;
    private static final Object[] compactLogCache;
    private static final AtomicInteger compactLogCacheSize;
    private static final StringBuilder compactLogBuilder;
    private static volatile Thread compactLogShutdownHook;
    static final char[] digits;
    static final ThreadLocal<char[]> longBuffer;

    public static final void ASSERT(boolean mustBeTrue) {
        if (!mustBeTrue) {
            AssertFailure af = new AssertFailure("ASSERT FAILED");
            if (SanityManager.TRACE_ON("AssertFailureTrace")) {
                SanityManager.showTrace(af);
            }
            throw af;
        }
    }

    public static final void ASSERT(boolean mustBeTrue, String msgIfFail) {
        if (!mustBeTrue) {
            AssertFailure af = new AssertFailure("ASSERT FAILED " + msgIfFail);
            if (SanityManager.TRACE_ON("AssertFailureTrace")) {
                SanityManager.showTrace(af);
            }
            throw af;
        }
    }

    public static final void THROWASSERT(String msgIfFail) {
        SanityManager.THROWASSERT(msgIfFail, null);
    }

    public static final void THROWASSERT(String msg, Throwable t) {
        try {
            Class<?> cls = Class.forName("com.pivotal.gemfirexd.internal.engine.store.GemFireStore");
            if (cls != null) {
                msg = msg + "; myID: " + cls.getMethod("getMyId", null).invoke(null, (Object[])null);
            }
        }
        catch (Throwable cls) {
            // empty catch block
        }
        AssertFailure af = new AssertFailure("ASSERT FAILED " + msg, t);
        if (SanityManager.TRACE_ON("AssertFailureTrace")) {
            SanityManager.showTrace(af);
        }
        if (t != null) {
            SanityManager.showTrace(t);
        }
        throw af;
    }

    public static final void THROWASSERT(Throwable t) {
        SanityManager.THROWASSERT(t.toString(), t);
    }

    public static final void DEBUG(String flag, String message) {
        if (flag == null || SanityManager.DEBUG_ON(flag)) {
            SanityManager.DEBUG_PRINT(flag, message);
        }
    }

    public static final boolean DEBUG_ON(String flag) {
        if (AllDebugOn) {
            return true;
        }
        if (AllDebugOff) {
            return false;
        }
        Boolean flagValue = (Boolean)DebugFlags.get(flag);
        if (!DEBUGDEBUG.equals(flag) && SanityManager.DEBUG_ON(DEBUGDEBUG)) {
            SanityManager.DEBUG_PRINT(DEBUGDEBUG, "DEBUG_ON: Debug flag " + flag + " = " + flagValue);
        }
        if (flagValue == null) {
            return false;
        }
        return flagValue;
    }

    public static final void TRACE_SET_IF_ABSENT(String flag) {
        if (!DebugFlags.containsKey(flag)) {
            if (!DEBUGDEBUG.equals(flag) && SanityManager.TRACE_ON(DEBUGDEBUG)) {
                SanityManager.DEBUG_PRINT(DEBUGDEBUG, "TRACE_SET_IF_ABSENT: Debug flag " + flag);
            }
            DebugFlags.put(flag, Boolean.TRUE);
        }
    }

    public static final boolean TRACE_ON(String flag) {
        if (AllDebugOn) {
            return true;
        }
        if (AllDebugOff) {
            return false;
        }
        Boolean flagValue = (Boolean)DebugFlags.get(flag);
        if (!DEBUGDEBUG.equals(flag) && SanityManager.TRACE_ON(DEBUGDEBUG)) {
            SanityManager.DEBUG_PRINT(DEBUGDEBUG, "TRACE_ON: Debug flag " + flag + " = " + flagValue);
        }
        return flagValue != null ? flagValue : false;
    }

    public static final boolean TRACE_OFF(String flag) {
        if (AllDebugOn) {
            return false;
        }
        if (AllDebugOff) {
            return true;
        }
        Boolean flagValue = (Boolean)DebugFlags.get(flag);
        if (!DEBUGDEBUG.equals(flag) && SanityManager.TRACE_ON(DEBUGDEBUG)) {
            SanityManager.DEBUG_PRINT(DEBUGDEBUG, "TRACE_OFF: Debug flag " + flag + " = " + flagValue);
        }
        return flagValue != null ? !flagValue.booleanValue() : false;
    }

    public static final void clearFlags(boolean forBoot) {
        if (!forBoot) {
            DebugFlags.clear();
        }
        isFineEnabled = false;
        isFinerEnabled = false;
    }

    private static void initFlags() {
        FlagsInit.init();
    }

    static void initCustomFlags() {
        TraceClientHA = SanityManager.TRACE_ON(TRACE_CLIENT_HA);
        TraceClientConn = SanityManager.TRACE_ON(TRACE_CLIENT_CONN);
        TraceClientStatementMillis = SanityManager.TRACE_ON(TRACE_CLIENT_STMT_MS);
        TraceClientStatement = TraceClientStatementMillis || SanityManager.TRACE_ON(TRACE_CLIENT_STMT);
        TraceClientStatementHA = TraceClientHA || TraceClientStatement;
        TraceMemoryLeak = SanityManager.TRACE_ON(TRACE_MEMORY_LEAK);
        TraceCache = SanityManager.TRACE_ON(TRACE_CACHE);
        TraceSingleHop = SanityManager.TRACE_ON(TRACE_SINGLE_HOP);
        if (TraceClientStatement) {
            sqlIdMap = new ConcurrentHashMap(100);
            connIdMap = new ConcurrentHashMap(100);
            threadIdMap = new ConcurrentHashMap(100);
            Thread hook = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (compactLogCacheSize.get() > 0) {
                        SanityManager.flushCompactCache(false, null);
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(hook);
            compactLogShutdownHook = hook;
        } else {
            sqlIdMap = null;
            connIdMap = null;
            threadIdMap = null;
            Thread hook = compactLogShutdownHook;
            if (hook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(hook);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static String getStackTrace(Throwable t) {
        return SanityManager.getStackTrace(t, new StringBuilder());
    }

    public static String getStackTrace(Throwable t, StringBuilder sb) {
        ClientSharedUtils.getStackTrace((Throwable)t, (StringBuilder)sb, (String)lineSeparator);
        return sb.toString();
    }

    public static StringBuilder formatHeader(String level, String connectionName) {
        StringBuilder sb = new StringBuilder(lineSeparator);
        Thread thread = Thread.currentThread();
        long threadId = ClientSharedUtils.getJdkHelper().getThreadId(thread);
        long millis = System.currentTimeMillis();
        sb.append('[');
        if (level != null) {
            sb.append(level);
        } else {
            sb.append(DEBUG_LEVEL_STRING);
        }
        sb.append(' ');
        ClientSharedUtils.formatDate((long)millis, (StringBuilder)sb);
        sb.append(" GFXD:").append(connectionName).append(" <").append(thread.getName()).append("> tid=0x").append(Long.toHexString(threadId)).append("] ");
        return sb;
    }

    public static StringBuilder formatMessage(String level, String connectionName, String message, Throwable t) {
        StringBuilder sb = SanityManager.formatHeader(level, connectionName);
        sb.append(message);
        if (t != null) {
            sb.append(lineSeparator);
            ClientSharedUtils.getStackTrace((Throwable)t, (StringBuilder)sb, (String)lineSeparator);
        }
        return sb;
    }

    public static void DEBUG_PRINT(String flag, String message, Throwable t) {
        SanityManager.DEBUG_PRINT(flag, message, t, SanityManager.GET_DEBUG_STREAM());
    }

    public static void DEBUG_PRINT(String flag, String message, Throwable t, PrintWriter pw) {
        if (pw == null) {
            pw = SanityManager.GET_DEBUG_STREAM();
        }
        if (compactLogCacheSize.get() > 0) {
            SanityManager.flushCompactCache(false, null);
        }
        if (pw instanceof GfxdHeaderPrintWriter) {
            ((GfxdHeaderPrintWriter)((Object)pw)).put(flag, message, t);
        } else {
            pw.println(SanityManager.formatMessage(null, flag, message, t).toString());
            pw.flush();
        }
    }

    public static void addDebugFlags(String flags, boolean set) {
        if (flags == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(flags, ",");
        while (st.hasMoreTokens()) {
            String flag = st.nextToken();
            if (set) {
                SanityManager.DEBUG_SET(flag, false);
                continue;
            }
            SanityManager.DEBUG_CLEAR(flag, false);
        }
    }

    public static synchronized void SET_DEBUG_STREAM(String gfxdLogFile, PrintWriterFactory pwFact) {
        boolean newStreamCreated = false;
        if (debugStream != DEFAULT_WRITER && clientGfxdLogFile == null) {
            return;
        }
        if (gfxdLogFile.equals(clientGfxdLogFile)) {
            if (debugStream == DEFAULT_WRITER) {
                debugStream = pwFact.newPrintWriter(gfxdLogFile, true);
                newStreamCreated = true;
            }
        } else {
            boolean doAppend = debugStream != DEFAULT_WRITER;
            if (doAppend) {
                try {
                    debugStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            debugStream = pwFact.newPrintWriter(gfxdLogFile, doAppend);
            clientGfxdLogFile = gfxdLogFile;
            newStreamCreated = true;
        }
        if (newStreamCreated) {
            if (debugStream instanceof GfxdHeaderPrintWriter) {
                isFineEnabled = ((GfxdHeaderPrintWriter)((Object)debugStream)).isFineEnabled();
                isFinerEnabled = ((GfxdHeaderPrintWriter)((Object)debugStream)).isFinerEnabled();
            }
            SanityManager.initFlags();
        }
    }

    public static synchronized void SET_DEBUG_STREAM_IFNULL(PrintWriter pw) {
        if (debugStream == DEFAULT_WRITER) {
            debugStream = pw;
            clientGfxdLogFile = null;
            if (debugStream instanceof GfxdHeaderPrintWriter) {
                isFineEnabled = ((GfxdHeaderPrintWriter)((Object)debugStream)).isFineEnabled();
                isFinerEnabled = ((GfxdHeaderPrintWriter)((Object)debugStream)).isFinerEnabled();
            }
            SanityManager.initFlags();
        }
    }

    public static synchronized void CLEAR_DEBUG_STREAM(PrintWriter comparePW) {
        if (comparePW == null || comparePW == debugStream) {
            debugStream = DEFAULT_WRITER;
            clientGfxdLogFile = null;
            isFineEnabled = false;
            isFinerEnabled = false;
        }
    }

    public static final void DEBUG_SET(String flag, boolean refreshCached) {
        if (!DEBUGDEBUG.equals(flag) && SanityManager.TRACE_ON(DEBUGDEBUG)) {
            SanityManager.DEBUG_PRINT(DEBUGDEBUG, "DEBUG_SET: Debug flag " + flag);
        }
        DebugFlags.put(flag, Boolean.TRUE);
        if (refreshCached) {
            PrintWriter debugStream = SanityManager.GET_DEBUG_STREAM();
            if (debugStream instanceof GfxdHeaderPrintWriter) {
                ((GfxdHeaderPrintWriter)((Object)debugStream)).refreshDebugFlag(flag, true);
            }
            SanityManager.initCustomFlags();
        }
    }

    public static final void DEBUG_CLEAR(String flag, boolean refreshCached) {
        if (!DEBUGDEBUG.equals(flag) && SanityManager.TRACE_ON(DEBUGDEBUG)) {
            SanityManager.DEBUG_PRINT(DEBUGDEBUG, "DEBUG_CLEAR: Debug flag " + flag);
        }
        DebugFlags.put(flag, Boolean.FALSE);
        if (refreshCached) {
            PrintWriter debugStream = SanityManager.GET_DEBUG_STREAM();
            if (debugStream instanceof GfxdHeaderPrintWriter) {
                ((GfxdHeaderPrintWriter)((Object)debugStream)).refreshDebugFlag(flag, false);
            }
            SanityManager.initCustomFlags();
        }
    }

    public static void printPagedOutput(PrintStream out, InputStream in, String output, int maxLines, String continuePrompt, boolean noecho) {
        int lineStart = 0;
        int numLines = 0;
        for (int index = 0; index < output.length(); ++index) {
            char c = output.charAt(index);
            if (c != '\n') continue;
            out.println(output.substring(lineStart, index));
            out.flush();
            lineStart = index + 1;
            if (++numLines < maxLines || lineStart >= output.length()) continue;
            out.print(continuePrompt);
            out.flush();
            String chars = ClientSharedUtils.getJdkHelper().readChars(in, noecho);
            out.println();
            if (chars != null && chars.length() > 0 && (chars.charAt(0) == 'q' || chars.charAt(0) == 'Q')) {
                out.flush();
                return;
            }
            numLines = 0;
        }
        if (lineStart < output.length()) {
            out.println(output.substring(lineStart));
        }
        out.flush();
    }

    public static void DEBUG_PRINT_COMPACT_LINE(Object[] line) {
        assert (line.length > 2) : "atleast line should have space for timestamp & threadid";
        assert (line[0] == null) : "first entry should be left out for timestamp";
        assert (line[1] == null) : "second entry should be left out for threadid";
        line[0] = System.currentTimeMillis();
        line[1] = Thread.currentThread().getId();
        SanityManager.logCompactLine(line);
    }

    public static void DEBUG_PRINT_COMPACT(String opId, String opSql, long connId, long nanoTime, boolean isStart, Throwable t) {
        SanityManager.DEBUG_PRINT_COMPACT(opId, opSql, connId, null, nanoTime, isStart, t);
    }

    public static void DEBUG_PRINT_COMPACT(String opId, int sqlId, long connId, ByteBuffer sessionToken, long nanoTime, boolean isStart, Throwable t) {
        SanityManager.DEBUG_PRINT_COMPACT(opId, null, sqlId, connId, sessionToken, nanoTime, isStart, t);
    }

    public static void DEBUG_PRINT_COMPACT(String opId, String opSql, long connId, ByteBuffer sessionToken, long nanoTime, boolean isStart, Throwable t) {
        SanityManager.DEBUG_PRINT_COMPACT(opId, opSql, 0, connId, sessionToken, nanoTime, isStart, t);
    }

    public static void DEBUG_PRINT_COMPACT(String opId, String opSql, int sqlId, long connId, ByteBuffer sessionToken, long nanoTime, boolean isStart, Throwable t) {
        Object sql;
        Thread currentThread = Thread.currentThread();
        String tname = currentThread.getName();
        String tid = Long.toHexString(currentThread.getId());
        ConcurrentHashMap<String, String> threadIds = threadIdMap;
        if (opSql != null) {
            ConcurrentHashMap<Object, Long> opSqlIds = sqlIdMap;
            if (opSqlIds != null) {
                Long id = opSqlIds.get(opSql);
                if (id == null) {
                    id = currSeqId.incrementAndGet();
                    Long oldId = opSqlIds.putIfAbsent(opSql, id);
                    if (oldId != null) {
                        id = oldId;
                    } else {
                        SanityManager.logCompactLine(new Object[]{"SQL", SharedUtils.quoteString(opSql, '\"'), id});
                    }
                }
                sql = id;
            } else {
                sql = opSql;
            }
        } else {
            sql = null;
        }
        if (threadIds != null) {
            if (!threadIds.containsKey(tname)) {
                threadIds.putIfAbsent(tname, tid);
                SanityManager.logCompactLine(new Object[]{"THREAD", tname, tid});
            }
        } else {
            tid = tname + ':' + tid;
        }
        CompactLogLine logLine = isStart && TraceClientStatementMillis ? new CompactLogLine(tid, opId, sql, sqlId, connId, sessionToken, nanoTime, System.currentTimeMillis(), t) : new CompactLogLine(tid, opId, sql, sqlId, connId, sessionToken, nanoTime, -1L, t);
        SanityManager.logCompactLine(logLine);
    }

    public static long getConnectionId(Object conn) {
        if (conn != null) {
            ConcurrentHashMap<Object, Long> connIds = connIdMap;
            if (connIds != null) {
                Long connId = connIds.get(conn);
                if (connId == null) {
                    connId = currSeqId.incrementAndGet();
                    Long oldConnId = connIds.putIfAbsent(conn, connId);
                    if (oldConnId != null) {
                        connId = oldConnId;
                    } else {
                        SanityManager.logCompactLine(new Object[]{"CONN", conn.hashCode(), connId});
                    }
                }
                return connId;
            }
            return conn.hashCode();
        }
        return 0L;
    }

    private static final void logCompactLine(Object line) {
        while (true) {
            int size;
            if ((size = compactLogCacheSize.get()) < MAX_COMPACT_LOG_CACHE_SIZE) {
                if (!compactLogCacheSize.compareAndSet(size, size + 1)) continue;
                SanityManager.compactLogCache[size] = line;
                return;
            }
            if (SanityManager.flushCompactCache(true, line)) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean flushCompactCache(boolean checkSize, Object line) {
        Object[] cache = null;
        boolean doFlush = false;
        Object[] objectArray = compactLogCache;
        synchronized (compactLogCache) {
            int size = compactLogCacheSize.get();
            if (!checkSize || size >= MAX_COMPACT_LOG_CACHE_SIZE) {
                if (line != null) {
                    cache = new Object[size + 1];
                    cache[size] = line;
                } else {
                    cache = new Object[size];
                }
                System.arraycopy(compactLogCache, 0, cache, 0, size);
                if (compactLogCacheSize.compareAndSet(size, 0)) {
                    doFlush = true;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (doFlush && cache != null && cache.length > 0) {
                objectArray = compactLogCache;
                synchronized (compactLogCache) {
                    for (Object l : cache) {
                        if (l instanceof CompactLogLine) {
                            ((CompactLogLine)l).toString(compactLogBuilder);
                        } else if (l instanceof Object[]) {
                            int i;
                            Object[] lineArray = (Object[])l;
                            int z = lineArray.length - 1;
                            block11: for (i = 0; i < z; ++i) {
                                Object o = lineArray[i];
                                switch (i) {
                                    case 0: {
                                        if (o instanceof Long) {
                                            ClientSharedUtils.formatDate((long)((Long)o), (StringBuilder)compactLogBuilder);
                                            continue block11;
                                        }
                                        compactLogBuilder.append(' ');
                                        ClientSharedUtils.objectStringNonRecursive((Object)o, (StringBuilder)compactLogBuilder);
                                        continue block11;
                                    }
                                    case 1: {
                                        if (o instanceof Long) {
                                            compactLogBuilder.append(' ');
                                            SanityManager.longToHexString((Long)o, compactLogBuilder);
                                            continue block11;
                                        }
                                        compactLogBuilder.append(' ');
                                        ClientSharedUtils.objectStringNonRecursive((Object)o, (StringBuilder)compactLogBuilder);
                                        continue block11;
                                    }
                                    default: {
                                        compactLogBuilder.append(' ');
                                        ClientSharedUtils.objectStringNonRecursive((Object)o, (StringBuilder)compactLogBuilder);
                                    }
                                }
                            }
                            if (lineArray[i] instanceof Throwable) {
                                compactLogBuilder.append(" STACK: ");
                                ClientSharedUtils.getStackTrace((Throwable)((Throwable)lineArray[i]), (StringBuilder)compactLogBuilder, (String)lineSeparator);
                            } else {
                                compactLogBuilder.append(' ').append(lineArray[i]);
                            }
                        } else {
                            compactLogBuilder.append(l);
                        }
                        compactLogBuilder.append(lineSeparator);
                    }
                    PrintWriter pw = SanityManager.GET_DEBUG_STREAM();
                    boolean isServer = pw instanceof GfxdHeaderPrintWriter;
                    if (isServer) {
                        ((GfxdHeaderPrintWriter)((Object)pw)).put("TRACE:COMPACT", compactLogBuilder.toString(), null);
                    } else {
                        pw.print(compactLogBuilder.toString());
                        pw.flush();
                    }
                    compactLogBuilder.setLength(0);
                    if (isServer) {
                        compactLogBuilder.append(lineSeparator);
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return true;
                }
            }
            return false;
        }
    }

    static final void longToHexString(long i, StringBuilder output) {
        int shift = 4;
        int charPos = 64;
        int radix = 1 << shift;
        long mask = radix - 1;
        char[] buf = longBuffer.get();
        if (buf == null) {
            buf = new char[64];
            longBuffer.set(buf);
        }
        do {
            buf[--charPos] = digits[(int)(i & mask)];
        } while ((i >>>= shift) != 0L);
        output.append("0x");
        output.append(buf, charPos, 64 - charPos);
    }

    public static final void DEBUG_SET(String flag) {
        SanityManager.DEBUG_SET(flag, true);
    }

    public static final void DEBUG_CLEAR(String flag) {
        SanityManager.DEBUG_CLEAR(flag, true);
    }

    public static final void DEBUG_ALL_ON() {
        AllDebugOn = true;
        AllDebugOff = false;
        PrintWriter debugStream = SanityManager.GET_DEBUG_STREAM();
        if (debugStream instanceof GfxdHeaderPrintWriter) {
            ((GfxdHeaderPrintWriter)((Object)debugStream)).refreshDebugFlag(null, true);
        }
        SanityManager.initCustomFlags();
    }

    public static final void DEBUG_ALL_OFF() {
        AllDebugOff = true;
        AllDebugOn = false;
        PrintWriter debugStream = SanityManager.GET_DEBUG_STREAM();
        if (debugStream instanceof GfxdHeaderPrintWriter) {
            ((GfxdHeaderPrintWriter)((Object)debugStream)).refreshDebugFlag(null, false);
            isFineEnabled = ((GfxdHeaderPrintWriter)((Object)debugStream)).isFineEnabled();
            isFinerEnabled = ((GfxdHeaderPrintWriter)((Object)debugStream)).isFinerEnabled();
        }
        SanityManager.initCustomFlags();
    }

    public static synchronized void SET_DEBUG_STREAM(PrintWriter pw) {
        debugStream = pw;
        clientGfxdLogFile = null;
        if (debugStream instanceof GfxdHeaderPrintWriter) {
            isFineEnabled = ((GfxdHeaderPrintWriter)((Object)debugStream)).isFineEnabled();
            isFinerEnabled = ((GfxdHeaderPrintWriter)((Object)debugStream)).isFinerEnabled();
        }
        SanityManager.initFlags();
    }

    public static PrintWriter GET_DEBUG_STREAM() {
        return debugStream;
    }

    private static void showTrace(AssertFailure af) {
        af.printStackTrace();
        PrintWriter assertStream = SanityManager.GET_DEBUG_STREAM();
        assertStream.println("Assertion trace:");
        af.printStackTrace(assertStream);
        assertStream.flush();
    }

    public static void showTrace(Throwable t) {
        PrintWriter assertStream = SanityManager.GET_DEBUG_STREAM();
        assertStream.println("Exception trace: ");
        t.printStackTrace(assertStream);
    }

    public static void DEBUG_PRINT(String flag, String message) {
        SanityManager.DEBUG_PRINT(flag, message, null);
    }

    public static void NOTREACHED() {
        SanityManager.THROWASSERT("code should not be reached");
    }

    static {
        debugStream = DEFAULT_WRITER = new PrintWriter(System.err);
        TraceClientHA = false;
        TraceClientConn = false;
        TraceClientStatement = false;
        TraceClientStatementMillis = false;
        TraceClientStatementHA = false;
        TraceMemoryLeak = false;
        TraceCache = false;
        TraceSingleHop = false;
        isFineEnabled = false;
        isFinerEnabled = false;
        DebugFlags = ClientSharedUtils.getJdkHelper().newConcurrentMap(16, 4);
        AllDebugOn = false;
        AllDebugOff = false;
        lineSeparator = ClientSharedUtils.lineSeparator;
        currSeqId = new AtomicLong(0L);
        MAX_COMPACT_LOG_CACHE_SIZE = Integer.getInteger("gemfirexd.compact-log-cache-lines", 1000);
        compactLogCache = new Object[MAX_COMPACT_LOG_CACHE_SIZE + 4];
        compactLogCacheSize = new AtomicInteger(0);
        compactLogBuilder = new StringBuilder(MAX_COMPACT_LOG_CACHE_SIZE * 60);
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        longBuffer = new ThreadLocal();
    }

    private static final class CompactLogLine {
        final String tid;
        final String opId;
        final Object sql;
        final int sqlId;
        final long connId;
        final ByteBuffer sessionToken;
        final long nanoTime;
        final long milliTime;
        final Throwable t;

        CompactLogLine(String tid, String opId, Object sql, int sqlId, long connId, ByteBuffer sessionToken, long nanoTime, long milliTime, Throwable t) {
            this.tid = tid;
            this.opId = opId;
            this.sql = sql;
            this.sqlId = sqlId;
            this.connId = connId;
            this.sessionToken = sessionToken;
            this.nanoTime = nanoTime;
            this.milliTime = milliTime;
            this.t = t;
        }

        void toString(StringBuilder sb) {
            sb.append(this.tid).append(' ').append(this.opId).append(' ');
            Object sql = this.sql;
            if (sql != null) {
                Class<?> cls = sql.getClass();
                if (cls == Integer.class) {
                    sb.append((Integer)sql).append(' ');
                } else if (cls == String.class) {
                    sb.append((String)sql).append(' ');
                } else {
                    sb.append(sql.toString()).append(' ');
                }
            } else {
                int sqlId = this.sqlId;
                if (sqlId != 0) {
                    sb.append("ID=").append(sqlId).append(' ');
                }
            }
            sb.append(this.connId);
            if (this.sessionToken != null && this.sessionToken.remaining() > 0) {
                sb.append('@');
                ClientSharedUtils.toHexString((ByteBuffer)this.sessionToken, (StringBuilder)sb);
            }
            sb.append(' ').append(this.nanoTime);
            if (this.milliTime > 0L) {
                sb.append(' ').append(this.milliTime);
            }
            if (this.t != null) {
                sb.append(" STACK: ");
                ClientSharedUtils.getStackTrace((Throwable)this.t, (StringBuilder)sb, (String)lineSeparator);
            }
        }
    }

    public static interface PrintWriterFactory {
        public PrintWriter newPrintWriter(String var1, boolean var2);
    }

    private static final class FlagsInit {
        private FlagsInit() {
        }

        static void init() {
        }

        static {
            SanityManager.addDebugFlags(System.getProperty(SanityManager.DEBUG_FALSE), false);
            SanityManager.addDebugFlags(System.getProperty(SanityManager.DEBUG_TRUE), true);
            SanityManager.initCustomFlags();
        }
    }
}

