/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common.error;

import com.pivotal.gemfirexd.internal.shared.common.error.ExceptionFactory;
import com.pivotal.gemfirexd.internal.shared.common.error.ExceptionUtil;
import com.pivotal.gemfirexd.internal.shared.common.i18n.SQLMessageFormat;
import java.sql.SQLException;

public class DefaultExceptionFactory30
implements ExceptionFactory {
    protected final SQLMessageFormat formatter;

    public DefaultExceptionFactory30(SQLMessageFormat formatter) {
        this.formatter = formatter;
    }

    @Override
    public SQLException getSQLException(String message, String sqlState, int errCode, SQLException next, Throwable t) {
        SQLException sqle = new SQLException(this.getMessage(message, sqlState, errCode), sqlState, errCode);
        if (next != null) {
            sqle.setNextException(next);
        }
        if (t != null) {
            sqle.initCause(t);
        }
        return sqle;
    }

    @Override
    public SQLException getSQLException(String messageId, SQLException next, Throwable t, Object ... args) {
        String message = this.formatter.getCompleteMessage(messageId, args);
        String sqlState = ExceptionUtil.getSQLStateFromIdentifier(messageId);
        int errCode = ExceptionUtil.getSeverityFromIdentifier(messageId);
        return this.getSQLException(message, sqlState, errCode, next, t);
    }

    protected String getMessage(String message, String sqlState, int errCode) {
        if (message.contains("SQLSTATE=")) {
            return message;
        }
        return "(SQLState=" + sqlState + " Severity=" + errCode + ") " + message;
    }
}

