/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common;

import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.AbstractClientResolver;
import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.RoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.SingleHopInformation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class ClientRangeResolver
extends AbstractClientResolver {
    private int typeId;
    private ArrayList rangeValueHolderList;
    protected SortedMap rangeMap;

    public ClientRangeResolver(int type, ArrayList rangeValueHolderList) {
        this.typeId = type;
        this.rangeValueHolderList = rangeValueHolderList;
        this.initRangeMap();
    }

    private void initRangeMap() {
        Iterator itr = this.rangeValueHolderList.iterator();
        this.rangeMap = new TreeMap(new ResolverUtils.GfxdRangeComparator("PARTITION BY RANGE"));
        while (itr.hasNext()) {
            SingleHopInformation.PlainRangeValueHolder prvh = (SingleHopInformation.PlainRangeValueHolder)itr.next();
            Object lowerBound = prvh.getLowerBound();
            Object upperBound = prvh.getUpperBound();
            Integer routingObject = ClientSharedUtils.getJdkHelper().newInteger(prvh.getRoutingVal());
            ResolverUtils.GfxdRange range = new ResolverUtils.GfxdRange(null, lowerBound, upperBound);
            Object[] value = new Object[]{range, routingObject};
            this.rangeMap.put(range, value);
        }
    }

    @Override
    public Object getRoutingObject(RoutingObjectInfo rinfo, SingleHopInformation sinfo, boolean requiresSerializedHash) {
        Object[] routingKey;
        assert (rinfo instanceof ColumnRoutingObjectInfo);
        ColumnRoutingObjectInfo cRInfo = (ColumnRoutingObjectInfo)rinfo;
        Object value = cRInfo.getActualValue();
        if (value != null && (routingKey = (Object[])this.rangeMap.get(new ResolverUtils.GfxdComparableFuzzy((Comparable)value, 0))) != null && routingKey[1] != null) {
            return (Integer)routingKey[1];
        }
        return ClientSharedUtils.getJdkHelper().newInteger(cRInfo.computeHashCode(0, sinfo.getResolverByte(), false));
    }
}

