/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.shared.common;

import com.pivotal.gemfirexd.internal.shared.common.ColumnRoutingObjectInfo;
import com.pivotal.gemfirexd.internal.shared.common.Converter;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.SQLException;

public class CharColumnRoutingObjectInfo
extends ColumnRoutingObjectInfo {
    protected String actualValue;
    protected int maxWidth;

    public CharColumnRoutingObjectInfo() {
    }

    public CharColumnRoutingObjectInfo(int isParameter, Object val, Object resolver) {
        super(isParameter, val, resolver);
    }

    @Override
    public int computeHashCode(int hash, int resolverType, boolean requiresSerializedHash) {
        String val = null;
        if (this.isValueAConstant()) {
            this.actualValue = val = (String)this.value;
        } else {
            val = this.actualValue;
        }
        if (requiresSerializedHash && resolverType == 4 || resolverType == 2) {
            int typeId = this.getTypeFormatId();
            if (this.actualValue != null) {
                int index;
                int strlen = this.actualValue.length();
                char[] data = ResolverUtils.getInternalChars(this.actualValue, strlen);
                for (index = strlen - 1; index >= 0 && data[index] == ' '; --index) {
                }
                hash = ResolverUtils.getComputeHashOfCharArrayData(hash, index + 1, data, typeId);
                if (this.getTypeFormatId() == 78) {
                    while (index + 1 < this.maxWidth) {
                        hash = ResolverUtils.addByteToHash((byte)32, (int)hash);
                        ++index;
                    }
                }
                return hash;
            }
            return ResolverUtils.addByteToBucketHash((byte)0, hash, 78);
        }
        return this.dvdEquivalenthashCode();
    }

    @Override
    public void setActualValue(Object[] parameters, Converter crossConverter) throws SQLException {
        if (!this.isValueAConstant()) {
            this.actualValue = (String)crossConverter.getJavaObjectOfType(1, parameters[(Integer)this.value]);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 78;
    }

    @Override
    public Object getActualValue() {
        if (this.actualValue != null) {
            return this.actualValue;
        }
        if (this.isValueAConstant()) {
            this.actualValue = (String)this.value;
            return this.actualValue;
        }
        return null;
    }

    @Override
    public int dvdEquivalenthashCode() {
        if (this.actualValue != null) {
            int strlen = this.actualValue.length();
            char[] data = ResolverUtils.getInternalChars(this.actualValue, strlen);
            int hash = ResolverUtils.getHashCodeOfCharArrayData(data, this.actualValue, strlen);
            if (this.getTypeFormatId() == 78) {
                int index;
                for (index = data.length - 1; index >= 0 && data[index] == ' '; --index) {
                }
                while (index + 1 < this.maxWidth) {
                    hash = ResolverUtils.addByteToHash((byte)32, (int)hash);
                    ++index;
                }
            }
            return hash;
        }
        return 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.maxWidth);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.maxWidth = in.readInt();
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public static void dummy() {
    }
}

