/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.hibernate;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.hibernate.MappingException;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DerbyCaseFragment;

public abstract class GemFireXDDialectBase
extends DB2Dialect {
    protected Logger LOG = Logger.getLogger("GemFireXDDialect");
    protected boolean identityColumnStringIsAlways = true;
    protected static final Set<String> SQL_GRAMMAR_CATEGORIES = GemFireXDDialectBase.buildGrammarCategories();
    protected static final Set<String> DATA_CATEGORIES = GemFireXDDialectBase.buildDataCategories();
    protected static final Set<String> LOCK_ACQUISITION_CATEGORIES = GemFireXDDialectBase.buildLockAcquisitionCategories();

    protected GemFireXDDialectBase() {
        String identityColumnStr = System.getenv("GFXD_GENERATE_IDENTITY");
        if (identityColumnStr != null && identityColumnStr.equalsIgnoreCase("BYDEFAULT")) {
            this.identityColumnStringIsAlways = false;
        }
    }

    public CaseFragment createCaseFragment() {
        return new DerbyCaseFragment();
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean supportsSequences() {
        return false;
    }

    public String getSequenceNextValString(String sequenceName) throws MappingException {
        throw new MappingException("Gemfirexd Dialect does not support sequences");
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public String getForUpdateString() {
        return " for update";
    }

    public String getLimitString(String query, int offset, int limit) {
        int withPosition = query.lastIndexOf("with ");
        if (withPosition < 0) {
            withPosition = query.lastIndexOf("WITH ");
        }
        String normalizedSelect = query.toLowerCase().trim();
        int forUpdatePosition = normalizedSelect.lastIndexOf("for update");
        StringBuilder sb = new StringBuilder(query.length() + 50);
        if (forUpdatePosition >= 0) {
            sb.append(query.substring(0, forUpdatePosition - 1));
        } else if (normalizedSelect.startsWith("with ", normalizedSelect.length() - 7)) {
            sb.append(query.substring(0, withPosition - 1));
        } else {
            sb.append(query);
        }
        if (offset == 0) {
            sb.append(" fetch first ");
        } else {
            sb.append(" offset ").append(offset).append(" rows fetch next ");
        }
        sb.append(limit).append(" rows only");
        if (forUpdatePosition >= 0) {
            sb.append(' ');
            sb.append(query.substring(forUpdatePosition));
        } else if (normalizedSelect.startsWith("with ", normalizedSelect.length() - 7)) {
            sb.append(' ').append(query.substring(withPosition));
        }
        return sb.toString();
    }

    public String getQuerySequencesString() {
        return null;
    }

    public String getTableComment(String comment) {
        return comment;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public String getIdentityColumnString() {
        if (this.identityColumnStringIsAlways) {
            return "generated always as identity";
        }
        return "generated by default as identity";
    }

    protected static Set<String> buildGrammarCategories() {
        HashSet<String> categories = new HashSet<String>();
        categories.addAll(Arrays.asList("X0Y91", "X0Y92", "X0Y93", "X0Y94", "X0Y95", "X0Y96", "X0Y97", "X0Y99", "X0Z11", "X0Z12", "X0Z13", "X0Z15", "X0Z17"));
        return Collections.unmodifiableSet(categories);
    }

    protected static Set<String> buildDataCategories() {
        HashSet<String> categories = new HashSet<String>();
        categories.addAll(Arrays.asList("X0Y98", "X0Z01", "X0Z04", "X0Z05", "X0Z08", "X0Z09", "X0Z18"));
        return Collections.unmodifiableSet(categories);
    }

    protected static Set<String> buildLockAcquisitionCategories() {
        HashSet<String> categories = new HashSet<String>();
        categories.add("X0Z02");
        return Collections.unmodifiableSet(categories);
    }
}

