/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.hibernate;

import com.pivotal.gemfirexd.hibernate.GemFireXDDialectBase;
import java.sql.SQLException;
import org.hibernate.JDBCException;
import org.hibernate.dialect.function.AnsiTrimFunction;
import org.hibernate.dialect.function.DerbyConcatFunction;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.NvlFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.exception.DataException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class GemFireXDDialect
extends GemFireXDDialectBase {
    public GemFireXDDialect() {
        this.LOG.info("GemFireXDDialect for Hibernate 4 initialized.");
        this.registerFunction("concat", (SQLFunction)new DerbyConcatFunction());
        this.registerFunction("trim", (SQLFunction)new AnsiTrimFunction());
        this.registerFunction("value", (SQLFunction)new StandardSQLFunction("coalesce"));
        this.registerFunction("nvl", (SQLFunction)new NvlFunction());
        this.registerFunction("groups", (SQLFunction)new StandardSQLFunction("GROUPS", (Type)StandardBasicTypes.STRING));
        this.registerFunction("dsid", (SQLFunction)new StandardSQLFunction("DSID", (Type)StandardBasicTypes.STRING));
        this.registerFunction("groupsintersection", (SQLFunction)new StandardSQLFunction("GROUPSINTERSECTION", (Type)StandardBasicTypes.STRING));
        this.registerFunction("groupsintersect", (SQLFunction)new StandardSQLFunction("GROUPSINTERSECT", (Type)StandardBasicTypes.BOOLEAN));
        this.registerFunction("groupsunion", (SQLFunction)new StandardSQLFunction("GROUPSUNION", (Type)StandardBasicTypes.STRING));
        this.registerFunction("longint", (SQLFunction)new StandardSQLFunction("bigint", (Type)StandardBasicTypes.LONG));
        this.registerFunction("int", (SQLFunction)new StandardSQLFunction("integer", (Type)StandardBasicTypes.INTEGER));
        this.registerFunction("pi", (SQLFunction)new StandardSQLFunction("pi", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("random", (SQLFunction)new NoArgSQLFunction("random", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("rand", (SQLFunction)new StandardSQLFunction("rand", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("sinh", (SQLFunction)new StandardSQLFunction("sinh", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("cosh", (SQLFunction)new StandardSQLFunction("cosh", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("tanh", (SQLFunction)new StandardSQLFunction("tanh", (Type)StandardBasicTypes.DOUBLE));
        this.registerFunction("user", (SQLFunction)new NoArgSQLFunction("USER", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("current_user", (SQLFunction)new NoArgSQLFunction("CURRENT_USER", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("session_user", (SQLFunction)new NoArgSQLFunction("SESSION_USER", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("current isolation", (SQLFunction)new NoArgSQLFunction("CURRENT ISOLATION", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("current_role", (SQLFunction)new NoArgSQLFunction("CURRENT_ROLE", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("current schema", (SQLFunction)new NoArgSQLFunction("CURRENT SCHEMA", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("current sqlid", (SQLFunction)new NoArgSQLFunction("CURRENT SQLID", (Type)StandardBasicTypes.STRING, false));
        this.registerFunction("xmlexists", (SQLFunction)new StandardSQLFunction("XMLEXISTS", (Type)StandardBasicTypes.NUMERIC_BOOLEAN));
        this.registerFunction("xmlparse", (SQLFunction)new StandardSQLFunction("XMLPARSE", (Type)StandardBasicTypes.TEXT));
        this.registerFunction("xmlquery", (SQLFunction)new StandardSQLFunction("XMLQUERY", (Type)StandardBasicTypes.STRING));
        this.registerFunction("xmlserialize", (SQLFunction)new StandardSQLFunction("XMLSERIALIZE", (Type)StandardBasicTypes.STRING));
        this.registerFunction("get_current_connection", (SQLFunction)new NoArgSQLFunction("GET_CURRENT_CONNECTION", (Type)StandardBasicTypes.BINARY, true));
        this.registerFunction("identity_val_local", (SQLFunction)new NoArgSQLFunction("IDENTITY_VAL_LOCAL", (Type)StandardBasicTypes.BINARY, true));
    }

    public boolean supportsPooledSequences() {
        return false;
    }

    public boolean supportsUnboundedLobLocatorMaterialization() {
        return false;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return false;
    }

    public String getWriteLockString(int timeout) {
        return " for update";
    }

    public String getReadLockString(int timeout) {
        return " for update";
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return new SQLExceptionConversionDelegate(){

            public JDBCException convert(SQLException sqlException, String message, String sql) {
                String sqlState = JdbcExceptionHelper.extractSqlState((SQLException)sqlException);
                if (sqlState != null) {
                    if (GemFireXDDialectBase.SQL_GRAMMAR_CATEGORIES.contains(sqlState)) {
                        return new SQLGrammarException(message, sqlException, sql);
                    }
                    if (GemFireXDDialectBase.DATA_CATEGORIES.contains(sqlState)) {
                        return new DataException(message, sqlException, sql);
                    }
                    if (GemFireXDDialectBase.LOCK_ACQUISITION_CATEGORIES.contains(sqlState)) {
                        return new LockAcquisitionException(message, sqlException, sql);
                    }
                }
                return null;
            }
        };
    }
}

