/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.jdbc;

import com.pivotal.gemfirexd.internal.jdbc.EmbedPooledConnection;
import com.pivotal.gemfirexd.internal.jdbc.ReferenceableDataSource;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

class EmbedPooledConnection40
extends EmbedPooledConnection {
    private final CopyOnWriteArrayList<StatementEventListener> statementEventListeners = new CopyOnWriteArrayList();

    EmbedPooledConnection40(ReferenceableDataSource ds, String user, String password, boolean requestPassword) throws SQLException {
        super(ds, user, password, requestPassword);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (listener == null) {
            return;
        }
        this.statementEventListeners.remove(listener);
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (!this.isActive) {
            return;
        }
        if (listener == null) {
            return;
        }
        this.statementEventListeners.add(listener);
    }

    @Override
    public void onStatementClose(PreparedStatement statement) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement);
            for (StatementEventListener l : this.statementEventListeners) {
                l.statementClosed(event);
            }
        }
    }

    @Override
    public void onStatementErrorOccurred(PreparedStatement statement, SQLException sqle) {
        if (!this.statementEventListeners.isEmpty()) {
            StatementEvent event = new StatementEvent(this, statement, sqle);
            for (StatementEventListener l : this.statementEventListeners) {
                l.statementErrorOccurred(event);
            }
        }
    }
}

