/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Loggable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.PageKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RePreparable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.RawContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class PageBasicOperation
implements Loggable,
RePreparable {
    private PageKey pageId;
    private long pageVersion;
    protected transient BasePage page;
    protected transient RawContainerHandle containerHdl;
    protected transient boolean foundHere;

    protected PageBasicOperation(BasePage page) {
        SanityManager.ASSERT((page != null ? 1 : 0) != 0, (String)"cannot create page operation on a null page pointer");
        this.page = page;
        this.pageId = page.getPageId();
        this.pageVersion = page.getPageVersion();
    }

    public PageBasicOperation() {
    }

    public String toString() {
        return "Page Operation: " + this.pageId.toString() + " pageVersion " + this.pageVersion + " : ";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.pageId.writeExternal(out);
        CompressedNumber.writeLong(out, this.pageVersion);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.pageId = PageKey.read(in);
        this.pageVersion = CompressedNumber.readLong(in);
    }

    @Override
    public final boolean needsRedo(Transaction xact) throws StandardException {
        if (this.findpage(xact) == null) {
            return false;
        }
        long pversion = this.page.getPageVersion();
        if (pversion == this.pageVersion) {
            return true;
        }
        this.releaseResource(xact);
        if (pversion > this.pageVersion) {
            return false;
        }
        throw StandardException.newException("XSDB4.D", (Object)this.pageId, (Object)new Long(pversion), (Object)new Long(this.pageVersion));
    }

    @Override
    public void releaseResource(Transaction xact) {
        if (!this.foundHere) {
            return;
        }
        if (this.page != null) {
            this.page.unlatch();
            this.page = null;
        }
        if (this.containerHdl != null) {
            this.containerHdl.close();
            this.containerHdl = null;
        }
        this.foundHere = false;
    }

    @Override
    public int group() {
        return 384;
    }

    @Override
    public ByteArray getPreparedLog() throws StandardException {
        return null;
    }

    @Override
    public void reclaimPrepareLocks(Transaction t, LockingPolicy locking_policy) throws StandardException {
        SanityManager.DEBUG_PRINT((String)"", (String)"PageBasicOperation.reclaimPrepareLocks().");
    }

    protected final void resetPageNumber(long pageNumber) {
        this.pageId = new PageKey(this.pageId.getContainerId(), pageNumber);
    }

    protected final PageKey getPageId() {
        return this.pageId;
    }

    public final BasePage findpage(Transaction xact) throws StandardException {
        this.releaseResource(xact);
        RawTransaction rtran = (RawTransaction)xact;
        this.containerHdl = rtran.openDroppedContainer(this.pageId.getContainerId(), null);
        if (this.containerHdl == null) {
            throw StandardException.newException("40XD2", this.pageId.getContainerId());
        }
        this.foundHere = true;
        if (this.containerHdl.getContainerStatus() == 4) {
            this.releaseResource(xact);
            return null;
        }
        StandardException getPageException = null;
        try {
            this.page = (BasePage)this.containerHdl.getAnyPage(this.pageId.getPageNumber());
        }
        catch (StandardException se) {
            getPageException = se;
        }
        if (this.page == null && getPageException != null && this.pageVersion == 0L && PropertyUtil.getSystemBoolean("gemfirexd.storage.patchInitPageRecoverError")) {
            this.page = this.getPageForRedoRecovery(xact);
        }
        if (this.page == null && getPageException != null && rtran.inRollForwardRecovery()) {
            if (SanityManager.DEBUG_ON((String)"LoadTran")) {
                SanityManager.DEBUG_PRINT((String)"Trace", (String)("got null page " + this.pageId + " and getPageException, attempt last ditch effort"));
            }
            this.page = this.getPageForRedoRecovery(xact);
            if (SanityManager.DEBUG_ON((String)"LoadTran")) {
                SanityManager.DEBUG_PRINT((String)"Trace", (String)(" getPageForRedoRecovery, got page=" + (this.page != null)));
            }
        }
        if (this.page == null) {
            if (getPageException != null) {
                throw getPageException;
            }
            throw StandardException.newException("XSDB5.D", this.pageId);
        }
        return this.page;
    }

    protected BasePage getPageForRedoRecovery(Transaction xact) throws StandardException {
        return null;
    }

    public final Page getPage() {
        return this.page;
    }

    public final long getPageVersion() {
        return this.pageVersion;
    }

    public abstract void restoreMe(Transaction var1, BasePage var2, LogInstant var3, LimitObjectInput var4) throws StandardException, IOException;
}

