/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.sort;

import com.pivotal.gemfirexd.internal.impl.store.access.sort.Node;

final class NodeAllocator {
    private static final int DEFAULT_INIT_SIZE = 128;
    private static final int GROWTH_MULTIPLIER = 2;
    private static final int DEFAULT_MAX_SIZE = 1024;
    private Node[] array = null;
    private int maxSize = 0;
    private int nAllocated = 0;
    private Node freeList = null;

    public Node newNode() {
        if (this.array == null && !this.init()) {
            return null;
        }
        if (this.freeList != null) {
            Node n = this.freeList;
            this.freeList = n.rightLink;
            n.rightLink = null;
            return n;
        }
        if (this.nAllocated == this.array.length) {
            if (this.array.length >= this.maxSize) {
                return null;
            }
            Node[] newArray = new Node[this.array.length * 2];
            if (newArray == null) {
                return null;
            }
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
        if (this.array[this.nAllocated] == null) {
            this.array[this.nAllocated] = new Node(this.nAllocated);
        }
        return this.array[this.nAllocated++];
    }

    public void freeNode(Node n) {
        n.reset();
        n.rightLink = this.freeList;
        this.freeList = n;
    }

    public boolean init() {
        return this.init(128, 1024);
    }

    public boolean init(int maxSize) {
        return this.init(128, maxSize);
    }

    public boolean init(int initSize, int maxSize) {
        this.maxSize = maxSize;
        if (maxSize < initSize) {
            initSize = maxSize;
        }
        this.array = new Node[initSize];
        if (this.array == null) {
            return false;
        }
        this.nAllocated = 0;
        return true;
    }

    public void grow(int percent) {
        if (percent > 0) {
            this.maxSize *= (100 + percent) / 100;
        }
    }

    public void reset() {
        if (this.array == null) {
            return;
        }
        for (int i = 0; i < this.nAllocated; ++i) {
            this.array[i].reset();
        }
        this.nAllocated = 0;
        this.freeList = null;
    }

    public void close() {
        this.array = null;
        this.nAllocated = 0;
        this.maxSize = 0;
        this.freeList = null;
    }

    public int capacity() {
        return this.maxSize;
    }
}

