/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute.rts;

import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableProperties;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import com.pivotal.gemfirexd.internal.impl.sql.execute.rts.ResultSetStatistics;
import java.util.Enumeration;
import java.util.Properties;

public class RealHashTableStatistics
extends RealNoPutResultSetStatistics {
    public int hashtableSize;
    public int[] hashKeyColumns;
    public String isolationLevel;
    public String nextQualifiers;
    public FormatableProperties scanProperties;
    public ResultSetStatistics childResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RealHashTableStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int hashtableSize, int[] hashKeyColumns, String nextQualifiers, Properties scanProperties, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics[] subqueryTrackingArray, ResultSetStatistics childResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.hashtableSize = hashtableSize;
        this.hashKeyColumns = hashKeyColumns;
        this.nextQualifiers = nextQualifiers;
        this.scanProperties = new FormatableProperties();
        if (scanProperties != null) {
            Enumeration<Object> e = scanProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.scanProperties.put(key, scanProperties.get(key));
            }
        }
        this.subqueryTrackingArray = subqueryTrackingArray;
        this.childResultSetStatistics = childResultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        String hashKeyColumnString;
        int index;
        String subqueryInfo = "";
        this.initFormatInfo(depth);
        if (this.subqueryTrackingArray != null) {
            boolean foundAttached = false;
            for (index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                if (!foundAttached) {
                    subqueryInfo = this.indent + MessageService.getTextMessage("43X56.U") + ":\n";
                    foundAttached = true;
                }
                subqueryInfo = subqueryInfo + this.subqueryTrackingArray[index].getStatementExecutionPlanText(this.sourceDepth);
            }
        }
        this.initFormatInfo(depth);
        if (this.hashKeyColumns.length == 1) {
            hashKeyColumnString = MessageService.getTextMessage("43X53.U") + " " + this.hashKeyColumns[0];
        } else {
            hashKeyColumnString = MessageService.getTextMessage("43X54.U") + " (" + this.hashKeyColumns[0];
            for (index = 1; index < this.hashKeyColumns.length; ++index) {
                hashKeyColumnString = hashKeyColumnString + "," + this.hashKeyColumns[index];
            }
            hashKeyColumnString = hashKeyColumnString + ")";
        }
        return this.indent + MessageService.getTextMessage("43X57.U") + " (" + this.resultSetNumber + "):\n" + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X31.U") + " = " + this.hashtableSize + "\n" + this.indent + hashKeyColumnString + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U") + " = " + this.rowsFiltered + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U") + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + this.subIndent + MessageService.getTextMessage("43X37.U") + ":\n" + this.nextQualifiers + "\n" + this.indent + MessageService.getTextMessage("43X05.U") + ":\n" + this.childResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth);
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null) {
            return this.getStatementExecutionPlanText(depth);
        }
        return null;
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeOn() {
        return "";
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X58.U");
    }
}

