/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

public class OnceResultSet
extends NoPutResultSetImpl {
    public static final int DO_CARDINALITY_CHECK = 1;
    public static final int NO_CARDINALITY_CHECK = 2;
    public static final int UNIQUE_CARDINALITY_CHECK = 3;
    private ExecRow rowWithNulls;
    private StatementContext statementContext;
    public NoPutResultSet source;
    private GeneratedMethod emptyRowFun;
    private int cardinalityCheck;
    public int subqueryNumber;
    public int pointOfAttachment;

    public OnceResultSet(NoPutResultSet s, Activation a, GeneratedMethod emptyRowFun, int cardinalityCheck, int resultSetNumber, int subqueryNumber, int pointOfAttachment, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        this.emptyRowFun = emptyRowFun;
        this.cardinalityCheck = cardinalityCheck;
        this.subqueryNumber = subqueryNumber;
        this.pointOfAttachment = pointOfAttachment;
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        if (this.isOpen) {
            this.reopenCore();
            return;
        }
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.isOpen = true;
        this.source.openCore();
        if (this.statementContext == null) {
            this.statementContext = this.getLanguageConnectionContext().getStatementContext();
        }
        this.statementContext.setSubqueryResultSet(this.subqueryNumber, this, this.activation.getNumSubqueries());
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"OnceResultSet already open");
        this.source.reopenCore();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow candidateRow = null;
        ExecRow secondRow = null;
        ExecRow result = null;
        boolean isOffHeapEnabled = GemFireXDUtils.isOffHeapEnabled();
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"OpenResultSet not open");
        if (this.isOpen) {
            candidateRow = this.source.getNextRowCore();
            if (candidateRow != null) {
                switch (this.cardinalityCheck) {
                    case 1: 
                    case 2: {
                        candidateRow = candidateRow.getClone();
                        if (this.cardinalityCheck == 1) {
                            if (isOffHeapEnabled) {
                                this.source.releasePreviousByteSource();
                            }
                            if ((secondRow = this.source.getNextRowCore()) != null) {
                                this.close(false);
                                StandardException se = StandardException.newException("21000");
                                throw se;
                            }
                        }
                        result = candidateRow;
                        break;
                    }
                    case 3: {
                        candidateRow = candidateRow.getClone();
                        secondRow = this.source.getNextRowCore();
                        DataValueDescriptor orderable1 = candidateRow.getColumn(1);
                        while (secondRow != null) {
                            DataValueDescriptor orderable2 = secondRow.getColumn(1);
                            if (!orderable1.compare(2, orderable2, true, true)) {
                                this.close(false);
                                StandardException se = StandardException.newException("21000");
                                throw se;
                            }
                            if (isOffHeapEnabled) {
                                this.source.releasePreviousByteSource();
                            }
                            secondRow = this.source.getNextRowCore();
                        }
                        result = candidateRow;
                        break;
                    }
                    default: {
                        SanityManager.THROWASSERT((String)("cardinalityCheck not unexpected to be " + this.cardinalityCheck));
                        break;
                    }
                }
            } else {
                result = this.rowWithNulls == null ? (this.rowWithNulls = (ExecRow)this.emptyRowFun.invoke(this.activation)) : this.rowWithNulls;
            }
        }
        this.setCurrentRow(result);
        ++this.rowsSeen;
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close(cleanupOnError);
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of OnceResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public int getPointOfAttachment() {
        return this.pointOfAttachment;
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "ONCE");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }
}

