/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLSingleTableConstantAction;

public class DropTriggerConstantAction
extends DDLSingleTableConstantAction {
    private final String triggerName;
    private final SchemaDescriptor sd;
    private boolean onlyIfExists;
    private TableDescriptor td;

    DropTriggerConstantAction(SchemaDescriptor sd, String triggerName, UUID tableId, boolean onlyIfExists) {
        super(tableId);
        this.sd = sd;
        this.triggerName = triggerName;
        this.onlyIfExists = onlyIfExists;
        if (!onlyIfExists) {
            SanityManager.ASSERT((sd != null ? 1 : 0) != 0, (String)"SchemaDescriptor is null");
        }
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        dd.startWriting(lcc);
        if (this.tableId == null && this.onlyIfExists) {
            this.invalidatePreparedStatement(activation, 27);
            return;
        }
        this.td = dd.getTableDescriptor(this.tableId);
        if (this.td == null) {
            throw StandardException.newException("X0X05.S", this.tableId.toString());
        }
        lcc.verifyNoOpenResultSets(null, this.td, 27);
        TransactionController tc = lcc.getTransactionExecute();
        this.lockTableForDDL(tc, this.td.getHeapConglomerateId(), true);
        this.td = dd.getTableDescriptor(this.tableId);
        if (this.td == null) {
            throw StandardException.newException("X0X05.S", this.tableId.toString());
        }
        TriggerDescriptor triggerd = dd.getTriggerDescriptor(this.triggerName, this.sd);
        if (triggerd == null) {
            throw StandardException.newException("X0X81.S", (Object)"TRIGGER", (Object)(this.sd.getSchemaName() + "." + this.triggerName));
        }
        triggerd.drop(lcc);
        GfxdIndexManager indexManager = GfxdIndexManager.getGfxdIndexManager(this.td, lcc);
        indexManager.removeTriggerExecutor(triggerd, lcc);
    }

    public String toString() {
        return "DROP TRIGGER " + this.triggerName;
    }

    @Override
    public final String getSchemaName() {
        return this.td == null ? null : this.td.getSchemaName();
    }

    @Override
    public final String getTableName() {
        return this.td == null ? null : this.td.getName();
    }

    @Override
    public final boolean isDropStatement() {
        return true;
    }

    @Override
    public final String getObjectName() {
        return this.triggerName;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    @Override
    public boolean isDropIfExists() {
        return this.onlyIfExists;
    }
}

