/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

public class AnyResultSet
extends NoPutResultSetImpl {
    private ExecRow rowWithNulls;
    private StatementContext statementContext;
    public final NoPutResultSet source;
    private GeneratedMethod emptyRowFun;
    public int subqueryNumber;
    public int pointOfAttachment;

    public AnyResultSet(NoPutResultSet s, Activation a, GeneratedMethod emptyRowFun, int resultSetNumber, int subqueryNumber, int pointOfAttachment, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        this.emptyRowFun = emptyRowFun;
        this.subqueryNumber = subqueryNumber;
        this.pointOfAttachment = pointOfAttachment;
        this.initLocalTXState();
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        if (this.isOpen) {
            this.reopenCore();
            return;
        }
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        this.isOpen = true;
        this.source.openCore();
        if (this.statementContext == null) {
            this.statementContext = this.getLanguageConnectionContext().getStatementContext();
        }
        this.statementContext.setSubqueryResultSet(this.subqueryNumber, this, this.activation.getNumSubqueries());
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"AnyResultSet already open");
        this.source.reopenCore();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow candidateRow = null;
        Object secondRow = null;
        ExecRow result = null;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"AnyResultSet not open");
        if (this.isOpen) {
            if (this.rowsSeen > 0) {
                this.source.releasePreviousByteSource();
            }
            result = (candidateRow = this.source.getNextRowCore()) != null ? candidateRow : (this.rowWithNulls == null ? (this.rowWithNulls = (ExecRow)this.emptyRowFun.invoke(this.activation)) : this.rowWithNulls);
        }
        this.setCurrentRow(result);
        if (this.localTXState != null && this.isTopResultSet && result != null && this.isForUpdate()) {
            this.updateRowLocationPostRead();
        }
        ++this.rowsSeen;
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close(cleanupOnError);
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of AnyResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public int getPointOfAttachment() {
        return this.pointOfAttachment;
    }

    @Override
    public long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.source.updateRowLocationPostRead();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        this.source.filteredRowLocationPostRead(localTXState);
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return this.source.supportsMoveToNextKey();
    }

    @Override
    public int getScanKeyGroupID() {
        return this.source.getScanKeyGroupID();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(1);
        visitor.visit(this);
        this.source.accept(visitor);
    }

    @Override
    public void resetStatistics() {
        SanityManager.ASSERT((boolean)this.isClosed());
        this.source.resetStatistics();
        super.resetStatistics();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "ANY");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }
}

