/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.GroupByQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableArrayHolder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.LanguageFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.AccessPath;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectNodesVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MaxMinAggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ReplaceAggregatesWithCRVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubstituteExpressionVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfoList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class GroupByNode
extends SingleChildResultSetNode {
    GroupByList groupingList;
    Vector aggregateVector;
    private AggregatorInfoList aggInfo;
    FromTable parent;
    private boolean addDistinctAggregate;
    private boolean singleInputRowOptimization;
    private int addDistinctAggregateColumnNum;
    private boolean isInSortedOrder;
    private ValueNode havingClause;
    private SubqueryList havingSubquerys;

    @Override
    public void init(Object bottomPR, Object groupingList, Object aggregateVector, Object havingClause, Object havingSubquerys, Object tableProperties, Object nestingLevel) throws StandardException {
        super.init(bottomPR, tableProperties);
        this.setLevel((Integer)nestingLevel);
        this.havingClause = (ValueNode)havingClause;
        this.havingSubquerys = (SubqueryList)havingSubquerys;
        if (!(this.childResult instanceof Optimizable)) {
            SanityManager.THROWASSERT((String)("childResult, " + this.childResult.getClass().getName() + ", expected to be instanceof Optimizable"));
        }
        if (!(this.childResult instanceof FromTable)) {
            SanityManager.THROWASSERT((String)("childResult, " + this.childResult.getClass().getName() + ", expected to be instanceof FromTable"));
        }
        this.groupingList = (GroupByList)groupingList;
        this.aggregateVector = (Vector)aggregateVector;
        this.parent = this;
        ResultColumnList newBottomRCL = this.childResult.getResultColumns().copyListAndObjects();
        this.resultColumns = this.childResult.getResultColumns();
        this.childResult.setResultColumns(newBottomRCL);
        this.addAggregates();
        if (!this.addDistinctAggregate && groupingList != null) {
            int index;
            ColumnReference[] crs = new ColumnReference[this.groupingList.size()];
            int glSize = this.groupingList.size();
            for (index = 0; index < glSize; ++index) {
                GroupByColumn gc = (GroupByColumn)this.groupingList.elementAt(index);
                if (!(gc.getColumnExpression() instanceof ColumnReference)) {
                    this.isInSortedOrder = false;
                    break;
                }
                crs[index] = (ColumnReference)gc.getColumnExpression();
            }
            if (index == glSize) {
                this.isInSortedOrder = this.childResult.isOrderedOn(crs, true, null);
            }
        }
        if (this.isInSortedOrder && !this.aggInfo.hasDistinct() && !this.aggInfo.hasExpressionInAggregate()) {
            ((ProjectRestrictNode)this.childResult).markChildOptimized();
        }
    }

    boolean getIsInSortedOrder() {
        return this.isInSortedOrder;
    }

    private void addAggregates() throws StandardException {
        this.addNewPRNode();
        this.addNewColumnsForAggregation();
        this.addDistinctAggregatesToOrderBy();
    }

    private void addDistinctAggregatesToOrderBy() {
        int numDistinct = GroupByNode.numDistinctAggregates(this.aggregateVector);
        if (numDistinct != 0) {
            SanityManager.ASSERT((numDistinct == 1 ? 1 : 0) != 0, (String)"Should not have more than 1 distinct aggregate per Group By node");
            AggregatorInfo agg = null;
            int count = this.aggInfo.size();
            for (int i = 0; i < count && !(agg = (AggregatorInfo)this.aggInfo.elementAt(i)).isDistinct(); ++i) {
            }
            SanityManager.ASSERT((agg != null && agg.isDistinct() ? 1 : 0) != 0);
            this.addDistinctAggregate = true;
            this.addDistinctAggregateColumnNum = agg.getInputColNum();
        }
    }

    private void addNewPRNode() throws StandardException {
        ResultColumnList rclNew = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int sz = this.resultColumns.size();
        for (int i = 0; i < sz; ++i) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(i);
            if (!rc.isGenerated()) {
                rclNew.addElement(rc);
                continue;
            }
            if (this.getCompilerContext().createQueryInfo() || this.getCompilerContext().allTablesAreReplicatedOnRemote()) continue;
            rclNew.addElement(rc);
            rc.unmarkGenerated();
        }
        rclNew.copyOrderBySelect(this.resultColumns);
        this.parent = (FromTable)this.getNodeFactory().getNode(151, this, rclNew, null, null, null, this.havingSubquerys, this.tableProperties, this.getContextManager());
        this.childResult.setResultColumns((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()));
        this.resultColumns = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
    }

    private ArrayList addUnAggColumns() throws StandardException {
        ResultColumnList bottomRCL = this.childResult.getResultColumns();
        ResultColumnList groupByRCL = this.resultColumns;
        ArrayList<SubstituteExpressionVisitor> referencesToSubstitute = new ArrayList<SubstituteExpressionVisitor>();
        ArrayList<SubstituteExpressionVisitor> havingRefsToSubstitute = null;
        if (this.havingClause != null) {
            havingRefsToSubstitute = new ArrayList<SubstituteExpressionVisitor>();
        }
        int sz = this.groupingList.size();
        for (int i = 0; i < sz; ++i) {
            GroupByColumn gbc = (GroupByColumn)this.groupingList.elementAt(i);
            ResultColumn newRC = (ResultColumn)this.getNodeFactory().getNode(80, "##UnaggColumn", gbc.getColumnExpression(), this.getContextManager());
            bottomRCL.addElement(newRC);
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            newRC.setVirtualColumnId(bottomRCL.size());
            ResultColumn gbRC = (ResultColumn)this.getNodeFactory().getNode(80, "##UnaggColumn", gbc.getColumnExpression(), this.getContextManager());
            groupByRCL.addElement(gbRC);
            gbRC.markGenerated();
            gbRC.bindResultColumnToExpression();
            gbRC.setVirtualColumnId(groupByRCL.size());
            VirtualColumnNode vc = (VirtualColumnNode)this.getNodeFactory().getNode(107, this, gbRC, groupByRCL.size(), this.getContextManager());
            ValueNode vn = gbc.getColumnExpression();
            SubstituteExpressionVisitor vis = new SubstituteExpressionVisitor(vn, vc, AggregateNode.class);
            referencesToSubstitute.add(vis);
            if (this.havingClause != null) {
                SubstituteExpressionVisitor havingSE = new SubstituteExpressionVisitor(vn, vc, null);
                havingRefsToSubstitute.add(havingSE);
            }
            gbc.setColumnPosition(bottomRCL.size());
        }
        ExpressionSorter sorter = new ExpressionSorter();
        Collections.sort(referencesToSubstitute, sorter);
        for (int r = 0; r < referencesToSubstitute.size(); ++r) {
            this.parent.getResultColumns().accept((SubstituteExpressionVisitor)referencesToSubstitute.get(r));
        }
        if (havingRefsToSubstitute != null) {
            Collections.sort(havingRefsToSubstitute, sorter);
        }
        return havingRefsToSubstitute;
    }

    private void addNewColumnsForAggregation() throws StandardException {
        this.aggInfo = new AggregatorInfoList();
        ArrayList havingRefsToSubstitute = null;
        if (this.groupingList != null) {
            havingRefsToSubstitute = this.addUnAggColumns();
        }
        this.addAggregateColumns();
        if (this.havingClause != null) {
            if (havingRefsToSubstitute != null) {
                for (int r = 0; r < havingRefsToSubstitute.size(); ++r) {
                    this.havingClause.accept((SubstituteExpressionVisitor)havingRefsToSubstitute.get(r));
                }
            }
            CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(ColumnReference.class, AggregateNode.class);
            this.havingClause.accept(collectNodesVisitor);
            for (ColumnReference cr : collectNodesVisitor.getList()) {
                if (cr.getGeneratedToReplaceAggregate() || cr.getSourceLevel() != this.level) continue;
                throw StandardException.newException("42X24", cr.getSQLColumnName());
            }
        }
    }

    private void addAggregateColumns() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        AggregateNode aggregate = null;
        ResultColumnList bottomRCL = this.childResult.getResultColumns();
        ResultColumnList groupByRCL = this.resultColumns;
        LanguageFactory lf = this.getLanguageConnectionContext().getLanguageFactory();
        ReplaceAggregatesWithCRVisitor replaceAggsVisitor = new ReplaceAggregatesWithCRVisitor((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()), ((FromTable)this.childResult).getTableNumber(), ResultSetNode.class);
        this.parent.getResultColumns().accept(replaceAggsVisitor);
        if (this.havingClause != null) {
            replaceAggsVisitor = new ReplaceAggregatesWithCRVisitor((ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager()), ((FromTable)this.childResult).getTableNumber());
            this.havingClause.accept(replaceAggsVisitor);
            ProjectRestrictNode parentPRSN = (ProjectRestrictNode)this.parent;
            parentPRSN.setRestriction(this.havingClause);
        }
        boolean createQueryInfo = this.getCompilerContext().createQueryInfo();
        int alSize = this.aggregateVector.size();
        for (int index = 0; index < alSize; ++index) {
            aggregate = (AggregateNode)this.aggregateVector.elementAt(index);
            ResultColumn newRC = (ResultColumn)this.getNodeFactory().getNode(80, "##aggregate result", aggregate.getNewNullResultExpression(), this.getContextManager());
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            bottomRCL.addElement(newRC);
            newRC.setVirtualColumnId(bottomRCL.size());
            int aggResultVColId = newRC.getVirtualColumnId();
            ColumnReference newColumnRef = (ColumnReference)this.getNodeFactory().getNode(62, newRC.getName(), null, this.getContextManager());
            newColumnRef.setSource(newRC);
            newColumnRef.setNestingLevel(this.getLevel());
            newColumnRef.setSourceLevel(this.getLevel());
            ResultColumn tmpRC = (ResultColumn)this.getNodeFactory().getNode(80, newRC.getColumnName(), newColumnRef, this.getContextManager());
            tmpRC.markGenerated();
            tmpRC.bindResultColumnToExpression();
            groupByRCL.addElement(tmpRC);
            tmpRC.setVirtualColumnId(groupByRCL.size());
            newColumnRef = aggregate.getGeneratedRef();
            newColumnRef.setSource(tmpRC);
            newRC = aggregate.getNewExpressionResultColumn(dd);
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            bottomRCL.addElement(newRC);
            newRC.setVirtualColumnId(bottomRCL.size());
            int aggInputVColId = newRC.getVirtualColumnId();
            ResultColumn aggInputRC = newRC;
            tmpRC = this.getColumnReference(newRC, dd);
            groupByRCL.addElement(tmpRC);
            tmpRC.setVirtualColumnId(groupByRCL.size());
            newRC = aggregate.getNewAggregatorResultColumn(dd);
            newRC.markGenerated();
            newRC.bindResultColumnToExpression();
            bottomRCL.addElement(newRC);
            newRC.setVirtualColumnId(bottomRCL.size());
            int aggregatorVColId = newRC.getVirtualColumnId();
            tmpRC = this.getColumnReference(newRC, dd);
            groupByRCL.addElement(tmpRC);
            tmpRC.setVirtualColumnId(groupByRCL.size());
            ResultColumnList aggRCL = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            aggRCL.addElement(aggInputRC);
            this.aggInfo.addElement(new AggregatorInfo(aggregate.getAggregateName(), aggregate.getAggregatorClassName(), aggInputVColId - 1, aggResultVColId - 1, aggregatorVColId - 1, aggregate.isDistinct(), lf.getResultDescription(aggRCL.makeResultDescriptors(), "SELECT"), !createQueryInfo && !this.getCompilerContext().allTablesAreReplicatedOnRemote() && aggregate.isDistinct(), aggregate.getOperand() != null && aggregate.getOperand().hasExpression()));
        }
    }

    public FromTable getParent() {
        return this.parent;
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        CostEstimate childCost = ((Optimizable)((Object)this.childResult)).optimizeIt(optimizer, predList, outerCost, rowOrdering);
        CostEstimate retval = super.optimizeIt(optimizer, predList, outerCost, rowOrdering);
        return retval;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        CostEstimate childCost = ((Optimizable)((Object)this.childResult)).estimateCost(predList, cd, outerCost, optimizer, rowOrdering);
        CostEstimate costEstimate = this.getCostEstimate(optimizer);
        costEstimate.setCost(childCost.getEstimatedCost(), childCost.rowCount(), childCost.singleScanRowCount());
        return costEstimate;
    }

    @Override
    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        return ((Optimizable)((Object)this.childResult)).pushOptPredicate(optimizablePredicate);
    }

    @Override
    public String toString() {
        return "singleInputRowOptimization: " + this.singleInputRowOptimization + "\n" + this.childResult.toString() + "\n" + super.toString();
    }

    @Override
    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    @Override
    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        this.childResult = (FromTable)this.childResult.optimize(dataDictionary, predicates, outerRows);
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), predicates, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    @Override
    ResultColumnDescriptor[] makeResultDescriptors() {
        return this.childResult.makeResultDescriptors();
    }

    @Override
    public boolean isOneRowResultSet() throws StandardException {
        return this.groupingList == null || this.groupingList.size() == 0;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        int orderingItem = 0;
        int aggInfoItem = 0;
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        FormatableArrayHolder orderingHolder = acb.getColumnOrdering(this.groupingList);
        if (this.addDistinctAggregate) {
            orderingHolder = acb.addColumnToOrdering(orderingHolder, this.addDistinctAggregateColumnNum);
        }
        if (GemFireXDUtils.TraceAggreg) {
            StringBuilder s = new StringBuilder();
            s.append("Group by column ordering is (");
            ColumnOrdering[] ordering = (ColumnOrdering[])orderingHolder.getArray(ColumnOrdering.class);
            for (int i = 0; i < ordering.length; ++i) {
                s.append(ordering[i].getColumnId());
                s.append(" ");
            }
            s.append(")");
            SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)s.toString());
        }
        orderingItem = acb.addItem(orderingHolder);
        SanityManager.ASSERT((this.aggInfo != null ? 1 : 0) != 0, (String)"aggInfo not set up as expected");
        aggInfoItem = acb.addItem(this.aggInfo);
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        mb.push(this.isInSortedOrder);
        mb.push(aggInfoItem);
        mb.push(orderingItem);
        this.resultColumns.generateHolder(acb, mb);
        mb.push(this.resultColumns.getTotalColumnSize());
        mb.push(this.resultSetNumber);
        if (this.groupingList == null || this.groupingList.size() == 0) {
            this.genScalarAggregateResultSet(acb, mb);
        } else {
            this.genGroupedAggregateResultSet(acb, mb);
        }
    }

    private void genScalarAggregateResultSet(ActivationClassBuilder acb, MethodBuilder mb) {
        String resultSet = this.addDistinctAggregate ? "getDistinctScalarAggregateResultSet" : "getScalarAggregateResultSet";
        mb.push(this.singleInputRowOptimization);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, resultSet, "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 10);
    }

    private void genGroupedAggregateResultSet(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        String resultSet = this.addDistinctAggregate ? "getDistinctGroupedAggregateResultSet" : "getGroupedAggregateResultSet";
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, resultSet, "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 9);
    }

    private ResultColumn getColumnReference(ResultColumn targetRC, DataDictionary dd) throws StandardException {
        ColumnReference tmpColumnRef = (ColumnReference)this.getNodeFactory().getNode(62, targetRC.getName(), null, this.getContextManager());
        tmpColumnRef.setSource(targetRC);
        tmpColumnRef.setNestingLevel(this.getLevel());
        tmpColumnRef.setSourceLevel(this.getLevel());
        ResultColumn newRC = (ResultColumn)this.getNodeFactory().getNode(80, targetRC.getColumnName(), tmpColumnRef, this.getContextManager());
        newRC.markGenerated();
        newRC.bindResultColumnToExpression();
        return newRC;
    }

    void considerPostOptimizeOptimizations(boolean selectHasPredicates) throws StandardException {
        AggregateNode an;
        AggregateDefinition ad;
        if (this.groupingList == null && this.aggregateVector.size() == 1 && (ad = (an = (AggregateNode)this.aggregateVector.elementAt(0)).getAggregateDefinition()) instanceof MaxMinAggregateDefinition) {
            if (an.getOperand() instanceof ColumnReference) {
                ColumnReference[] crs = new ColumnReference[]{(ColumnReference)an.getOperand()};
                Vector tableVector = new Vector();
                boolean minMaxOptimizationPossible = this.isOrderedOn(crs, false, tableVector);
                SanityManager.ASSERT((tableVector.size() <= 1 ? 1 : 0) != 0, (String)("bad number of FromBaseTables returned by isOrderedOn() -- " + tableVector.size()));
                if (minMaxOptimizationPossible) {
                    boolean ascIndex = true;
                    int colNum = crs[0].getColumnNumber();
                    AccessPath accessPath = this.getTrulyTheBestAccessPath();
                    if (accessPath == null) {
                        return;
                    }
                    IndexRowGenerator id = accessPath.getConglomerateDescriptor().getIndexDescriptor();
                    int[] keyColumns = id.baseColumnPositions();
                    boolean[] isAscending = id.isAscending();
                    for (int i = 0; i < keyColumns.length; ++i) {
                        if (colNum != keyColumns[i]) continue;
                        if (isAscending[i]) break;
                        ascIndex = false;
                        break;
                    }
                    FromBaseTable fbt = (FromBaseTable)tableVector.firstElement();
                    MaxMinAggregateDefinition temp = (MaxMinAggregateDefinition)ad;
                    if (!temp.isMax() && ascIndex || temp.isMax() && !ascIndex) {
                        fbt.disableBulkFetch();
                        this.singleInputRowOptimization = true;
                    } else if (!selectHasPredicates && (temp.isMax() && ascIndex || !temp.isMax() && !ascIndex)) {
                        fbt.disableBulkFetch();
                        fbt.doSpecialMaxScan();
                        this.singleInputRowOptimization = true;
                    }
                }
            } else if (an.getOperand() instanceof ConstantNode) {
                this.singleInputRowOptimization = true;
            }
        }
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        if (qic.getRootQueryInfo().hasUnionNode() || qic.getRootQueryInfo().hasIntersectOrExceptNode()) {
            if (qic.getPRTableCount() == 0) {
                return QueryInfoConstants.DUMMYGROUPBYQI;
            }
            throw StandardException.newException("0A000.S", " Currently Set operators are not supported with Group By for Partitioned tables");
        }
        return new GroupByQueryInfo(qic, this, this.aggInfo, this.groupingList, this.resultColumns, this.parent.resultColumns, this.havingClause, this.isInSortedOrder);
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        this.childResult.optimizeForOffHeap(false);
    }

    private static final class ExpressionSorter
    implements Comparator {
        private ExpressionSorter() {
        }

        public int compare(Object o1, Object o2) {
            try {
                ValueNode v1 = ((SubstituteExpressionVisitor)o1).getSource();
                ValueNode v2 = ((SubstituteExpressionVisitor)o2).getSource();
                CollectNodesVisitor vis = new CollectNodesVisitor(ColumnReference.class);
                v1.accept(vis);
                int refCount1 = vis.getList().size();
                vis = new CollectNodesVisitor(ColumnReference.class);
                v2.accept(vis);
                int refCount2 = vis.getList().size();
                return refCount2 - refCount1;
            }
            catch (StandardException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

