/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.stream;

import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.ManagerLogWriter;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.services.stream.InfoStreams;
import com.pivotal.gemfirexd.internal.iapi.services.stream.PrintWriterGetHeader;
import com.pivotal.gemfirexd.internal.impl.services.stream.BasicHeaderPrintWriter;
import com.pivotal.gemfirexd.internal.impl.services.stream.GfxdHeaderPrintWriterImpl;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

public final class SingleStream
implements InfoStreams,
ModuleControl,
PrivilegedAction {
    private HeaderPrintWriter theStream;
    public FileOutputStream fileStream;
    private String PBfileName;
    private PrintWriterGetHeader PBheader;

    @Override
    public void boot(boolean create, Properties properties) {
        this.theStream = this.makeStream();
    }

    @Override
    public void stop() {
        ((BasicHeaderPrintWriter)this.theStream).complete();
    }

    @Override
    public HeaderPrintWriter stream() {
        return this.theStream;
    }

    private HeaderPrintWriter makeStream() {
        PrintWriterGetHeader header = this.makeHeader();
        HeaderPrintWriter hpw = this.makeHPW(header);
        if (hpw == null) {
            hpw = this.createDefaultStream(header);
        }
        return hpw;
    }

    private PrintWriterGetHeader makeHeader() {
        return GfxdHeaderPrintWriterImpl.GfxdLogWriter.getInstance();
    }

    private HeaderPrintWriter makeHPW(PrintWriterGetHeader header) {
        String target = PropertyUtil.getSystemProperty("gemfirexd.stream.error.file");
        if (target != null) {
            return this.makeFileHPW(target, header);
        }
        target = PropertyUtil.getSystemProperty("gemfirexd.stream.error.method");
        if (target != null) {
            return this.makeMethodHPW(target, header);
        }
        target = PropertyUtil.getSystemProperty("gemfirexd.stream.error.field");
        if (target != null) {
            return this.makeFieldHPW(target, header);
        }
        return null;
    }

    private HeaderPrintWriter PBmakeFileHPW(String fileName, PrintWriterGetHeader header) {
        FileOutputStream fos;
        Object monitorEnv;
        boolean appendInfoLog = PropertyUtil.getSystemBoolean("gemfirexd.infolog.append");
        File streamFile = new File(fileName);
        if (!streamFile.isAbsolute() && (monitorEnv = Monitor.getMonitor().getEnvironment()) instanceof File) {
            streamFile = new File((File)monitorEnv, fileName);
        }
        try {
            fos = streamFile.exists() && appendInfoLog ? new FileOutputStream(streamFile.getPath(), true) : new FileOutputStream(streamFile);
            this.fileStream = fos;
        }
        catch (IOException ioe) {
            return this.useDefaultStream(header, ioe);
        }
        catch (SecurityException se) {
            return this.useDefaultStream(header, se);
        }
        return new GfxdHeaderPrintWriterImpl(new BufferedOutputStream(fos), streamFile.getPath(), header, true, streamFile.getPath());
    }

    private HeaderPrintWriter makeMethodHPW(String methodInvocation, PrintWriterGetHeader header) {
        Throwable t;
        int lastDot = methodInvocation.lastIndexOf(46);
        String className = methodInvocation.substring(0, lastDot);
        String methodName = methodInvocation.substring(lastDot + 1);
        try {
            Class<?> theClass = Class.forName(className);
            try {
                Method theMethod = theClass.getMethod(methodName, new Class[0]);
                if (!Modifier.isStatic(theMethod.getModifiers())) {
                    HeaderPrintWriter hpw = this.useDefaultStream(header);
                    hpw.printlnWithHeader(theMethod.toString() + " is not static");
                    return hpw;
                }
                try {
                    return this.makeValueHPW(theMethod, theMethod.invoke(null, new Object[0]), header, methodInvocation);
                }
                catch (IllegalAccessException iae) {
                    t = iae;
                }
                catch (IllegalArgumentException iarge) {
                    t = iarge;
                }
                catch (InvocationTargetException ite) {
                    t = ite.getTargetException();
                }
            }
            catch (NoSuchMethodException nsme) {
                t = nsme;
            }
        }
        catch (ClassNotFoundException cnfe) {
            t = cnfe;
        }
        catch (SecurityException se) {
            t = se;
        }
        return this.useDefaultStream(header, t);
    }

    private HeaderPrintWriter makeFieldHPW(String fieldAccess, PrintWriterGetHeader header) {
        Exception t;
        int lastDot = fieldAccess.lastIndexOf(46);
        String className = fieldAccess.substring(0, lastDot);
        String fieldName = fieldAccess.substring(lastDot + 1, fieldAccess.length());
        try {
            Class<?> theClass = Class.forName(className);
            try {
                Field theField = theClass.getField(fieldName);
                if (!Modifier.isStatic(theField.getModifiers())) {
                    HeaderPrintWriter hpw = this.useDefaultStream(header);
                    hpw.printlnWithHeader(theField.toString() + " is not static");
                    return hpw;
                }
                try {
                    return this.makeValueHPW(theField, theField.get(null), header, fieldAccess);
                }
                catch (IllegalAccessException iae) {
                    t = iae;
                }
                catch (IllegalArgumentException iarge) {
                    t = iarge;
                }
            }
            catch (NoSuchFieldException nsfe) {
                t = nsfe;
            }
        }
        catch (ClassNotFoundException cnfe) {
            t = cnfe;
        }
        catch (SecurityException se) {
            t = se;
        }
        return this.useDefaultStream(header, t);
    }

    private HeaderPrintWriter makeValueHPW(Member whereFrom, Object value, PrintWriterGetHeader header, String name) {
        if (value instanceof OutputStream) {
            return new BasicHeaderPrintWriter((OutputStream)value, header, false, name);
        }
        if (value instanceof Writer) {
            return new BasicHeaderPrintWriter((Writer)value, header, false, name);
        }
        HeaderPrintWriter hpw = this.useDefaultStream(header);
        if (value == null) {
            hpw.printlnWithHeader(whereFrom.toString() + "=null");
        } else {
            hpw.printlnWithHeader(whereFrom.toString() + " instanceof " + value.getClass().getName());
        }
        return hpw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeaderPrintWriter createDefaultStream(PrintWriterGetHeader header) {
        String sysLogFile = SingleStream.getGFXDLogFile();
        if (sysLogFile == null) {
            return new GfxdHeaderPrintWriterImpl(System.out, null, header, false, "System.out");
        }
        String logfile = sysLogFile;
        File logFile = new File(sysLogFile);
        String firstMsg = null;
        boolean append = Boolean.getBoolean("gemfire.append-log");
        if (!append && !InternalDistributedSystem.useSLF4JLogger() && logFile.exists()) {
            File oldMain = ManagerLogWriter.getLogNameForOldMainLog((File)logFile, (boolean)false);
            if (!logFile.renameTo(oldMain)) {
                logfile = oldMain.getPath();
                firstMsg = LocalizedStrings.InternalDistributedSystem_COULD_NOT_RENAME_0_TO_1.toLocalizedString(new Object[]{logFile, oldMain});
            } else {
                logfile = logFile.getPath();
            }
        }
        Object oldSetting = System.getProperties().get("gemfirexd.infolog.append");
        try {
            if (append) {
                System.setProperty("gemfirexd.infolog.append", "true");
            }
            HeaderPrintWriter writer = this.makeFileHPW(logfile, header);
            if (firstMsg != null) {
                writer.println(firstMsg);
            }
            HeaderPrintWriter headerPrintWriter = writer;
            return headerPrintWriter;
        }
        finally {
            if (append) {
                if (oldSetting != null) {
                    System.getProperties().put("gemfirexd.infolog.append", oldSetting);
                } else {
                    System.getProperties().remove("gemfirexd.infolog.append");
                }
            }
        }
    }

    public static String getGFXDLogFile() {
        String logFile = PropertyUtil.getSystemProperty(GfxdConstants.GFXD_LOG_FILE);
        if (logFile != null && logFile.length() == 0) {
            logFile = null;
        }
        if (PropertyUtil.getSystemBoolean("gemfire.enable.slf4j.log.bridge", true)) {
            if (logFile != null) {
                PropertyUtil.setSystemProperty("gemfire.log-file", logFile);
            }
            return null;
        }
        return logFile;
    }

    private HeaderPrintWriter useDefaultStream(PrintWriterGetHeader header) {
        return new BasicHeaderPrintWriter(System.err, header, false, "System.err");
    }

    private HeaderPrintWriter useDefaultStream(PrintWriterGetHeader header, Throwable t) {
        HeaderPrintWriter hpw = this.useDefaultStream(header);
        hpw.printlnWithHeader(t.toString());
        return hpw;
    }

    private HeaderPrintWriter makeFileHPW(String fileName, PrintWriterGetHeader header) {
        this.PBfileName = fileName;
        this.PBheader = header;
        return (HeaderPrintWriter)AccessController.doPrivileged(this);
    }

    public final Object run() {
        return this.PBmakeFileHPW(this.PBfileName, this.PBheader);
    }
}

