/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.TransactionFlag;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.Checkpoint;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.partitioned.Bucket;
import com.gemstone.gemfire.internal.concurrent.ConcurrentTLongObjectHashMap;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.shared.FinalizeHolder;
import com.gemstone.gemfire.internal.shared.FinalizeObject;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TLongArrayList;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.distributed.DistributedConnectionCloseExecutorFunction;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.conn.ConnectionSignaller;
import com.pivotal.gemfirexd.internal.engine.sql.conn.ConnectionState;
import com.pivotal.gemfirexd.internal.engine.stats.ConnectionStats;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.db.Database;
import com.pivotal.gemfirexd.internal.iapi.error.SQLWarningFactory;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineLOB;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.memory.LowMemory;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.XATransactionController;
import com.pivotal.gemfirexd.internal.impl.db.SlaveDatabase;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedBlob;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedClob;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.NoneAuthenticationServiceImpl;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;

public abstract class EmbedConnection
implements EngineConnection {
    private static final StandardException exceptionClose = StandardException.closeException();
    public static final SQLException NO_MEM = Util.generateCsSQLException("08004", "java.lang.OutOfMemoryError");
    public static final LowMemory memoryState = new LowMemory();
    DatabaseMetaData dbMetadata;
    TransactionResourceImpl tr;
    private ConcurrentTLongObjectHashMap<Object> lobHashMap = null;
    private int lobHMKey = 0;
    private WeakHashMap lobReferences = null;
    private final FinalizeObject.State active;
    private FinalizeEmbedConnection finalizer;
    boolean autoCommit = false;
    protected long beginTime;
    boolean needCommit;
    private boolean usingNoneAuth;
    private int connectionHoldAbility = 2;
    final EmbedConnection rootConnection;
    private SQLWarning topWarning;
    private InternalDriver factory;
    private Connection applicationConnection;
    private int resultSetId;
    private String connString;
    private final long connID;
    private final long incomingID;
    final boolean isRemoteConnection;
    public static final int UNINITIALIZED = -1;
    public static final int CHILD_NOT_CACHEABLE = -2;
    private final long defaultNestedConnQueryTimeOutMillis;
    private static final int OP_ENCRYPT = 0;
    private static final int OP_SHUTDOWN = 1;
    private static final int OP_HARD_UPGRADE = 2;
    private static final int OP_REPLICATION = 3;
    private boolean internalConn;
    private boolean skipCloseStats;
    private final boolean clientConn;
    private final boolean nestedConn;

    public EmbedConnection(InternalDriver driver, String url, Properties info, long id, long incomingId, boolean isRemote) throws SQLException {
        this.rootConnection = this;
        this.applicationConnection = this.rootConnection;
        this.factory = driver;
        this.tr = new TransactionResourceImpl(driver, url, info);
        this.isRemoteConnection = isRemote;
        this.nestedConn = false;
        this.defaultNestedConnQueryTimeOutMillis = 0L;
        this.clientConn = info != null && "true".equalsIgnoreCase(info.getProperty("gemfirexd.__rt.drdaClientConnection"));
        this.active = new FinalizeObject.State(1);
        this.setupContextStack(true);
        try {
            EmbedConnectionContext context = this.pushConnectionContext(this.tr.getContextManager());
            boolean shutdown = Boolean.valueOf(info.getProperty("shutdown"));
            Database database = (Database)Monitor.findService("com.pivotal.gemfirexd.internal.database.Database", this.tr.getDBName());
            boolean createBoot = this.createBoot(info);
            boolean isTwoPhaseEncryptionBoot = !createBoot && this.isEncryptionBoot(info);
            boolean isTwoPhaseUpgradeBoot = !createBoot && this.isHardUpgradeBoot(info);
            boolean isStartSlaveBoot = this.isStartReplicationSlaveBoot(info);
            boolean slaveDBAlreadyBooted = false;
            boolean isFailoverMasterBoot = false;
            boolean isFailoverSlaveBoot = false;
            String replicationOp = this.getReplicationOperation(info);
            if (replicationOp != null && (createBoot || shutdown || isTwoPhaseEncryptionBoot || isTwoPhaseUpgradeBoot)) {
                throw StandardException.newException("XRE10", replicationOp);
            }
            if (this.isReplicationFailover(info)) {
                this.checkDatabaseBooted(database, "failover", this.tr.getDBName());
                if (database.isInSlaveMode()) {
                    isFailoverSlaveBoot = true;
                } else {
                    isFailoverMasterBoot = true;
                }
            }
            Properties savedInfo = null;
            if (isStartSlaveBoot) {
                if (database != null) {
                    slaveDBAlreadyBooted = true;
                } else {
                    info.setProperty("replication.slave.mode", "slavepremode");
                }
            }
            if (this.isStopReplicationSlaveBoot(info)) {
                this.handleStopReplicationSlave(database, info);
            } else {
                if (this.isInternalShutdownSlaveDatabase(info)) {
                    this.internalStopReplicationSlave(database, info);
                    return;
                }
                if (isFailoverSlaveBoot) {
                    this.handleFailoverSlave(database);
                }
            }
            if (database != null) {
                this.tr.setDatabase(database);
                isTwoPhaseEncryptionBoot = false;
                isTwoPhaseUpgradeBoot = false;
            } else if (!shutdown) {
                if (isTwoPhaseEncryptionBoot || isTwoPhaseUpgradeBoot) {
                    savedInfo = info;
                    info = this.removePhaseTwoProps((Properties)info.clone());
                }
                if (!this.bootDatabase(info, isTwoPhaseUpgradeBoot)) {
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
            }
            if (createBoot && !shutdown) {
                if (this.tr.getDatabase() != null) {
                    this.addWarning(SQLWarningFactory.newSQLWarning("01J01", this.getDBName()));
                } else {
                    this.checkUserCredentials(null, info);
                    database = this.createDatabase(this.tr.getDBName(), info);
                    this.tr.setDatabase(database);
                }
            }
            if (this.tr.getDatabase() == null) {
                this.handleDBNotFound();
            }
            if (id == -1L) {
                id = GemFireXDUtils.newUUID();
            }
            try {
                this.checkUserCredentials(this.tr.getDBName(), info);
            }
            catch (SQLException sqle) {
                if (isStartSlaveBoot && !slaveDBAlreadyBooted) {
                    this.tr.startTransaction(id, isRemote);
                    this.handleException(this.tr.shutdownDatabaseException());
                }
                throw sqle;
            }
            this.tr.startTransaction(id, isRemote);
            if (this.isStartReplicationMasterBoot(info) || this.isStopReplicationMasterBoot(info) || isFailoverMasterBoot) {
                if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                    this.checkIsDBOwner(3);
                }
                if (this.isStartReplicationMasterBoot(info)) {
                    this.handleStartReplicationMaster(this.tr, info);
                } else if (this.isStopReplicationMasterBoot(info)) {
                    this.handleStopReplicationMaster(this.tr, info);
                } else if (isFailoverMasterBoot) {
                    this.handleFailoverMaster(this.tr);
                }
            }
            if (isTwoPhaseEncryptionBoot || isTwoPhaseUpgradeBoot || isStartSlaveBoot) {
                if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                    int operation = isTwoPhaseEncryptionBoot ? 0 : (isTwoPhaseUpgradeBoot ? 2 : 3);
                    try {
                        this.checkIsDBOwner(operation);
                    }
                    catch (SQLException sqle) {
                        if (isStartSlaveBoot) {
                            this.handleException(this.tr.shutdownDatabaseException());
                        }
                        throw sqle;
                    }
                }
                if (isStartSlaveBoot) {
                    if (slaveDBAlreadyBooted) {
                        throw StandardException.newException("XRE09", this.getTR().getDBName());
                    }
                    info.setProperty("replication.slave.mode", "slavemode");
                    info.setProperty("replication.slave.dbname", this.getTR().getDBName());
                } else {
                    info = savedInfo;
                }
                this.handleException(this.tr.shutdownDatabaseException());
                this.restoreContextStack();
                this.tr = new TransactionResourceImpl(driver, url, info);
                this.active.state = 1;
                this.setupContextStack(false);
                context = this.pushConnectionContext(this.tr.getContextManager());
                if (!this.bootDatabase(info, false)) {
                    SanityManager.THROWASSERT((String)"bootDatabase failed after initial plain boot for (re)encryption or upgrade");
                    this.tr.clearContextInError();
                    this.setInactive();
                    return;
                }
                if (isStartSlaveBoot) {
                    throw StandardException.newException("XRE08", this.getTR().getDBName());
                }
                this.tr.startTransaction(id, isRemote);
            }
            if (shutdown) {
                if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                    this.checkIsDBOwner(1);
                }
                throw this.tr.shutdownDatabaseException();
            }
            if (this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
                this.addWarning(SQLWarningFactory.newSQLWarning("01J14"));
            }
            if ((createBoot || database == null) && !shutdown) {
                this.tr.getDatabase().postCreate(this, info);
            }
            if (!shutdown) {
                if (this.tr.defaultSchema != null && !this.tr.defaultSchema.equals(this.tr.lcc.getCurrentSchemaName())) {
                    FabricDatabase.setupDefaultSchema(this.tr.lcc.getDataDictionary(), this.tr.lcc, this.tr.lcc.getTransactionExecute(), this.tr.defaultSchema, true);
                }
                this.getLanguageConnection().setRunTimeStatisticsMode(this.tr.getDatabase().getRuntimeStatistics(), false);
            }
            this.beginTime = ConnectionStats.getStatTime();
            this.finalizer = new FinalizeEmbedConnection(this, this.tr.cm, id, isRemote, this.active, this.nestedConn, this.clientConn, this.beginTime);
        }
        catch (OutOfMemoryError noMemory) {
            this.restoreContextStack();
            this.tr.lcc = null;
            if (this.tr.cm != null) {
                ContextService.removeContextManager(this.tr.cm);
                this.tr.cm = null;
            }
            memoryState.setLowMemory();
            throw NO_MEM;
        }
        catch (Throwable t) {
            StandardException se;
            if (t instanceof StandardException && (se = (StandardException)t).getSeverity() < 40000) {
                se.setSeverity(40000);
            }
            this.tr.cleanupOnError(t);
            throw this.handleException(t);
        }
        finally {
            this.connID = id;
            this.incomingID = incomingId;
            this.tr.restoreContextStack();
        }
    }

    private void checkDatabaseBooted(Database database, String operation, String dbname) throws SQLException {
        if (database == null) {
            this.setInactive();
            throw this.newSQLException("XRE11", operation, dbname);
        }
    }

    private boolean createBoot(Properties p) throws SQLException {
        int createCount = 0;
        if (Boolean.valueOf(p.getProperty("create")).booleanValue()) {
            ++createCount;
        }
        int restoreCount = 0;
        if (p.getProperty("createFrom") != null) {
            ++restoreCount;
        }
        if (p.getProperty("restoreFrom") != null) {
            ++restoreCount;
        }
        if (p.getProperty("rollForwardRecoveryFrom") != null) {
            ++restoreCount;
        }
        if (restoreCount > 1) {
            throw this.newSQLException("XJ081.C");
        }
        if (restoreCount != 0 && this.isEncryptionBoot(p)) {
            throw this.newSQLException("XJ081.C");
        }
        if ((createCount += restoreCount) > 1) {
            throw this.newSQLException("XJ049.C");
        }
        return createCount - restoreCount == 1;
    }

    private void handleDBNotFound() throws SQLException {
        String dbname = this.tr.getDBName();
        this.setInactive();
        throw this.newSQLException("XJ004.C", dbname);
    }

    private boolean isEncryptionBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("dataEncryption")) != false || p.getProperty("newBootPassword") != null || p.getProperty("newEncryptionKey") != null;
    }

    private boolean isHardUpgradeBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("upgrade"));
    }

    private boolean isStartReplicationSlaveBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("startSlave"));
    }

    private boolean isStartReplicationMasterBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("startMaster"));
    }

    private boolean isReplicationFailover(Properties p) {
        return Boolean.valueOf(p.getProperty("failover"));
    }

    private boolean isStopReplicationMasterBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("stopMaster"));
    }

    private boolean isStopReplicationSlaveBoot(Properties p) {
        return Boolean.valueOf(p.getProperty("stopSlave"));
    }

    private boolean isInternalShutdownSlaveDatabase(Properties p) {
        return Boolean.valueOf(p.getProperty("internal_stopslave"));
    }

    private String getReplicationOperation(Properties p) throws StandardException {
        String operation = null;
        int opcount = 0;
        if (this.isStartReplicationSlaveBoot(p)) {
            operation = "startSlave";
            ++opcount;
        }
        if (this.isStartReplicationMasterBoot(p)) {
            operation = "startMaster";
            ++opcount;
        }
        if (this.isStopReplicationSlaveBoot(p)) {
            operation = "stopSlave";
            ++opcount;
        }
        if (this.isInternalShutdownSlaveDatabase(p)) {
            operation = "internal_stopslave";
            ++opcount;
        }
        if (this.isStopReplicationMasterBoot(p)) {
            operation = "stopMaster";
            ++opcount;
        }
        if (this.isReplicationFailover(p)) {
            operation = "failover";
            ++opcount;
        }
        if (opcount > 1) {
            throw StandardException.newException("XRE10", operation);
        }
        return operation;
    }

    private void handleStartReplicationMaster(TransactionResourceImpl tr, Properties p) throws SQLException {
        String slavehost;
        if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        if ((slavehost = p.getProperty("slaveHost")) == null) {
            SQLException wrappedExc = this.newSQLException("XCY03.S", "slaveHost");
            throw this.newSQLException("08004", wrappedExc);
        }
        String portString = p.getProperty("slavePort");
        int slaveport = -1;
        if (portString != null) {
            slaveport = Integer.valueOf(portString);
        }
        tr.getDatabase().startReplicationMaster(this.getTR().getDBName(), slavehost, slaveport, "gemfirexd.__rt.asynch");
    }

    private void handleStopReplicationMaster(TransactionResourceImpl tr, Properties p) throws SQLException {
        if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        tr.getDatabase().stopReplicationMaster();
    }

    private void handleStopReplicationSlave(Database database, Properties p) throws StandardException, SQLException {
        this.checkDatabaseBooted(database, "stopSlave", this.tr.getDBName());
        database.stopReplicationSlave();
        throw this.newSQLException("XRE42", this.getTR().getDBName());
    }

    private void internalStopReplicationSlave(Database database, Properties p) throws StandardException, SQLException {
        this.checkDatabaseBooted(database, "internal_stopslave", this.tr.getDBName());
        if (!(database instanceof SlaveDatabase)) {
            throw this.newSQLException("XRE40");
        }
        ((SlaveDatabase)database).verifyShutdownSlave();
        this.handleException(this.tr.shutdownDatabaseException());
    }

    private void handleFailoverMaster(TransactionResourceImpl tr) throws SQLException, StandardException {
        if (!this.usingNoneAuth && this.getLanguageConnection().usesSqlAuthorization()) {
            this.checkIsDBOwner(3);
        }
        tr.getDatabase().failover(tr.getDBName());
    }

    private void handleFailoverSlave(Database database) throws SQLException {
        try {
            database.failover(this.getTR().getDBName());
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
    }

    private Properties removePhaseTwoProps(Properties p) {
        p.remove("dataEncryption");
        p.remove("newBootPassword");
        p.remove("newEncryptionKey");
        p.remove("upgrade");
        return p;
    }

    public EmbedConnection(EmbedConnection inputConnection) {
        this.connID = inputConnection.connID;
        this.incomingID = inputConnection.incomingID;
        this.isRemoteConnection = inputConnection.isRemoteConnection;
        this.nestedConn = true;
        this.clientConn = false;
        SanityManager.ASSERT((inputConnection.active.state == 1 ? 1 : 0) != 0, (String)"trying to create a proxy for an inactive conneciton");
        this.autoCommit = false;
        this.tr = null;
        this.active = new FinalizeObject.State(1);
        this.rootConnection = inputConnection.rootConnection;
        this.applicationConnection = this;
        this.factory = inputConnection.factory;
        this.connectionHoldAbility = inputConnection.connectionHoldAbility;
        this.defaultNestedConnQueryTimeOutMillis = this.rootConnection.getLanguageConnectionContext().getQueryTimeOutForLastUsedStatement();
    }

    private void checkUserCredentials(String dbname, Properties userInfo) throws SQLException {
        AuthenticationService authenticationService = null;
        try {
            authenticationService = dbname == null ? this.getLocalDriver().getAuthenticationService() : this.getTR().getDatabase().getAuthenticationService();
        }
        catch (StandardException se) {
            throw Util.generateCsSQLException(se);
        }
        if (authenticationService == null) {
            String failedString = MessageService.getTextMessage(dbname == null ? "A001" : "A002");
            throw this.newSQLException("08004", failedString);
        }
        String failure = authenticationService.authenticate(dbname, userInfo);
        if (failure != null) {
            throw this.newSQLException("08004.C.1", MessageService.getTextMessage("A020", failure));
        }
        if (authenticationService instanceof NoneAuthenticationServiceImpl) {
            this.usingNoneAuth = true;
        }
    }

    private void checkIsDBOwner(int operation) throws SQLException {
        String dbOwnerId;
        LanguageConnectionContext lcc = this.getLanguageConnection();
        String actualId = lcc.getAuthorizationId();
        if (!actualId.equals(dbOwnerId = lcc.getDataDictionary().getAuthorizationDatabaseOwner())) {
            switch (operation) {
                case 0: {
                    throw this.newSQLException("08004.C.5", actualId, this.tr.getDBName());
                }
                case 1: {
                    throw this.newSQLException("08004.C.4", actualId, this.tr.getDBName());
                }
                case 2: {
                    throw this.newSQLException("08004.C.6", actualId, this.tr.getDBName());
                }
                case 3: {
                    throw this.newSQLException("08004.C.8", actualId, this.tr.getDBName());
                }
            }
            SanityManager.THROWASSERT((String)"illegal checkIsDBOwner operation");
            throw this.newSQLException("08004.C.3");
        }
    }

    public int getEngineType() {
        Database db = this.getDatabase();
        if (null == db) {
            return 0;
        }
        return db.getEngineType();
    }

    @Override
    public final Statement createStatement() throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.createStatement(1003, 1007, this.connectionHoldAbility, id);
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.createStatement(resultSetType, resultSetConcurrency, this.connectionHoldAbility, id);
    }

    public final void setInternalConnection() {
        this.internalConn = true;
        FinalizeEmbedConnection finalizer = this.finalizer;
        if (finalizer != null) {
            finalizer.internalConn = true;
        }
    }

    public final boolean isInternalConnection() {
        return this.internalConn;
    }

    public final boolean isClientConnection() {
        return this.clientConn;
    }

    public final boolean isNestedConnection() {
        return this.nestedConn;
    }

    public final void setSkipCloseStats() {
        this.skipCloseStats = true;
        FinalizeEmbedConnection finalizer = this.finalizer;
        if (finalizer != null) {
            finalizer.skipCloseStats = true;
        }
    }

    @Override
    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability, id);
    }

    public final Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability, long id) throws SQLException {
        this.checkIfClosed();
        return this.factory.newEmbedStatement(this, false, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability, id);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, 2, null, null, true, id, false, true, false, null, 0L, 0);
    }

    public final PreparedStatement prepareStatement(String sql, boolean isQueryNode) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, 2, null, null, isQueryNode, id, false, true, false, null, 0L, 0);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.connectionHoldAbility, 2, null, null, true, id, false, true, false, null, 0L, 0);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null, true, id, false, true, false, null, 0L, 0);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, columnIndexes == null || columnIndexes.length == 0 ? 2 : 1, columnIndexes, null, true, id, false, true, false, null, 0L, 0);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, columnNames == null || columnNames.length == 0 ? 2 : 1, null, columnNames, true, id, false, true, false, null, 0L, 0);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, autoGeneratedKeys, null, null, true, id, false, true, false, null, 0L, 0);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, null, null, true, id, false, true, false, null, 0L, 0);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int[] columnIndexes) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, columnIndexes != null && columnIndexes.length > 0 ? 1 : 2, columnIndexes, null, true, id, false, true, false, null, 0L, 0);
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String[] columnNames) throws SQLException {
        long id = GemFireXDUtils.newUUID();
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, columnNames != null && columnNames.length > 0 ? 1 : 2, null, columnNames, true, id, false, true, false, null, 0L, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, boolean isQueryNode, long id, boolean needGfxdSubactivation, boolean flattenSubquery, boolean allReplicated, THashMap ncjMetaData, long rootID, int stmtLevel) throws SQLException {
        short execFlags = 0;
        if (SanityManager.TraceSingleHop) {
            SanityManager.DEBUG_PRINT((String)"TraceSingleHop", (String)("EmbedConnection::prepareStatement isQueryNode: " + isQueryNode + " and bucket ids in lcc: " + this.getLanguageConnectionContext().getBucketIdsForLocalExecution()));
        }
        if (isQueryNode && this.getLanguageConnectionContext().getBucketIdsForLocalExecution() == null) {
            execFlags = GemFireXDUtils.set(execFlags, (short)2);
        }
        if (!flattenSubquery) {
            execFlags = GemFireXDUtils.set(execFlags, (short)8);
        }
        if (needGfxdSubactivation) {
            execFlags = GemFireXDUtils.set(execFlags, (short)4);
        }
        if (allReplicated) {
            if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"EmbedConnection.prepareStatement - Setting ALL_TABLES_ARE_REPLICATED_ON_REMOTE to TRUE");
            }
            execFlags = GemFireXDUtils.set(execFlags, (short)64);
        } else if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"EmbedConnection.prepareStatement - Flag ALL_TABLES_ARE_REPLICATED_ON_REMOTE is FALSE");
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(true);
            try {
                PreparedStatement preparedStatement = this.factory.newEmbedPreparedStatement(this, sql, this.getTR().forMetadataPrepare(), this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, columnIndexes, columnNames, id, execFlags, ncjMetaData, rootID, stmtLevel);
                return preparedStatement;
            }
            catch (SQLException sqle) {
                PreparedStatement ps;
                GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                if (observer != null && (ps = observer.afterQueryPrepareFailure(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, columnIndexes, columnNames, sqle)) != null) {
                    PreparedStatement preparedStatement2 = ps;
                    return preparedStatement2;
                }
                throw sqle;
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, this.connectionHoldAbility);
    }

    public final CallableStatement prepareCall(String sql, long stmtId) throws SQLException {
        return this.prepareCall(sql, stmtId, 1003, 1007, this.connectionHoldAbility);
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.connectionHoldAbility);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfClosed();
        long id = GemFireXDUtils.newUUID();
        short execFlags = 0;
        execFlags = GemFireXDUtils.set(execFlags, (short)2);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(true);
            try {
                CallableStatement callableStatement = this.factory.newEmbedCallableStatement(this, sql, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability, id, execFlags);
                return callableStatement;
            }
            catch (SQLException sqle) {
                CallableStatement ps;
                GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
                if (observer != null && (ps = (CallableStatement)observer.afterQueryPrepareFailure(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null, sqle)) != null) {
                    CallableStatement callableStatement2 = ps;
                    return callableStatement2;
                }
                throw sqle;
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CallableStatement prepareCall(String sql, long stmtId, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkIfClosed();
        short execFlags = 0;
        execFlags = GemFireXDUtils.set(execFlags, (short)2);
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            CallableStatement callableStatement;
            this.setupContextStack(true);
            try {
                callableStatement = this.factory.newEmbedCallableStatement(this, sql, this.setResultSetType(resultSetType), resultSetConcurrency, resultSetHoldability, stmtId, execFlags);
            }
            catch (Throwable throwable) {
                this.restoreContextStack();
                throw throwable;
            }
            this.restoreContextStack();
            return callableStatement;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkIfClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkIfClosed();
        if (this.rootConnection != this && autoCommit) {
            throw this.newSQLException("XJ030.S");
        }
        LanguageConnectionContext lcc = this.getLanguageConnection();
        if (lcc.isAllowExplicitCommitTrue()) {
            autoCommit = true;
        }
        if (this.autoCommit != autoCommit) {
            this.commit();
        }
        this.autoCommit = autoCommit;
        lcc.setAutoCommit(this.autoCommit);
    }

    public void setAutoCommit(boolean autoCommit, boolean isInit) throws SQLException {
        if (isInit) {
            this.autoCommit = autoCommit;
            this.getLanguageConnection().setAutoCommit(autoCommit);
        } else {
            this.setAutoCommit(autoCommit);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkIfClosed();
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(false);
            try {
                this.getTR().commit(this);
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(false);
            try {
                this.getTR().rollback();
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
            this.needCommit = false;
        }
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.afterRollback(this);
        }
    }

    @Override
    public final void close() throws SQLException {
        this.close(true);
    }

    @Override
    public final void internalClose() throws SQLException {
        this.close(exceptionClose, true, true);
    }

    public final void internalSetAutoCommit(boolean autoCommit) throws SQLException {
        this.checkIfClosed();
        if (this.rootConnection != this && autoCommit) {
            throw this.newSQLException("XJ030.S");
        }
        if (this.autoCommit != autoCommit) {
            this.internalCommit();
        }
        this.autoCommit = autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void internalCommit() throws SQLException {
        LanguageConnectionContext lcc = this.getLanguageConnection();
        if (lcc != null) {
            Object object = this.getConnectionSynchronization();
            synchronized (object) {
                this.setupContextStack(false);
                try {
                    lcc.internalCommit(true);
                    this.clearLOBMapping();
                }
                catch (Throwable t) {
                    throw this.handleException(t);
                }
                finally {
                    this.restoreContextStack();
                }
                this.needCommit = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void internalRollback() throws SQLException {
        LanguageConnectionContext lcc = this.getLanguageConnection();
        if (lcc != null) {
            Object object = this.getConnectionSynchronization();
            synchronized (object) {
                this.setupContextStack(false);
                try {
                    lcc.internalRollback();
                    this.clearLOBMapping();
                }
                catch (Throwable t) {
                    throw this.handleException(t);
                }
                finally {
                    this.restoreContextStack();
                }
                this.needCommit = false;
            }
        }
    }

    @Override
    public final void forceClose() {
        TransactionResourceImpl tr = this.getTR();
        if (tr != null) {
            ContextManager cm;
            TransactionController tc;
            LanguageConnectionContext lcc = tr.getLcc();
            if (lcc != null && (tc = lcc.getTransactionExecute()) != null) {
                try {
                    tc.abort();
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
                tc.releaseAllLocks(true, true);
            }
            if (this.rootConnection == this && (cm = this.tr.cm) != null) {
                ContextService.removeContextManager(cm);
            }
            this.active.state = 0;
        }
    }

    @Override
    public final FinalizeObject getAndClearFinalizer() {
        FinalizeEmbedConnection finalizer = this.finalizer;
        if (finalizer != null) {
            this.finalizer = null;
        }
        return finalizer;
    }

    public final void close(boolean distribute) throws SQLException {
        if (!this.isClosed()) {
            LanguageConnectionContext lcc = this.getTR().getLcc();
            boolean autoCommit = this.autoCommit;
            if (lcc != null) {
                int isolationLevel = ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[lcc.getCurrentIsolationLevel()];
                if (isolationLevel == 0) {
                    autoCommit = true;
                }
                if (this.rootConnection == this && (lcc.statsEnabled() || lcc.explainConnection())) {
                    lcc.setStatsEnabled(false, false, false);
                }
            }
            if (this.rootConnection == this && !autoCommit && !this.transactionIsIdle()) {
                throw this.newSQLException("25001");
            }
        }
        this.close(exceptionClose, distribute, false);
    }

    public void checkForTransactionInProgress() throws SQLException {
        LanguageConnectionContext lcc = this.getTR().getLcc();
        if (!(this.isClosed() || this.rootConnection != this || lcc != null && lcc.getCurrentIsolationLevel() == 0 || this.autoCommit || this.transactionIsIdle())) {
            throw this.newSQLException("25001");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(StandardException e, boolean distribute, boolean internal) throws SQLException {
        GemFireXDQueryObserver observer;
        boolean wasActive = false;
        FinalizeEmbedConnection finalizer = this.finalizer;
        if (finalizer != null) {
            finalizer.clearAll();
            this.finalizer = null;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.rootConnection == this) {
                ContextManager cm;
                if (this.active.state == 1) {
                    this.tr.getLcc().setRunTimeStatisticsMode(false, false);
                    if (this.tr.isActive()) {
                        this.setupContextStack(false);
                        wasActive = true;
                        try {
                            if (internal) {
                                try {
                                    this.tr.rollback();
                                }
                                catch (StandardException se) {
                                    if (SanityManager.isFinerEnabled) {
                                        SanityManager.DEBUG_PRINT((String)"TraceTran", (String)"Got exception in internal connection rollback.", (Throwable)se);
                                    }
                                }
                            } else {
                                this.tr.rollback();
                            }
                            this.tr.clearLcc();
                            this.tr.cleanupOnError(e);
                        }
                        catch (Throwable t) {
                            throw this.handleException(t);
                        }
                        finally {
                            this.restoreContextStack();
                        }
                    } else {
                        this.tr.clearLcc();
                        this.tr.cleanupOnError(e);
                    }
                }
                if ((cm = this.tr.cm) != null) {
                    ContextService.removeContextManager(cm);
                }
            }
            if (!this.isClosed()) {
                this.setInactive();
            }
        }
        if (wasActive && distribute && this.rootConnection == this && this.connID != -1L && this.connID != -2L) {
            ConnectionSignaller.getInstance().add(new ConnectionCloseState(this.connID));
        }
        if ((observer = GemFireXDQueryObserverHolder.getInstance()) != null) {
            observer.afterConnectionClose(this);
        }
        this.incrementCloseStats();
    }

    public final void closingNestedConnection() {
        this.incrementCloseStats();
    }

    private final void incrementCloseStats() {
        if (!this.skipCloseStats) {
            EmbedConnection.incrementCloseStats(this.nestedConn, this.internalConn, this.clientConn, this.beginTime);
        }
    }

    private static void incrementCloseStats(boolean nestedConn, boolean internalConn, boolean clientConn, long beginTime) {
        ConnectionStats stats;
        InternalDriver driver = InternalDriver.activeDriver();
        if (driver != null && (stats = driver.getConnectionStats()) != null) {
            if (nestedConn) {
                stats.incNestedConnectionsClosed();
                stats.decNestedConnectionsOpen();
            } else if (internalConn) {
                stats.incInternalConnectionsClosed();
                stats.decInternalConnectionsOpen();
            } else if (!clientConn) {
                stats.incPeerConnectionsClosed();
                stats.incPeerConnectionLifeTime(beginTime);
                stats.decPeerConnectionsOpen();
            }
        }
    }

    @Override
    public final boolean isActive() {
        return this.active.state == 1;
    }

    @Override
    public final boolean isClosed() {
        return this.active.state != 1 || !this.getTR().isActive();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkIfClosed();
        if (this.dbMetadata == null) {
            this.dbMetadata = this.factory.newEmbedDatabaseMetaData(this, this.getTR().getUrl());
        }
        return this.dbMetadata;
    }

    @Override
    public final int getHoldability() throws SQLException {
        this.checkIfClosed();
        return this.connectionHoldAbility;
    }

    @Override
    public final void setHoldability(int holdability) throws SQLException {
        this.checkIfClosed();
        this.connectionHoldAbility = holdability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(false);
            try {
                this.getLanguageConnection().setReadOnly(readOnly);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        this.checkIfClosed();
        return this.getLanguageConnection().isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkIfClosed();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkIfClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.setTransactionIsolation(level, null);
    }

    @Override
    public EnumSet<TransactionFlag> getTransactionFlags() {
        return this.getTR().getTXFlags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int level, EnumSet<TransactionFlag> txFlags) throws SQLException {
        int iLevel;
        LanguageConnectionContext lcc = this.getLanguageConnection();
        if (lcc == null) {
            throw Util.noCurrentConnection();
        }
        int currentLevel = ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[lcc.getCurrentIsolationLevel()];
        if (GemFireXDUtils.TraceTran) {
            SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("connID=" + this.connID + "; current isolation level " + currentLevel + "; isolation being assigned " + level));
        }
        if (level == currentLevel && ArrayUtils.objectEquals(txFlags, lcc.getTXFlags())) {
            return;
        }
        switch (level) {
            case 1: {
                SanityManager.DEBUG_PRINT((String)"info:TraceTran", (String)("Upgrading transaction level from READ_UNCOMMITTED to READ_COMMITTED for " + this.getLanguageConnectionContext().getTransactionExecute()));
            }
            case 2: {
                iLevel = 2;
                break;
            }
            case 4: {
                iLevel = 3;
                break;
            }
            case 8: {
                GemFireStore store = Misc.getMemStoreBootingNoThrow();
                if (store != null && store.isSnappyStore()) {
                    iLevel = 3;
                    this.setAutoCommit(true);
                    break;
                }
                throw this.newSQLException("XJ045.S", level);
            }
            case 0: {
                iLevel = 0;
                break;
            }
            case 16: {
                iLevel = 5;
                break;
            }
            default: {
                throw this.newSQLException("XJ045.S", level);
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(false);
            try {
                if (txFlags != null) {
                    lcc.setTXFlags(txFlags);
                } else if (lcc.getTXFlags() == null) {
                    txFlags = this.getTR().getTXFlags();
                    lcc.setTXFlags(txFlags);
                }
                lcc.setIsolationLevel(iLevel);
            }
            catch (StandardException e) {
                throw this.handleException(e);
            }
            finally {
                this.restoreContextStack();
                if (GemFireXDUtils.TraceTran) {
                    SanityManager.DEBUG_PRINT((String)"TraceTran", (String)("conn ID = " + this.connID + "; isolation level after asignment=" + this.getTransactionIsolation()));
                }
            }
        }
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        this.checkIfClosed();
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        if (lcc != null) {
            return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[lcc.getCurrentIsolationLevel()];
        }
        throw Util.noCurrentConnection();
    }

    @Override
    public final synchronized SQLWarning getWarnings() throws SQLException {
        this.checkIfClosed();
        return this.topWarning;
    }

    @Override
    public final synchronized void clearWarnings() throws SQLException {
        this.checkIfClosed();
        this.topWarning = null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkIfClosed();
        return Collections.EMPTY_MAP;
    }

    public final void setTypeMap(Map map) throws SQLException {
        this.checkIfClosed();
        throw Util.notImplemented();
    }

    @Override
    public final synchronized void addWarning(SQLWarning newWarning) {
        if (this.topWarning == null) {
            this.topWarning = newWarning;
            return;
        }
        this.topWarning.setNextWarning(newWarning);
    }

    public String getDBName() {
        return this.getTR().getDBName();
    }

    public final LanguageConnectionContext getLanguageConnection() {
        return this.getTR().getLcc();
    }

    protected final void checkIfClosed() throws SQLException {
        if (!this.isActive()) {
            throw Util.noCurrentConnection();
        }
    }

    SQLException handleException(Throwable thrownException) throws SQLException {
        if (thrownException instanceof StandardException) {
            StandardException se = (StandardException)thrownException;
            EmbedConnection.abortForConstraintViolationInTX(se, this.getLanguageConnectionContext());
            if (se.getSeverity() >= 30000) {
                this.clearLOBMapping();
            }
        }
        return this.getTR().handleException(thrownException, this.autoCommit, true);
    }

    final SQLException handleException(Throwable thrownException, boolean rollbackOnAutoCommit) throws SQLException {
        if (thrownException instanceof StandardException) {
            StandardException se = (StandardException)thrownException;
            EmbedConnection.abortForConstraintViolationInTX(se, this.getLanguageConnectionContext());
            if (se.getSeverity() >= 30000) {
                this.clearLOBMapping();
            }
        }
        return this.getTR().handleException(thrownException, this.autoCommit, rollbackOnAutoCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInactive() {
        if (this.active.state == 0) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.active.state = 0;
            this.dbMetadata = null;
        }
    }

    protected void needCommit() {
        if (!this.needCommit) {
            this.needCommit = true;
        }
    }

    protected final void commitIfNeeded() throws SQLException {
        if (this.autoCommit && this.needCommit) {
            try {
                this.getTR().commit(this);
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            this.needCommit = false;
        }
    }

    protected final void commitIfAutoCommit() throws SQLException {
        if (this.autoCommit) {
            try {
                this.getTR().commit(this);
                this.clearLOBMapping();
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            this.needCommit = false;
        }
    }

    @Override
    public final Object getConnectionSynchronization() {
        return this.rootConnection;
    }

    public final void setupContextStack(boolean isOperation) throws SQLException {
        this.checkIfClosed();
        try {
            if (this.isRemoteConnection) {
                this.getTR().setupContextStack();
            } else {
                this.getTR().setupContextStackAndReattach(isOperation);
            }
        }
        catch (SQLException sqle) {
            throw sqle;
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
    }

    public final void restoreContextStack() throws SQLException {
        TransactionResourceImpl tr = this.getTR();
        tr.restoreContextStack();
    }

    private Database createDatabase(String dbname, Properties info) throws SQLException {
        info = this.filterProperties(info);
        try {
            if (Monitor.createPersistentService("com.pivotal.gemfirexd.internal.database.Database", dbname, info) == null) {
                this.addWarning(SQLWarningFactory.newSQLWarning("01J01", dbname));
            }
        }
        catch (StandardException mse) {
            if (mse.getSQLState().startsWith("XB") || mse.getSQLState().startsWith("XC")) {
                throw Util.generateCsSQLException(mse);
            }
            throw Util.generateCsSQLException("XJ041.C", (Object)dbname, this.getBootDatabaseFailureCause(mse));
        }
        info.clear();
        return (Database)Monitor.findService("com.pivotal.gemfirexd.internal.database.Database", dbname);
    }

    private boolean bootDatabase(Properties info, boolean softAuthenticationBoot) throws Throwable {
        String dbname = this.tr.getDBName();
        try {
            GemFireStore store;
            if (info.getProperty("gemfirexd.__rt.fabricapi") == null) {
                if (GemFireXDUtils.TraceFabricServiceBoot) {
                    SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Setting first connection as boot indicator");
                }
                info.setProperty("gemfirexd.__rt.fabricapi", GfxdConstants.BT_INDIC.FIRSTCONNECTION.toString());
            }
            info = this.filterProperties(info);
            if (softAuthenticationBoot) {
                info.setProperty("softUpgradeNoFeatureCheck", "true");
            } else {
                info.remove("softUpgradeNoFeatureCheck");
            }
            boolean booted = Boolean.parseBoolean(info.getProperty("internal-connection"));
            GemFireStore gemFireStore = store = booted ? Misc.getMemStoreBooting() : Misc.getMemStoreBootingNoThrow();
            if (store == null && !Monitor.startPersistentService(dbname, info)) {
                return false;
            }
            info.clear();
            Database database = (Database)Monitor.findService("com.pivotal.gemfirexd.internal.database.Database", dbname);
            this.tr.setDatabase(database);
            if (store == null && (store = Misc.getMemStoreBootingNoThrow()) != null) {
                store.setDBName(dbname);
            }
        }
        catch (StandardException mse) {
            Throwable ne = mse.getCause();
            if (GemFireXDUtils.TraceFabricServiceBoot) {
                SanityManager.DEBUG_PRINT((String)"TraceFabricServiceBoot", (String)"Failed to boot database", (Throwable)mse);
            }
            if (mse.getSQLState().startsWith("XB") || mse.getSQLState().startsWith("XC")) {
                throw Util.generateCsSQLException(mse);
            }
            throw Util.generateCsSQLException("XJ040.C", (Object)dbname, this.getBootDatabaseFailureCause(mse));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareMetaDataStatement(String sql) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(true);
            PreparedStatement s = null;
            try {
                boolean execFlags = false;
                s = this.factory.newEmbedPreparedStatement(this, sql, true, 1003, 1007, this.connectionHoldAbility, 2, null, null, -1L, (short)(execFlags ? 1 : 0), null, 0L, 0);
            }
            finally {
                this.restoreContextStack();
            }
            return s;
        }
    }

    public final InternalDriver getLocalDriver() {
        return this.getTR().getDriver();
    }

    public final ContextManager getContextManager() {
        return this.getTR().getContextManager();
    }

    private Properties filterProperties(Properties inputSet) {
        Properties limited = new Properties();
        Enumeration<?> e = inputSet.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith("derby.")) continue;
            String val = inputSet.getProperty(key);
            if (val != null) {
                limited.put(key, val);
                continue;
            }
            limited.put(key, inputSet.get(key));
        }
        return limited;
    }

    protected Database getDatabase() {
        return this.getTR().getDatabase();
    }

    public final TransactionResourceImpl getTR() {
        return this.rootConnection.tr;
    }

    public TransactionResourceImpl getTRResource() throws SQLException {
        return this.getTR();
    }

    private EmbedConnectionContext pushConnectionContext(ContextManager cm) {
        return new EmbedConnectionContext(cm, this);
    }

    public final void setApplicationConnection(Connection applicationConnection) {
        this.applicationConnection = applicationConnection;
    }

    public final Connection getApplicationConnection() {
        return this.applicationConnection;
    }

    @Override
    public void setDrdaID(String drdaID) {
        this.getLanguageConnection().setDrdaID(drdaID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetFromPool() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(false);
            try {
                this.getLanguageConnection().resetFromPool();
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int xa_prepare() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(true);
            try {
                XATransactionController tc = (XATransactionController)this.getLanguageConnection().getTransactionExecute();
                int ret = tc.xa_prepare();
                if (ret == 1) {
                    this.getLanguageConnection().internalCommit(false);
                }
                int n = ret;
                return n;
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_commit(boolean onePhase) throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(true);
            try {
                this.getLanguageConnection().xaCommit(onePhase);
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xa_rollback() throws SQLException {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.setupContextStack(true);
            try {
                this.getLanguageConnection().xaRollback();
            }
            catch (StandardException t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public final boolean transactionIsIdle() {
        return this.getTR().isIdle();
    }

    private int setResultSetType(int resultSetType) {
        if (resultSetType == 1005) {
            this.addWarning(SQLWarningFactory.newSQLWarning("01J02"));
            resultSetType = 1004;
        }
        return resultSetType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPrepareIsolation(int level) throws SQLException {
        if (level == this.getPrepareIsolation()) {
            return;
        }
        switch (level) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw Util.generateCsSQLException("XJ045.S", new Integer(level));
            }
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            this.getLanguageConnection().setPrepareIsolationLevel(level);
        }
    }

    @Override
    public int getPrepareIsolation() {
        return this.getLanguageConnection().getPrepareIsolationLevel();
    }

    final int getResultSetOrderId() {
        if (this == this.rootConnection) {
            return 0;
        }
        return this.rootConnection.resultSetId++;
    }

    protected SQLException newSQLException(String messageId) {
        return Util.generateCsSQLException(messageId);
    }

    protected SQLException newSQLException(String messageId, Object arg1) {
        return Util.generateCsSQLException(messageId, arg1);
    }

    protected SQLException newSQLException(String messageId, Object arg1, Object arg2) {
        return Util.generateCsSQLException(messageId, arg1, arg2);
    }

    public String toString() {
        if (this.connString == null) {
            LanguageConnectionContext lcc = this.getLanguageConnection();
            StringBuilder sb = new StringBuilder();
            sb.append("EmbedConnection@").append(this.hashCode()).append(' ').append(" (CONNID = ").append(this.connID).append(") ");
            if (this.connID != this.incomingID) {
                sb.append(" (INCOMINGID = ").append(this.incomingID);
            }
            sb.append(" (REMOTE = ").append(this.isRemoteConnection).append(") ");
            if (lcc != null) {
                sb.append("(XID = ").append(lcc.getTransactionExecute() != null ? lcc.getTransactionExecute().getTransactionIdString() : "NULL").append("), ").append("(SESSIONID = ").append(Integer.toString(lcc.getInstanceNumber())).append("), ").append("(DATABASE = ").append(lcc.getDbname()).append("), ").append("(DRDAID = ").append(lcc.getDrdaID()).append(") ");
                this.connString = sb.toString();
            } else {
                return sb.toString();
            }
        }
        return this.connString;
    }

    @Override
    public EmbedClob createClob() throws SQLException {
        this.checkIfClosed();
        return new EmbedClob(this);
    }

    @Override
    public EmbedBlob createBlob() throws SQLException {
        this.checkIfClosed();
        return new EmbedBlob(new byte[0], this);
    }

    @Override
    public int addLOBMapping(Object LOBReference) {
        int loc = this.getIncLOBKey();
        this.getlobHMObj().putPrimitive((long)loc, LOBReference);
        return loc;
    }

    @Override
    public void removeLOBMapping(long key) {
        this.getlobHMObj().removePrimitive(key);
    }

    @Override
    public Object getLOBMapping(long key) {
        return this.getlobHMObj().getPrimitive(key);
    }

    @Override
    public boolean hasLOBs() {
        ConcurrentTLongObjectHashMap<Object> m = this.rootConnection.lobHashMap;
        return m != null && m.size() > 0;
    }

    @Override
    public void clearLOBMapping() throws SQLException {
        WeakHashMap map = this.rootConnection.lobReferences;
        if (map != null) {
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                ((EngineLOB)it.next()).free();
            }
            map.clear();
        }
        if (this.rootConnection.lobHashMap != null) {
            this.rootConnection.lobHashMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIncLOBKey() {
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            int newKey = ++this.rootConnection.lobHMKey;
            if (newKey == 32768 || newKey == 32770 || newKey == 32772 || newKey == 32774 || newKey == 32776) {
                newKey = ++this.rootConnection.lobHMKey;
            }
            if (newKey == Integer.MIN_VALUE || newKey == 0) {
                this.rootConnection.lobHMKey = 1;
                newKey = 1;
            }
            return newKey;
        }
    }

    void addLOBReference(Object lobReference) {
        if (this.rootConnection.lobReferences == null) {
            this.rootConnection.lobReferences = new WeakHashMap();
        }
        this.rootConnection.lobReferences.put(lobReference, null);
    }

    public final ConcurrentTLongObjectHashMap<Object> getlobHMObj() {
        if (this.rootConnection.lobHashMap == null) {
            this.rootConnection.lobHashMap = new ConcurrentTLongObjectHashMap();
        }
        return this.rootConnection.lobHashMap;
    }

    public void cancelRunningStatement() {
        this.getLanguageConnection().getStatementContext().cancel();
    }

    @Override
    public String getCurrentSchemaName() {
        return this.getLanguageConnection().getCurrentSchemaName();
    }

    Throwable getBootDatabaseFailureCause(StandardException mse) {
        Throwable ne = mse.getCause();
        if (ne == null) {
            ne = mse;
        } else {
            while (ne instanceof StandardException && ("XJ040".equals((mse = (StandardException)ne).getSQLState()) || "XJ041".equals(mse.getSQLState()))) {
                ne = mse.getCause();
            }
        }
        if (ne instanceof StandardException) {
            ne = Util.generateCsSQLException((StandardException)ne);
        }
        return ne;
    }

    public final Statement createStatement(long id) throws SQLException {
        return this.createStatement(1003, 1007, this.connectionHoldAbility, id);
    }

    public final PreparedStatement prepareStatementByPassQueryInfo(long stmtID, String sql, boolean needGfxdSubactivation, boolean flattenSubquery, boolean allReplicated, THashMap ncjMetaData, long rootID, int stmtLevel) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.connectionHoldAbility, 2, null, null, false, stmtID, needGfxdSubactivation, flattenSubquery, allReplicated, ncjMetaData, rootID, stmtLevel);
    }

    protected void forceCommit() throws SQLException {
        try {
            this.getTR().commit(this);
            this.clearLOBMapping();
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
        this.needCommit = false;
    }

    public final long getConnectionID() {
        return this.connID;
    }

    public final boolean isRemoteConnection() {
        return this.isRemoteConnection;
    }

    public long getDefaultNestedConnQueryTimeOut() {
        return this.defaultNestedConnQueryTimeOutMillis;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaces) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public <T> T unwrap(Class<T> interfaces) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.0");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.setDefaultSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.getCurrentSchemaName();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    @Override
    public final void setPossibleDuplicate(boolean isDup) {
        LanguageConnectionContext lcc = this.getTR().getLcc();
        if (lcc != null) {
            lcc.setPossibleDuplicate(isDup);
        }
    }

    @Override
    public final void setEnableStreaming(boolean enable) {
        LanguageConnectionContext lcc = this.getTR().getLcc();
        if (lcc != null) {
            lcc.setEnableStreaming(enable);
        }
    }

    @Override
    public final LanguageConnectionContext getLanguageConnectionContext() {
        return this.getTR().getLcc();
    }

    public final void setTXIdForFinalizer(TXId txId) {
        FinalizeEmbedConnection finalizer = this.finalizer;
        if (finalizer != null) {
            finalizer.txId = txId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultSchema(String schemaName) throws SQLException {
        if (schemaName == null) {
            return;
        }
        LanguageConnectionContext lcc = this.getTR().getLcc();
        if (lcc == null || lcc.getDefaultSchema().getSchemaName().equals(schemaName)) {
            return;
        }
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            this.setupContextStack(true);
            try {
                FabricDatabase.setupDefaultSchema(lcc.getDataDictionary(), lcc, lcc.getTransactionExecute(), schemaName, true);
            }
            catch (StandardException sqle) {
                throw new SQLException(sqle);
            }
            finally {
                this.restoreContextStack();
            }
        }
    }

    public EmbedConnection getRootConnection() {
        EmbedConnection currentConn = this;
        while (currentConn.rootConnection != currentConn) {
            currentConn = currentConn.rootConnection;
        }
        return currentConn;
    }

    public static void abortForConstraintViolationInTX(StandardException se, LanguageConnectionContext lcc) {
        if (EmbedConnection.abortForConstraintViolationInTX(se.getSQLState(), se.getSeverity(), lcc)) {
            se.setSeverity(30000);
        }
    }

    public static boolean abortForConstraintViolationInTX(String sqlState, int severity, LanguageConnectionContext lcc) {
        TXStateProxy tx;
        if (lcc == null) {
            return true;
        }
        if (severity < 30000 && (sqlState.startsWith("23") || sqlState.startsWith("22") || sqlState.startsWith("XS") || sqlState.startsWith("38000") || sqlState.startsWith("XJ001") || sqlState.startsWith("XCL52"))) {
            int isolationLevel = ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[lcc.getCurrentIsolationLevel()];
            return isolationLevel != 0;
        }
        GemFireTransaction tc = (GemFireTransaction)lcc.getTransactionExecute();
        if (tc != null && (tx = tc.getCurrentTXStateProxy()) != null) {
            return !tx.isInProgress() || tx.getTXInconsistent() != null;
        }
        return false;
    }

    @Override
    public void setExecutionSequence(int execSeq) {
        LanguageConnectionContext lcc = this.getLanguageConnection();
        assert (lcc != null) : "expected non null lcc object";
        GemFireTransaction gft = (GemFireTransaction)lcc.getTransactionExecute();
        gft.setExecutionSeqInTXState(execSeq);
    }

    @Override
    public Checkpoint masqueradeAsTxn(TXId txid, int isolationLevel) throws SQLException {
        LanguageConnectionContext lcc = this.getLanguageConnection();
        assert (lcc != null) : "expected non null lcc object";
        GemFireTransaction gft = (GemFireTransaction)lcc.getTransactionExecute();
        return gft.masqueradeAsTxn(txid, isolationLevel);
    }

    @Override
    public void updateAffectedRegion(Bucket b) {
        LanguageConnectionContext lcc = this.getLanguageConnection();
        assert (lcc != null) : "expected non null lcc object";
        GemFireTransaction gft = (GemFireTransaction)lcc.getTransactionExecute();
        gft.addAffectedRegion(b);
    }

    static final class FinalizeEmbedConnection
    extends FinalizeObject {
        private ContextManager cm;
        private long connId;
        private final boolean forRemote;
        private final FinalizeObject.State active;
        private final boolean nestedConn;
        private final boolean clientConn;
        boolean internalConn;
        boolean skipCloseStats;
        private final long beginTime;
        private TXId txId;

        public FinalizeEmbedConnection(EmbedConnection conn, ContextManager cm, long connId, boolean forRemote, FinalizeObject.State active, boolean nestConn, boolean clientConn, long beginTime) {
            super((Object)conn, true);
            this.cm = cm;
            this.connId = connId;
            this.forRemote = forRemote;
            this.active = active;
            this.nestedConn = nestConn;
            this.clientConn = clientConn;
            this.beginTime = beginTime;
        }

        public final FinalizeHolder getHolder() {
            return FinalizeEmbedConnection.getServerHolder();
        }

        protected void clearThis() {
            this.cm = null;
            this.connId = -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean doFinalize() throws SQLException {
            ContextManager cm;
            if (this.active.state == 1 && (cm = this.cm) != null) {
                ContextService.removeContextManager(cm);
                this.cm = null;
            }
            if (!this.forRemote && this.connId != -1L && this.connId != -2L) {
                TXManagerImpl txMgr;
                TXStateProxy txProxy;
                GemFireCacheImpl cache;
                if (this.txId != null && this.connId >= 0L && (cache = GemFireCacheImpl.getInstance()) != null && (txProxy = (txMgr = cache.getTxManager()).getHostedTXState(this.txId)) != null && txProxy.isInProgress()) {
                    TXManagerImpl.TXContext context = null;
                    TXStateInterface previousTX = null;
                    try {
                        context = TXManagerImpl.getOrCreateTXContext();
                        previousTX = context.getTXState();
                        txMgr.setTXState((TXStateInterface)txProxy, context);
                        txProxy.rollback((Object)this.connId);
                    }
                    catch (Throwable t) {
                        Error err;
                        if (t instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)t))) {
                            SystemFailure.initiateFailure((Error)err);
                            throw err;
                        }
                        SanityManager.DEBUG_PRINT((String)"warning:FinalizeEmbedConnection", (String)"unexpected exception while invoking finalizer", (Throwable)t);
                    }
                    finally {
                        if (context != null) {
                            txMgr.setTXState(previousTX, context);
                        }
                    }
                }
                ConnectionSignaller.getInstance().add(new ConnectionCloseState(this.connId));
            }
            this.active.state = 0;
            if (!this.skipCloseStats) {
                EmbedConnection.incrementCloseStats(this.nestedConn, this.internalConn, this.clientConn, this.beginTime);
            }
            return true;
        }
    }

    static final class ConnectionCloseState
    implements ConnectionState {
        private final long closeConnectionId;
        private TLongArrayList closeConnectionIds;

        ConnectionCloseState(long connId) {
            this.closeConnectionId = connId;
            this.closeConnectionIds = null;
            GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
            if (observer == null) {
                DistributedConnectionCloseExecutorFunction.closeConnection(connId, GfxdConnectionHolder.getHolder());
            } else {
                long[] connIds = new long[]{connId};
                observer.beforeConnectionCloseByExecutorFunction(connIds);
                DistributedConnectionCloseExecutorFunction.closeConnection(connId, GfxdConnectionHolder.getHolder());
                observer.afterConnectionCloseByExecutorFunction(connIds);
            }
        }

        @Override
        public boolean accumulate(ConnectionState other) {
            if (other instanceof ConnectionCloseState) {
                ConnectionCloseState otherState = (ConnectionCloseState)other;
                if (this.closeConnectionIds == null) {
                    this.closeConnectionIds = new TLongArrayList();
                    this.closeConnectionIds.add(this.closeConnectionId);
                }
                if (otherState.closeConnectionIds == null) {
                    this.closeConnectionIds.add(otherState.closeConnectionId);
                } else {
                    this.closeConnectionIds.add(otherState.closeConnectionIds);
                }
                return true;
            }
            return false;
        }

        @Override
        public void distribute() {
            block4: {
                try {
                    long[] connIDs = this.closeConnectionIds != null ? this.closeConnectionIds.toNativeArray() : new long[]{this.closeConnectionId};
                    Set<DistributedMember> otherMembers = GfxdMessage.getOtherServers();
                    if (otherMembers.size() > 0) {
                        FunctionService.onMembers(otherMembers).withArgs((Object)connIDs).execute("gfxd-DistributedConnectionCloseExecutorFunction");
                    }
                }
                catch (CancelException ex) {
                    throw ex;
                }
                catch (Throwable t) {
                    LogWriterI18n logger = Misc.getI18NLogWriter();
                    if (logger == null || !logger.warningEnabled()) break block4;
                    logger.warning(LocalizedStrings.CONNECTION_CHANGE_PROCESS_FAILED, t);
                }
            }
        }

        @Override
        public int numChanges() {
            if (this.closeConnectionIds != null) {
                return this.closeConnectionIds.size();
            }
            return 1;
        }

        @Override
        public int minBatchSize() {
            return 5;
        }

        @Override
        public long waitMillis() {
            return 500L;
        }

        public String toString() {
            return this.getClass().getName() + ": " + (this.closeConnectionIds != null ? this.closeConnectionIds.toString() : Long.valueOf(this.closeConnectionId));
        }
    }
}

