/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.internal.DSFIDFactory;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalRowLocation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.CompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.LocaleFinder;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.BinarySQLHybridType;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.CloneableObject;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactoryImpl;
import com.pivotal.gemfirexd.internal.iapi.types.J2SEDataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.JSON;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongvarchar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLReal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLSmallint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTinyint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.UserType;
import com.pivotal.gemfirexd.internal.iapi.types.XML;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;

public abstract class DataType
implements DataValueDescriptor,
CloneableObject,
Comparable {
    @Override
    public boolean getBoolean() throws StandardException {
        throw this.dataTypeConversion("boolean");
    }

    @Override
    public byte getByte() throws StandardException {
        throw this.dataTypeConversion("byte");
    }

    @Override
    public short getShort() throws StandardException {
        throw this.dataTypeConversion("short");
    }

    @Override
    public int getInt() throws StandardException {
        throw this.dataTypeConversion("int");
    }

    @Override
    public long getLong() throws StandardException {
        throw this.dataTypeConversion("long");
    }

    @Override
    public float getFloat() throws StandardException {
        throw this.dataTypeConversion("float");
    }

    @Override
    public double getDouble() throws StandardException {
        throw this.dataTypeConversion("double");
    }

    @Override
    public int typeToBigDecimal() throws StandardException {
        throw this.dataTypeConversion("java.math.BigDecimal");
    }

    @Override
    public byte[] getBytes() throws StandardException {
        throw this.dataTypeConversion("byte[]");
    }

    @Override
    public Date getDate(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Date");
    }

    @Override
    public Time getTime(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Time");
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        throw this.dataTypeConversion("java.sql.Timestamp");
    }

    @Override
    public InputStream getStream() throws StandardException {
        throw this.dataTypeConversion(MessageService.getTextMessage("42Z11.U"));
    }

    @Override
    public String getTraceString() throws StandardException {
        return this.getString();
    }

    @Override
    public DataValueDescriptor recycle() {
        this.restoreToNull();
        return this;
    }

    @Override
    public final BooleanDataValue isNullOp() {
        return SQLBoolean.truthValue(this.isNull());
    }

    @Override
    public final BooleanDataValue isNotNull() {
        return SQLBoolean.truthValue(!this.isNull());
    }

    @Override
    public void setValue(Time theValue) throws StandardException {
        this.setValue(theValue, (Calendar)null);
    }

    @Override
    public void setValue(Time theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Time");
    }

    @Override
    public void setValue(Timestamp theValue) throws StandardException {
        this.setValue(theValue, (Calendar)null);
    }

    @Override
    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Timestamp");
    }

    @Override
    public void setValue(Date theValue) throws StandardException {
        this.setValue(theValue, (Calendar)null);
    }

    @Override
    public void setValue(Date theValue, Calendar cal) throws StandardException {
        this.throwLangSetMismatch("java.sql.Date");
    }

    @Override
    public void setValue(Object theValue) throws StandardException {
        this.throwLangSetMismatch("java.lang.Object");
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.throwLangSetMismatch("java.lang.String");
    }

    @Override
    public void setValue(Blob theValue) throws StandardException {
        this.throwLangSetMismatch("java.sql.Blob");
    }

    @Override
    public void setValue(Clob theValue) throws StandardException {
        this.throwLangSetMismatch("java.sql.Clob");
    }

    @Override
    public void setValue(int theValue) throws StandardException {
        this.throwLangSetMismatch("int");
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        this.throwLangSetMismatch("double");
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        this.throwLangSetMismatch("float");
    }

    @Override
    public void setValue(short theValue) throws StandardException {
        this.throwLangSetMismatch("short");
    }

    @Override
    public void setValue(long theValue) throws StandardException {
        this.throwLangSetMismatch("long");
    }

    @Override
    public void setValue(byte theValue) throws StandardException {
        this.throwLangSetMismatch("byte");
    }

    @Override
    public void setValue(boolean theValue) throws StandardException {
        this.throwLangSetMismatch("boolean");
    }

    @Override
    public void setValue(byte[] theValue) throws StandardException {
        this.throwLangSetMismatch("byte[]");
    }

    @Override
    public void setBigDecimal(Number bigDecimal) throws StandardException {
        this.throwLangSetMismatch("java.math.BigDecimal");
    }

    @Override
    public final void setValue(DataValueDescriptor dvd) throws StandardException {
        if (dvd.isNull()) {
            this.setToNull();
            return;
        }
        try {
            this.setFrom(dvd);
        }
        catch (StandardException se) {
            String msgId = se.getMessageId();
            if ("22003".equals(msgId)) {
                throw this.outOfRange();
            }
            if ("22018".equals(msgId)) {
                throw this.invalidFormat();
            }
            throw se;
        }
    }

    protected void setFrom(DataValueDescriptor dvd) throws StandardException {
        throw StandardException.newException("0A000.S");
    }

    @Override
    public void setToNull() {
        this.restoreToNull();
    }

    @Override
    public void setObjectForCast(Object theValue, boolean instanceOfResultType, String resultTypeClassName) throws StandardException {
        if (theValue == null) {
            this.setToNull();
            return;
        }
        if (!instanceOfResultType) {
            throw StandardException.newException("XCL12.S", (Object)theValue.getClass().getName(), (Object)this.getTypeName(resultTypeClassName), (Object)null);
        }
        this.setObject(theValue);
    }

    void setObject(Object theValue) throws StandardException {
        this.genericSetObject(theValue);
    }

    String getTypeName(String className) {
        return this.getTypeName();
    }

    @Override
    public Object getObject() throws StandardException {
        throw this.dataTypeConversion("java.lang.Object");
    }

    void genericSetObject(Object theValue) throws StandardException {
        this.throwLangSetMismatch(theValue);
    }

    @Override
    public Object cloneObject() {
        return this.getClone();
    }

    protected String getNationalString(LocaleFinder localeFinder) throws StandardException {
        return this.getString();
    }

    public void throwLangSetMismatch(Object value) throws StandardException {
        this.throwLangSetMismatch(value.getClass().getName());
    }

    void throwLangSetMismatch(String argTypeName) throws StandardException {
        throw StandardException.newException("XCL12.S", (Object)argTypeName, (Object)this.getTypeName(), (Object)null);
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setObject(position, this.getObject());
    }

    @Override
    public void setInto(ResultSet rs, int position) throws SQLException, StandardException {
        rs.updateObject(position, this.getObject());
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.setValue(source);
    }

    @Override
    public int typePrecedence() {
        return -1;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) == 0);
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) != 0);
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) < 0);
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) > 0);
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) <= 0);
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.compare(right) >= 0);
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return other.compare(DataType.flip(op), this, orderedNulls, unknownRV);
        }
        int result = this.compare(other);
        switch (op) {
            case 1: {
                return result < 0;
            }
            case 2: {
                return result == 0;
            }
            case 3: {
                return result <= 0;
            }
            case 4: {
                return result > 0;
            }
            case 5: {
                return result >= 0;
            }
        }
        SanityManager.THROWASSERT((String)"Invalid Operator");
        return false;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean nullsOrderedLow, boolean unknownRV) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return other.compare(DataType.flip(op), this, orderedNulls, nullsOrderedLow, unknownRV);
        }
        int result = this.compare(other, nullsOrderedLow);
        switch (op) {
            case 1: {
                return result < 0;
            }
            case 2: {
                return result == 0;
            }
            case 3: {
                return result <= 0;
            }
            case 4: {
                return result > 0;
            }
            case 5: {
                return result >= 0;
            }
        }
        SanityManager.THROWASSERT((String)"Invalid Operator");
        return false;
    }

    @Override
    public int compare(DataValueDescriptor other, boolean nullsOrderedLow) throws StandardException {
        if (this.isNull() || other.isNull()) {
            if (!this.isNull()) {
                return nullsOrderedLow ? 1 : -1;
            }
            if (!other.isNull()) {
                return nullsOrderedLow ? -1 : 1;
            }
            return 0;
        }
        return this.compare(other);
    }

    public int compareTo(Object otherDVD) {
        DataValueDescriptor other = (DataValueDescriptor)otherDVD;
        try {
            if (this.typePrecedence() < other.typePrecedence()) {
                return -Integer.signum(other.compare(this));
            }
            return this.compare(other);
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((String)("Encountered error while trying to compare two DataValueDescriptors: " + se.getMessage()));
            return 0;
        }
    }

    protected static int flip(int operator) {
        switch (operator) {
            case 1: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 2: {
                return 2;
            }
        }
        SanityManager.THROWASSERT((String)"Attempting to flip an operator that is not expected to be flipped.");
        return operator;
    }

    @Override
    public DataValueDescriptor coalesce(DataValueDescriptor[] argumentsList, DataValueDescriptor returnValue) throws StandardException {
        SanityManager.ASSERT((argumentsList != null ? 1 : 0) != 0, (String)"argumentsList expected to be non-null");
        SanityManager.ASSERT((argumentsList.length > 1 ? 1 : 0) != 0, (String)"argumentsList.length expected to be > 1");
        for (int index = 0; index < argumentsList.length; ++index) {
            if (argumentsList[index].isNull()) continue;
            returnValue.setValue(argumentsList[index]);
            return returnValue;
        }
        returnValue.setToNull();
        return returnValue;
    }

    @Override
    public BooleanDataValue in(DataValueDescriptor left, DataValueDescriptor[] inList, boolean orderedList) throws StandardException {
        BooleanDataValue stop;
        BooleanDataValue retval = null;
        SanityManager.ASSERT((inList != null ? 1 : 0) != 0, (String)"inList expected to be non-null");
        SanityManager.ASSERT((inList.length > 0 ? 1 : 0) != 0, (String)"inList.length expected to be > 0");
        if (left.isNull()) {
            return SQLBoolean.truthValue(left, inList[0], false);
        }
        int start = 0;
        int finish = inList.length;
        int leftPrecedence = left.typePrecedence();
        DataValueDescriptor comparator = null;
        if (orderedList) {
            while (finish - start > 2) {
                int mid = (finish - start) / 2 + start;
                comparator = leftPrecedence < inList[mid].typePrecedence() ? inList[mid] : left;
                retval = comparator.equals(left, inList[mid]);
                if (retval.equals(true)) {
                    return retval;
                }
                BooleanDataValue goLeft = comparator.greaterThan(inList[mid], left);
                if (goLeft.equals(true)) {
                    finish = mid;
                    continue;
                }
                start = mid;
            }
        }
        for (int index = start; !(index >= finish || (retval = (comparator = leftPrecedence < inList[index].typePrecedence() ? inList[index] : left).equals(left, inList[index])).equals(true) || orderedList && (stop = comparator.greaterThan(inList[index], left)).equals(true)); ++index) {
        }
        return retval;
    }

    public boolean equals(Object other) {
        if (!(other instanceof DataValueDescriptor)) {
            return false;
        }
        if (other instanceof RowLocation) {
            return false;
        }
        try {
            return this.compare(2, (DataValueDescriptor)other, true, false);
        }
        catch (StandardException se) {
            return false;
        }
    }

    @Override
    public void setValue(InputStream theStream, int valueLength) throws StandardException {
        this.throwLangSetMismatch("java.io.InputStream");
    }

    @Override
    public void checkHostVariable(int declaredLength) throws StandardException {
    }

    protected final StandardException dataTypeConversion(String targetType) {
        return StandardException.newException("22005", (Object)targetType, (Object)this.getTypeName(), (Object)null);
    }

    protected final StandardException outOfRange() {
        return StandardException.newException("22003", (Object)this.getTypeName(), (Object)null);
    }

    protected final StandardException invalidFormat() {
        return StandardException.newException("22018", (Object)this.getTypeName(), (Object)null);
    }

    public static void writeDVDArray(DataValueDescriptor[] array, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut((DataOutput)out);
        int length = array == null ? -1 : array.length;
        InternalDataSerializer.writeArrayLength((int)length, (DataOutput)out);
        if (DataSerializer.DEBUG) {
            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Writing DataValueDescriptor array of length " + length));
        }
        if (length > 0) {
            for (DataValueDescriptor dvd : array) {
                if (dvd != null) {
                    dvd.toData(out);
                    continue;
                }
                out.writeByte(41);
                out.writeByte(41);
            }
        }
    }

    public static DataValueDescriptor[] readDVDArray(DataInput in) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn((DataInput)in);
        int length = InternalDataSerializer.readArrayLength((DataInput)in);
        if (length == -1) {
            return null;
        }
        if (DataSerializer.DEBUG || GemFireXDUtils.TraceTempFileIO) {
            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Read DataValueDescriptor array of length " + length));
        }
        DataValueDescriptor[] array = new DataValueDescriptor[length];
        for (int i = 0; i < length; ++i) {
            array[i] = DataType.readDVD(in);
            if (!GemFireXDUtils.TraceTempFileIO) continue;
            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Read " + array[i] + "(" + array[i].getTypeName() + ")"));
        }
        return array;
    }

    public static void writeDVDCollection(Collection<?> coll, DataOutput out) throws IOException {
        InternalDataSerializer.checkOut((DataOutput)out);
        int length = coll == null ? -1 : coll.size();
        InternalDataSerializer.writeArrayLength((int)length, (DataOutput)out);
        if (DataSerializer.DEBUG) {
            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Writing DataValueDescriptor array of length " + length));
        }
        if (length > 0) {
            for (Object dvd : coll) {
                if (dvd != null) {
                    ((DataValueDescriptor)dvd).toData(out);
                    continue;
                }
                out.writeByte(41);
                out.writeByte(41);
            }
        }
    }

    public static <C extends Collection> C readDVDCollection(DataInput in, InternalDataSerializer.CollectionCreator<C> ctr) throws IOException, ClassNotFoundException {
        InternalDataSerializer.checkIn((DataInput)in);
        int length = InternalDataSerializer.readArrayLength((DataInput)in);
        if (length == -1) {
            return null;
        }
        if (DataSerializer.DEBUG || GemFireXDUtils.TraceTempFileIO) {
            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Read DataValueDescriptor array of length " + length));
        }
        Collection coll = ctr.newCollection(length);
        for (int i = 0; i < length; ++i) {
            DataValueDescriptor dvd = DataType.readDVD(in);
            coll.add(dvd);
            if (!GemFireXDUtils.TraceTempFileIO) continue;
            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Read " + dvd + "(" + dvd.getTypeName() + ")"));
        }
        return (C)coll;
    }

    public static void init() {
        DataSerializer ds = new DataSerializer(){

            public final int getId() {
                return 0;
            }

            public final Class[] getSupportedClasses() {
                return null;
            }

            public final Object fromData(DataInput in) throws IOException, ClassNotFoundException {
                return DataType.readDVDArray(in);
            }

            public final boolean toData(Object o, DataOutput out) throws IOException {
                DataValueDescriptor[] array = (DataValueDescriptor[])o;
                out.writeByte(90);
                DataType.writeDVDArray(array, out);
                return true;
            }
        };
        InternalDataSerializer.getClassesToSerializers().put("[Lcom.gemstone.gemfirexd.internal.iapi.types.DataValueDescriptor;", ds);
        InternalDataSerializer.registerDVDDeserializer((DataSerializer)ds);
        DSFIDFactory.registerDVDDeserializer((DSFIDFactory.DeserializeDVD)new DSFIDFactory.DeserializeDVD(){

            public DataSerializableFixedID getDSFID(DataInput in) throws IOException, ClassNotFoundException {
                return DataType.readDVD(in);
            }

            public DataSerializableFixedID getGlobalRowLocation(DataInput in) throws IOException, ClassNotFoundException {
                GlobalRowLocation rowLocation = new GlobalRowLocation();
                rowLocation.fromData(in);
                return rowLocation;
            }

            public DataSerializableFixedID getGemFireKey(DataInput in) throws IOException, ClassNotFoundException {
                CompositeRegionKey key = new CompositeRegionKey();
                key.fromData(in);
                return key;
            }

            public DataSerializableFixedID getGfxdFormatibleBitSet(DataInput in) throws IOException, ClassNotFoundException {
                FormatableBitSet fbitset = new FormatableBitSet();
                fbitset.fromData(in);
                return fbitset;
            }
        });
    }

    public static DataValueDescriptor readNullDVD(byte typeId, DataInput in) throws IOException, ClassNotFoundException {
        switch (typeId) {
            case 53: {
                return new SQLBoolean();
            }
            case 61: {
                return new SQLDate();
            }
            case 60: {
                return new SQLDouble();
            }
            case 57: {
                return new SQLInteger();
            }
            case 58: {
                return new SQLLongint();
            }
            case 59: {
                return new SQLReal();
            }
            case 56: {
                return new SQLSmallint();
            }
            case 68: {
                return new SQLTime();
            }
            case 21: {
                return new SQLTimestamp();
            }
            case 55: {
                return new SQLTinyint();
            }
            case 24: {
                return new SQLDecimal();
            }
            case 46: {
                short formatId = in.readShort();
                return DataValueFactoryImpl.getNullDVDWithUCS_BASICcollation(formatId);
            }
            case 27: {
                return new SQLChar();
            }
            case 42: {
                return new SQLVarchar();
            }
            case 89: {
                return new SQLLongvarchar();
            }
            case 88: {
                return new SQLClob();
            }
            case 103: {
                return new JSON();
            }
            case 92: {
                return new XML();
            }
            case 39: {
                return new UserType();
            }
            case 1: {
                try {
                    return new J2SEDataValueFactory().getNull(in.readShort(), 0);
                }
                catch (StandardException ex) {
                    throw GemFireXDRuntimeException.newRuntimeException("DataType#readNullDVD: unexpected exception", ex);
                }
            }
            case 41: {
                return null;
            }
            case 66: {
                return new DVDSet();
            }
        }
        throw new GemFireXDRuntimeException("DataType#readNullDVD: unexpected typeId=" + typeId);
    }

    @Override
    public byte getTypeId() {
        throw new UnsupportedOperationException("Implement the method for DataType=" + this);
    }

    @Override
    public void writeNullDVD(DataOutput out) throws IOException {
        out.writeByte(41);
        out.writeByte(this.getTypeId());
    }

    public static DataValueDescriptor readDVD(DataInput in) throws IOException, ClassNotFoundException {
        byte typeId = in.readByte();
        if (typeId == 41) {
            return DataType.readNullDVD(in.readByte(), in);
        }
        DataValueDescriptor dvd = DataType.readNullDVD(typeId, in);
        dvd.fromData(in);
        return dvd;
    }

    public static void readDVD(DataInput in, DataValueDescriptor dvd) throws IOException, ClassNotFoundException {
        byte typeId = in.readByte();
        boolean isNull = false;
        if (typeId == 41) {
            typeId = in.readByte();
            isNull = true;
        }
        if (typeId == 46 || typeId == 1) {
            in.readShort();
        }
        if (!isNull) {
            dvd.fromData(in);
        }
    }

    public final int getDSFID() {
        return -19;
    }

    public void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(1);
            out.writeShort(this.getTypeFormatId());
            this.toDataForOptimizedResultHolder(out);
            return;
        }
        out.writeByte(41);
        out.writeByte(1);
        out.writeShort(this.getTypeFormatId());
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.fromDataForOptimizedResultHolder(in);
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        return this.getLength();
    }

    public void setRegionContext(LocalRegion region) {
    }

    public final KeyWithRegionContext beforeSerializationWithValue(boolean valueIsToken) {
        return this;
    }

    public final void afterDeserializationWithValue(Object val) {
    }

    @Override
    public final int nCols() {
        return 1;
    }

    @Override
    public DataValueDescriptor getKeyColumn(int index) {
        SanityManager.ASSERT((index == 0 ? 1 : 0) != 0);
        return this;
    }

    @Override
    public void getKeyColumns(DataValueDescriptor[] keys) {
        keys[0] = this;
    }

    @Override
    public void getKeyColumns(Object[] keys) throws StandardException {
        keys[0] = this.getObject();
    }

    @Override
    public boolean compare(int op, ExecRow row, boolean byteArrayStore, int logicalPosition, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (byteArrayStore) {
            return BinarySQLHybridType.compare(op, (AbstractCompactExecRow)row, (DataValueDescriptor)this, null, 0L, logicalPosition, orderedNulls, unknownRV);
        }
        DataValueDescriptor columnValue = row.getColumn(logicalPosition);
        return columnValue.compare(op, this, orderedNulls, unknownRV);
    }

    @Override
    public boolean compare(int op, CompactCompositeKey key, int logicalPosition, boolean orderedNulls, boolean unknownRV) throws StandardException {
        return BinarySQLHybridType.compare(op, key, (DataValueDescriptor)this, null, 0L, logicalPosition, orderedNulls, unknownRV);
    }

    protected static final boolean applyOp(int result, int op) {
        switch (op) {
            case 1: {
                return result < 0;
            }
            case 2: {
                return result == 0;
            }
            case 3: {
                return result <= 0;
            }
            case 4: {
                return result > 0;
            }
            case 5: {
                return result >= 0;
            }
        }
        SanityManager.THROWASSERT((String)"Invalid Operator");
        return false;
    }

    @Override
    public boolean canCompareBytesToBytes() {
        return false;
    }

    @Override
    public int equals(RowFormatter rf, byte[] bytes, boolean isKeyBytes, int logicalPosition, int keyBytesPos, DataValueDescriptor[] outDVD) throws StandardException {
        throw new InternalGemFireError("needs implementation for class " + this.getClass().getName());
    }

    public Version[] getSerializationVersions() {
        return null;
    }
}

