/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import java.io.PrintStream;
import java.util.Properties;

public class JDBCBoot {
    private Properties bootProperties = new Properties();
    private static final String NETWORK_SERVER_AUTOSTART_CLASS_NAME = "com.pivotal.gemfirexd.internal.iapi.jdbc.DRDAServerStarter";

    void addProperty(String name, String value) {
        this.bootProperties.put(name, value);
    }

    public void boot(String protocol, PrintStream logging) {
        if (InternalDriver.activeDriver() == null) {
            this.addProperty("gemfirexd.service.jdbc", "com.pivotal.gemfirexd.internal.jdbc.InternalDriver");
            Monitor.startMonitor(this.bootProperties, logging);
            if (Boolean.valueOf(PropertyUtil.getSystemProperty("gemfirexd.drda.startNetworkServer")).booleanValue()) {
                try {
                    Monitor.startSystemModule(NETWORK_SERVER_AUTOSTART_CLASS_NAME);
                }
                catch (StandardException se) {
                    Monitor.logTextMessage("J102", se.getMessage());
                }
            }
        }
    }
}

