/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store.offheap;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public final class OffHeapRowWithLobs
extends OffHeapByteSource {
    public static final SimpleMemoryAllocatorImpl.ChunkType TYPE = new SimpleMemoryAllocatorImpl.ChunkType(){

        public int getSrcType() {
            return 0x8000000;
        }

        public SimpleMemoryAllocatorImpl.Chunk newChunk(long memoryAddress) {
            return new OffHeapRowWithLobs(memoryAddress);
        }

        public SimpleMemoryAllocatorImpl.Chunk newChunk(long memoryAddress, int chunkSize) {
            return new OffHeapRowWithLobs(memoryAddress, chunkSize);
        }
    };
    private int numLobColumns = 0;
    private static final int LOB_COLUMNS_MASK = 0x3FFFFFFF;
    private static final int LOB_COLUMN_WIDTH_SHIFT = 30;
    public static int LOB_ADDRESS_WIDTH = 8;

    public static int calcExtraChunkBytes(int numLobs) {
        return OffHeapRowWithLobs.getUnsignedCompactIntNumBytes(numLobs) + numLobs * LOB_ADDRESS_WIDTH;
    }

    private static int calcInMemoryNumLobCols(int numLobs, int lobWidth) {
        int result = numLobs;
        return result |= --lobWidth << 30;
    }

    private OffHeapRowWithLobs(long address, int chunkSize) {
        super(address, chunkSize, TYPE);
    }

    private OffHeapRowWithLobs(long address) {
        super(address);
        this.initNumLobColumns();
    }

    public void initNumLobColumns() {
        long lobCountAddress = this.getBaseDataAddress() + (long)this.getDataSize() - 1L;
        int numLobs = OffHeapRowWithLobs.readCompactNumLobs(lobCountAddress);
        int lobWidth = OffHeapRowWithLobs.getUnsignedCompactIntNumBytes(numLobs);
        this.numLobColumns = OffHeapRowWithLobs.calcInMemoryNumLobCols(numLobs, lobWidth);
    }

    public void setNumLobs(int numLobs) {
        if (numLobs <= 0) {
            throw new IllegalStateException("numLobs must be > 0 but it was " + numLobs);
        }
        if (numLobs > 0x3FFFFFFF) {
            throw new IllegalStateException("numLobs must be less than or equal to 1073741823but it was " + numLobs);
        }
        int lobWidth = this.writeCompactNumLobs(numLobs);
        this.numLobColumns = OffHeapRowWithLobs.calcInMemoryNumLobCols(numLobs, lobWidth);
    }

    private int writeCompactNumLobs(int numLobs) {
        int offset = this.getDataSize() - 1;
        int numBytes = 1;
        while (true) {
            if ((numLobs & 0xFFFFFF80) == 0) {
                this.writeByte(offset--, (byte)(numLobs & 0x7F));
                return numBytes;
            }
            this.writeByte(offset--, (byte)(numLobs & 0x7F | 0x80));
            numLobs >>>= 7;
            ++numBytes;
        }
    }

    private static int readCompactNumLobs(long bsAddr) {
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        byte b = unsafe.getByte(bsAddr);
        int result = b & 0x7F;
        int count = 0;
        while ((b & 0x80) != 0) {
            if (count > 4) {
                throw new GemFireXDRuntimeException("Malformed variable length integer");
            }
            b = unsafe.getByte(--bsAddr);
            result <<= 7;
            result |= b & 0x7F;
            ++count;
        }
        return result;
    }

    @Override
    public Object getDeserializedValue(Region r, RegionEntry re) {
        return this;
    }

    @Override
    public Object getValueAsDeserializedHeapObject() {
        return this.getRowByteArrays();
    }

    @Override
    public byte[] getValueAsHeapByteArray() {
        return this.getRawBytes();
    }

    public int getSizeInBytes() {
        int size = super.getSizeInBytes();
        int numLobs = this.readNumLobsColumns(false);
        for (int i = 1; i <= numLobs; ++i) {
            long address = this.readAddressForLob(i);
            if (address == 0L || !OffHeapRegionEntryHelper.isOffHeap((long)address)) continue;
            size += SimpleMemoryAllocatorImpl.Chunk.getSize((long)address);
        }
        return size;
    }

    @Override
    public boolean isWithLobs() {
        return true;
    }

    @Override
    public final int readNumLobsColumns(boolean throwExceptionOnWrongSource) {
        return this.numLobColumns & 0x3FFFFFFF;
    }

    @Override
    public final int getOffsetAdjustment() {
        return (this.numLobColumns & 0x3FFFFFFF) * LOB_ADDRESS_WIDTH;
    }

    @Override
    public final long getUnsafeAddress(int offset, int size) {
        return super.getUnsafeBaseAddress(offset + this.getOffsetAdjustment(), size);
    }

    @Override
    public final long getUnsafeAddress() {
        return this.memoryAddress + 8L + (long)this.getOffsetAdjustment();
    }

    @Override
    public final int getLength() {
        int lobColWidth = this.numLobColumns & 0xC0000000;
        lobColWidth >>= 30;
        return OffHeapRowWithLobs.getDataSize((UnsafeWrapper)UnsafeMemoryChunk.getUnsafeWrapper(), (long)this.memoryAddress) - this.getOffsetAdjustment() - ++lobColWidth;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("OffHeapRowWithLobs.toData: serializing offheap byte source=" + (Object)((Object)this)));
        }
        UnsafeWrapper unsafe = UnsafeMemoryChunk.getUnsafeWrapper();
        int numArrays = this.readNumLobsColumns(false) + 1;
        int baseRowLen = this.getLength();
        if (numArrays > 1 || baseRowLen > 0) {
            InternalDataSerializer.writeArrayLength((int)numArrays, (DataOutput)out);
            OffHeapRowWithLobs.serializeBaseRowBytes(unsafe, this.getBaseDataAddress() + (long)this.getOffsetAdjustment(), baseRowLen, out);
            for (int index = 1; index < numArrays; ++index) {
                this.serializeGfxdBytes(index, out);
            }
        } else {
            InternalDataSerializer.writeArrayLength((int)-1, (DataOutput)out);
        }
        SimpleMemoryAllocatorImpl.getAllocator().getStats().incReads();
    }

    @Override
    public void sendTo(DataOutput out) throws IOException {
        out.writeByte(91);
        this.toData(out);
    }

    @Override
    protected byte[] getRawBytes() {
        return EntryEventImpl.serialize((Object)((Object)this));
    }

    private void writeLong(int offset, long value) {
        UnsafeMemoryChunk.writeAbsoluteLongVolatile((long)(this.getBaseDataAddress() + (long)offset), (long)value);
    }

    public void setLobAddress(int i, long address) {
        this.writeLong((i - 1) * LOB_ADDRESS_WIDTH, address);
    }

    public int getLobDataSizeLength(int index) {
        long address = this.readAddressForLob(index);
        if (address != 0L && OffHeapRegionEntryHelper.isOffHeap((long)address)) {
            return SimpleMemoryAllocatorImpl.Chunk.getSize((long)address);
        }
        return 0;
    }

    @Override
    public final long readAddressForLob(int index) {
        assert (index >= 1 && index <= this.readNumLobsColumns(true)) : "index=" + index + " numLobs=" + this.readNumLobsColumns(true);
        return UnsafeMemoryChunk.readAbsoluteLongVolatile((long)(this.getBaseDataAddress() + (long)((index - 1) * LOB_ADDRESS_WIDTH)));
    }

    @Override
    public final long readAddressForLobIfPresent(int index) {
        return this.readAddressForLob(index);
    }

    public static void freeLobsIfPresent(long parentAddress, SimpleMemoryAllocatorImpl.ChunkType ct, int dataSizeDelta) {
        if (ct == TYPE) {
            int dataSize = OffHeapRowWithLobs.getSize((long)parentAddress) - dataSizeDelta;
            long startLocation = parentAddress + 8L;
            int numLobCols = OffHeapRowWithLobs.readCompactNumLobs(startLocation + (long)dataSize - 1L);
            int i = 1;
            while (i <= numLobCols) {
                long address = UnsafeMemoryChunk.readAbsoluteLongVolatile((long)startLocation);
                if (address != 0L && OffHeapRegionEntryHelper.isOffHeap((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)false);
                }
                ++i;
                startLocation += (long)LOB_ADDRESS_WIDTH;
            }
        }
    }

    @Override
    public String toString() {
        String string = this.toStringForOffHeapByteSource();
        byte[][] bytesbytes = this.getRowByteArrays();
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        int i = 0;
        for (byte[] bytes : bytesbytes) {
            sb.append("<").append(i).append("th row bytes=");
            if (bytes != null) {
                sb.append(Arrays.toString(bytes));
            } else {
                sb.append("null");
            }
            sb.append(">");
            ++i;
        }
        return sb.toString();
    }
}

