/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.reflect.GemFireActivationClass;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ActivationStatisticsVisitor;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

public class GemFireSelectActivation
extends AbstractGemFireActivation {
    private final SelectQueryInfo selectQI;
    private final ExecRow projExecRow;
    private final boolean forUpdate;

    public GemFireSelectActivation(ExecPreparedStatement st, LanguageConnectionContext _lcc, DMLQueryInfo qi, GemFireActivationClass gc, boolean forUpdate) throws StandardException {
        super(st, _lcc, qi);
        this.selectQI = (SelectQueryInfo)qi;
        this.projExecRow = this.selectQI.getProjectionExecRow();
        this.forUpdate = forUpdate;
    }

    @Override
    protected void executeWithResultSet(AbstractGemFireResultSet rs) throws StandardException {
        if (this.observer != null) {
            this.observer.beforeGemFireResultSetExecuteOnActivation(this);
            this.observer.afterGemFireResultSetExecuteOnActivation(this);
        }
    }

    @Override
    protected AbstractGemFireResultSet createResultSet(int resultSetNum) throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        if (this.getHasQueryHDFS()) {
            return new GemFireResultSet(this, null, resultSetNum, -1, -1, -1, -1, -1, -1, 0, this.forUpdate, this.selectQI, lcc.getActiveStats(), true, this.getQueryHDFS());
        }
        return new GemFireResultSet(this, null, resultSetNum, -1, -1, -1, -1, -1, -1, 0, this.forUpdate, this.selectQI, lcc.getActiveStats(), true, lcc.getQueryHDFS());
    }

    @Override
    public final ExecRow getProjectionExecRow() throws StandardException {
        return this.projExecRow;
    }

    @Override
    public final void resetProjectionExecRow() throws StandardException {
        DataValueDescriptor[] dvds;
        for (DataValueDescriptor dvd : dvds = this.projExecRow.getRowArray()) {
            dvd.setToNull();
        }
    }

    @Override
    public void accept(ActivationStatisticsVisitor visitor) {
        visitor.visit(this);
    }
}

