/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.utils;

import com.gemstone.gemfire.internal.lang.StringUtils;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileUtils {
    private static final Logger logger = LoggerFactory.getLogger(LogFileUtils.class);
    private static final long defaultBytes = 102400L;

    public static Map<String, Object> getLog(File logDir, String logFile) {
        return LogFileUtils.getLog(logDir, logFile, null, 102400L);
    }

    public static Map<String, Object> getLog(File logDir, String logFile, Long offset, Long byteLength) {
        HashMap<String, Object> logsMap = new HashMap<String, Object>();
        if (logFile == null || StringUtils.isEmpty((String)logFile)) {
            logger.error("Unable to get log file.." + logFile);
            logsMap.put("logText", "Unable to get log file : " + logFile);
            logsMap.put("startIndex", 0L);
            logsMap.put("endIndex", 0L);
            logsMap.put("totalLength", 0L);
            return logsMap;
        }
        try {
            File[] files = LogFileUtils.getSortedFiles(logFile, logDir);
            Long[] fileLengths = new Long[files.length];
            Long totalLength = 0L;
            for (int i = 0; i < files.length; ++i) {
                fileLengths[i] = files[i].length();
                totalLength = totalLength + files[i].length();
            }
            if (byteLength == null) {
                byteLength = 102400L;
            }
            if (offset == null) {
                offset = totalLength - byteLength;
            }
            Long startIndex = offset < 0L ? Long.valueOf(0L) : (offset > totalLength ? totalLength : offset);
            Long endIndex = Math.min(startIndex + byteLength, totalLength);
            logger.debug("Getting log from " + startIndex + " to " + endIndex);
            String logText = LogFileUtils.getOffsetBytes(files, fileLengths, totalLength, startIndex, endIndex);
            logger.debug("Got log of length " + logText.length() + " bytes");
            logsMap.put("logText", logText);
            logsMap.put("startIndex", startIndex);
            logsMap.put("endIndex", endIndex);
            logsMap.put("totalLength", totalLength);
        }
        catch (Exception e) {
            logger.error("Error getting logs due to exception: " + e.getMessage(), (Throwable)e);
            logsMap.put("logText", "Error getting logs due to exception: " + e.getMessage());
            logsMap.put("startIndex", 0L);
            logsMap.put("endIndex", 0L);
            logsMap.put("totalLength", 0L);
        }
        return logsMap;
    }

    private static File[] getSortedFiles(final String logFileName, File logDirectory) {
        File[] files = logDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().startsWith(logFileName.toLowerCase());
            }
        });
        Arrays.sort(files, new LogFileComparator(false));
        return files;
    }

    private static String getOffsetBytes(File[] files, Long[] fileLengths, Long totalLength, Long start, Long end) {
        if (files.length != fileLengths.length) {
            logger.debug("Log Files count and their lengths counts are not matching");
            return "Error: Log Files count and their lengths counts are not matching";
        }
        Long startIndex = Math.max(start, 0L);
        Long endIndex = Math.min(end, totalLength);
        int stringBufferSize = (int)(endIndex - startIndex);
        StringBuffer stringBuffer = new StringBuffer(stringBufferSize);
        Long sum = 0L;
        for (int i = 0; i < files.length; ++i) {
            Long effectiveEndIndex;
            Long effectiveStartIndex;
            Long startIndexOfFile = sum;
            Long endIndexOfFile = sum + fileLengths[i];
            logger.debug("Processing file " + files[i] + ", with start index = " + startIndexOfFile + ", end index = " + endIndex);
            if (startIndex <= startIndexOfFile && endIndex >= endIndexOfFile) {
                stringBuffer.append(LogFileUtils.getOffsetBytes(files[i].getAbsolutePath(), fileLengths[i], 0L, fileLengths[i]));
            } else if (startIndex > startIndexOfFile && startIndex < endIndexOfFile) {
                effectiveStartIndex = startIndex - startIndexOfFile;
                effectiveEndIndex = Math.min(endIndex - startIndexOfFile, fileLengths[i]);
                stringBuffer.append(LogFileUtils.getOffsetBytes(files[i].getAbsolutePath(), fileLengths[i], effectiveStartIndex, effectiveEndIndex));
            } else if (endIndex > startIndexOfFile && endIndex < endIndexOfFile) {
                effectiveStartIndex = Math.max(startIndex - startIndexOfFile, 0L);
                effectiveEndIndex = endIndex - startIndexOfFile;
                stringBuffer.append(LogFileUtils.getOffsetBytes(files[i].getAbsolutePath(), fileLengths[i], effectiveStartIndex, effectiveEndIndex));
            }
            sum = sum + fileLengths[i];
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOffsetBytes(String filePath, Long fileLength, Long start, Long end) {
        byte[] buff;
        block20: {
            File file = new File(filePath);
            if (file == null || StringUtils.isEmpty((String)filePath)) {
                logger.debug("File is not specified.." + filePath);
                return "File is not specified..";
            }
            Long effectiveStart = Math.max(0L, start);
            Long effectiveEnd = Math.min(fileLength, end);
            int buffLength = (int)(effectiveEnd - effectiveStart);
            buff = new byte[buffLength];
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                if (fis != null) {
                    ByteStreams.skipFully((InputStream)fis, (long)effectiveStart);
                    ByteStreams.readFully((InputStream)fis, (byte[])buff);
                    break block20;
                }
                logger.debug("Could not read File [ " + filePath + " ]");
                String string = "Could not read File [ " + filePath + " ]";
                return string;
            }
            catch (FileNotFoundException e) {
                logger.error("FileNotFoundException: " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error("IOException: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return new String(buff);
    }

    private static class LogFileComparator
    implements Comparator<File> {
        public static final boolean ASCENDING_ORDER = true;
        public static final boolean DESCENDING_ORDER = false;
        private Boolean isAsceding;

        LogFileComparator() {
            this.isAsceding = true;
        }

        LogFileComparator(Boolean order) {
            this.isAsceding = order;
        }

        @Override
        public int compare(File f1, File f2) {
            int n1 = this.extractNumber(f1.getName());
            int n2 = this.extractNumber(f2.getName());
            return this.isAsceding != false ? n1 - n2 : n2 - n1;
        }

        private int extractNumber(String name) {
            int i;
            try {
                int s = name.indexOf(".log") + 5;
                String number = name.substring(s);
                i = Integer.parseInt(number);
            }
            catch (Exception e) {
                i = 0;
            }
            return i;
        }
    }
}

