/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.metadata;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AbstractConditionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.AndJunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.ColocationCriteria;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.OrJunctionQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import java.util.List;

public abstract class JunctionQueryInfo
extends AbstractConditionQueryInfo {
    static final byte IS_DYNAMIC = 1;
    static final byte IS_STATIC_NOT_CONVERTIBLE = 2;
    static final byte HAS_IN_PRED = 4;
    private byte state = 0;
    JunctionQueryInfo[] children;
    ColocationCriteria colocationCriteria;
    String colocationFailReason;

    JunctionQueryInfo(JunctionQueryInfo jqi1, JunctionQueryInfo jqi2) {
        this.children = new JunctionQueryInfo[2];
        this.children[0] = jqi1;
        this.children[1] = jqi2;
        assert (jqi1.getJunctionType() == jqi2.getJunctionType());
        this.setIsStaticallyNotGetConvertible(true);
        this.setIsDynamic(jqi1.isWhereClauseDynamic() || jqi2.isWhereClauseDynamic());
    }

    JunctionQueryInfo(JunctionQueryInfo jqi) {
        this.children = new JunctionQueryInfo[1];
        this.children[0] = jqi;
        this.setIsStaticallyNotGetConvertible(true);
        this.setIsDynamic(jqi.isWhereClauseDynamic());
    }

    JunctionQueryInfo() {
        this.children = null;
    }

    @Override
    final AbstractConditionQueryInfo mergeOperand(AbstractConditionQueryInfo operand, int operandJunctionType, boolean isTopLevel) throws StandardException {
        if (operand == null) {
            if (this.getJunctionType() == operandJunctionType || isTopLevel) {
                return this;
            }
            return operandJunctionType == 1 ? new AndJunctionQueryInfo(1, this, null) : new OrJunctionQueryInfo(2, this, null);
        }
        return operand.mergeJunctionOperand(this, operandJunctionType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    JunctionQueryInfo mergeJunctionOperand(JunctionQueryInfo junctionOperand, int operandJunctionType) {
        JunctionQueryInfo root = null;
        JunctionQueryInfo localChild = null;
        if (junctionOperand.getJunctionType() == this.getJunctionType()) {
            if (operandJunctionType == this.getJunctionType()) throw new UnsupportedOperationException("Not supported yet");
            return operandJunctionType == 1 ? new AndJunctionQueryInfo(this, junctionOperand) : new OrJunctionQueryInfo(this, junctionOperand);
        }
        if (operandJunctionType == this.getJunctionType()) {
            root = this;
            localChild = junctionOperand;
            if (!root.isStaticallyNotGetConvertible()) {
                root.setIsStaticallyNotGetConvertible(localChild.isStaticallyNotGetConvertible());
            }
        } else if (operandJunctionType == junctionOperand.getJunctionType()) {
            root = junctionOperand;
            localChild = this;
            if (root.getJunctionType() == 2) {
                if (!root.isStaticallyNotGetConvertible()) {
                    root.setIsStaticallyNotGetConvertible(localChild.isStaticallyNotGetConvertible());
                }
            } else {
                root.setIsStaticallyNotGetConvertible(true);
            }
        }
        if (root.children == null) {
            root.children = new JunctionQueryInfo[]{localChild};
        } else {
            JunctionQueryInfo[] newChildren = new JunctionQueryInfo[root.children.length + 1];
            for (int i = 0; i < root.children.length; ++i) {
                JunctionQueryInfo temp = root.children[i];
                assert (temp.getJunctionType() == localChild.getJunctionType());
                newChildren[i] = root.children[i];
            }
            newChildren[i] = localChild;
            root.children = newChildren;
        }
        if (root.isWhereClauseDynamic()) return root;
        root.setIsDynamic(localChild.isWhereClauseDynamic());
        return root;
    }

    @Override
    final boolean isStaticallyNotGetConvertible() {
        return GemFireXDUtils.isSet(this.state, (byte)2);
    }

    final void setIsStaticallyNotGetConvertible(boolean on) {
        this.state = GemFireXDUtils.set(this.state, (byte)2, on);
    }

    final void setIsDynamic(boolean on) {
        this.state = GemFireXDUtils.set(this.state, (byte)1, on);
    }

    final void setHasINPredicate(boolean on) {
        this.state = GemFireXDUtils.set(this.state, (byte)4, on);
    }

    @Override
    public final boolean isWhereClauseDynamic() {
        return GemFireXDUtils.isSet(this.state, (byte)1);
    }

    public final boolean hasINPredicate() {
        return GemFireXDUtils.isSet(this.state, (byte)4);
    }

    abstract int getJunctionType();

    abstract List getOperands();
}

