/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.execution;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.distributed.DVDIOUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.execution.LeadNodeExecutionObject;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import com.pivotal.gemfirexd.internal.snappy.LeadNodeExecutionContext;
import com.pivotal.gemfirexd.internal.snappy.SparkSQLExecute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class SampleInsertExecutionObject
extends LeadNodeExecutionObject {
    private String baseTableName;
    private List<DataValueDescriptor[]> rows = null;
    private byte[] serializedDVDs = null;

    public SampleInsertExecutionObject(String baseTableName, List<DataValueDescriptor[]> rows) {
        this.baseTableName = baseTableName;
        this.rows = rows;
    }

    public SampleInsertExecutionObject() {
    }

    @Override
    public SparkSQLExecute getSparkSQlExecute(Version v, LeadNodeExecutionContext ctx, Object dfOject) throws Exception {
        return CallbackFactoryProvider.getClusterCallbacks().getSampleInsertExecute(this.baseTableName, ctx, v, this.rows, this.serializedDVDs);
    }

    @Override
    public boolean isUpdateOrDeleteOrPut() {
        return true;
    }

    @Override
    public void reset() {
    }

    public byte getGfxdID() {
        return 118;
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.baseTableName, (DataOutput)out);
        int numCols = this.rows.get(0).length;
        int numEightColGroups = numCols / 8 + (numCols % 8 == 0 ? 0 : 1);
        byte numPartCols = (byte)(numCols % 8);
        if (numPartCols == 0) {
            numPartCols = 8;
        }
        int[] dvdTypes = new int[numCols * 3];
        DataValueDescriptor[] row = this.rows.get(0);
        for (int i = 0; i < numCols; ++i) {
            DataValueDescriptor dvd = row[i];
            dvdTypes[i * 3] = dvd.getTypeFormatId();
            if (dvd instanceof SQLDecimal) {
                dvdTypes[i * 3 + 1] = ((SQLDecimal)dvd).getDecimalValuePrecision();
                dvdTypes[i * 3 + 2] = ((SQLDecimal)dvd).getDecimalValueScale();
                continue;
            }
            dvdTypes[i * 3 + 1] = -1;
            dvdTypes[i * 3 + 2] = -1;
        }
        HeapDataOutputStream hdos = new HeapDataOutputStream();
        DataSerializer.writePrimitiveInt((int)numEightColGroups, (DataOutput)hdos);
        DataSerializer.writePrimitiveByte((byte)numPartCols, (DataOutput)hdos);
        DataSerializer.writeIntArray((int[])dvdTypes, (DataOutput)hdos);
        DataSerializer.writePrimitiveInt((int)this.rows.size(), (DataOutput)hdos);
        try {
            for (DataValueDescriptor[] dvds : this.rows) {
                DVDIOUtil.writeDVDArray(dvds, numEightColGroups, numPartCols, (DataOutput)hdos);
            }
        }
        catch (StandardException se) {
            throw new IOException(se);
        }
        InternalDataSerializer.writeArrayLength((int)hdos.size(), (DataOutput)out);
        hdos.sendTo(out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.baseTableName = DataSerializer.readString((DataInput)in);
        this.serializedDVDs = DataSerializer.readByteArray((DataInput)in);
    }

    @Override
    public String getExceptionString() {
        return "";
    }
}

