/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.persistence.query.CloseableIterator;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.distributed.execution.LeadNodeExecutionObject;
import com.pivotal.gemfirexd.internal.engine.distributed.message.LeadNodeExecutorMsg;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBlob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLClob;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLReal;
import com.pivotal.gemfirexd.internal.iapi.types.SQLSmallint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTinyint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import com.pivotal.gemfirexd.internal.snappy.SparkSQLExecute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;

public final class SnappyResultHolder
extends GfxdDataSerializable {
    private transient SparkSQLExecute exec;
    private volatile transient ByteArrayDataInput dis;
    private volatile transient String[] colNames;
    private volatile transient String[] tableNames;
    private volatile transient boolean[] nullability;
    private volatile transient int[] colTypes;
    private volatile transient int[] precisions;
    private volatile transient int[] scales;
    private volatile transient Object[] dataTypes;
    private volatile transient SQLWarning warnings;
    private DataValueDescriptor[] templateDVDRow;
    private Iterator<ValueRow> execRows;
    private DataTypeDescriptor[] dtds;
    private boolean hasMetadata;
    private boolean isUpdateOrDeleteOrPut;
    private boolean interpreterExecution = false;
    private String[] intpOutput;

    public SnappyResultHolder(SparkSQLExecute exec, Boolean isUpdateOrDeleteOrPut) {
        this.exec = exec;
        this.isUpdateOrDeleteOrPut = isUpdateOrDeleteOrPut;
    }

    public SnappyResultHolder(String[] interpreterOutputStrs) {
        this.intpOutput = interpreterOutputStrs;
        this.interpreterExecution = true;
    }

    public SnappyResultHolder() {
    }

    @Override
    public byte getGfxdID() {
        return 110;
    }

    public void setMetadata(SnappyResultHolder other) {
        this.tableNames = other.tableNames;
        this.colNames = other.colNames;
        this.nullability = other.nullability;
        this.colTypes = other.colTypes;
        this.precisions = other.precisions;
        this.scales = other.scales;
        this.dataTypes = other.dataTypes;
        this.warnings = other.warnings;
    }

    public ByteArrayDataInput getByteArrayDataInput() {
        return this.dis;
    }

    public void setHasMetadata() {
        this.hasMetadata = true;
    }

    public void clearHasMetadata() {
        this.hasMetadata = false;
    }

    public boolean hasMetadata() {
        return this.hasMetadata;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        InternalDataSerializer.writeBoolean((Boolean)this.interpreterExecution, (DataOutput)out);
        if (!this.interpreterExecution) {
            this.exec.serializeRows(out, this.hasMetadata);
        } else {
            DataSerializer.writeStringArray((String[])this.intpOutput, (DataOutput)out);
        }
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.interpreterExecution = DataSerializer.readBoolean((DataInput)in);
        if (!this.interpreterExecution) {
            int numBytes = InternalDataSerializer.readArrayLength((DataInput)in);
            if (numBytes > 0) {
                byte[] rawData = DataSerializer.readByteArray((DataInput)in, (int)numBytes);
                Version v = InternalDataSerializer.getVersionForDataStreamOrNull((DataInput)in);
                this.fromSerializedData(rawData, numBytes, v);
            }
        } else {
            this.intpOutput = DataSerializer.readStringArray((DataInput)in);
            this.colNames = new String[]{"C0"};
            this.nullability = new boolean[]{true};
            this.dataTypes = new Object[1];
            this.dtds = new DataTypeDescriptor[]{DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, 10000)};
            this.colTypes = new int[]{85};
        }
    }

    public final void fromSerializedData(byte[] rawData, int numBytes, Version v) throws IOException, ClassNotFoundException {
        ByteArrayDataInput dis = new ByteArrayDataInput();
        dis.initialize(rawData, 0, numBytes, v);
        byte metaInfo = dis.readByte();
        if (metaInfo == 1) {
            this.tableNames = DataSerializer.readStringArray((DataInput)dis);
            this.colNames = DataSerializer.readStringArray((DataInput)dis);
            this.nullability = DataSerializer.readBooleanArray((DataInput)dis);
            int totCols = this.colNames.length;
            this.precisions = new int[totCols];
            this.scales = new int[totCols];
            this.dataTypes = new Object[totCols];
            this.dtds = new DataTypeDescriptor[totCols];
            this.colTypes = new int[totCols];
            for (int i = 0; i < totCols; ++i) {
                int columnType;
                this.colTypes[i] = columnType = (int)InternalDataSerializer.readSignedVL((DataInput)dis);
                if (columnType == 200) {
                    this.precisions[i] = (int)InternalDataSerializer.readSignedVL((DataInput)dis);
                    this.scales[i] = (int)InternalDataSerializer.readSignedVL((DataInput)dis);
                    continue;
                }
                if (columnType == 85 || columnType == 78) {
                    this.precisions[i] = (int)InternalDataSerializer.readSignedVL((DataInput)dis);
                    this.scales[i] = -1;
                    continue;
                }
                if (columnType == 9) {
                    this.dataTypes[i] = CallbackFactoryProvider.getClusterCallbacks().readDataType(dis);
                    this.precisions[i] = -1;
                    this.scales[i] = -1;
                    continue;
                }
                this.precisions[i] = -1;
                this.scales[i] = -1;
            }
            this.warnings = (SQLWarning)DataSerializer.readObject((DataInput)dis);
        }
        this.dis = dis;
    }

    private void makeTemplateDVDArr() {
        if (!this.interpreterExecution) {
            if (this.isUpdateOrDeleteOrPut) {
                DataValueDescriptor[] dvds = new DataValueDescriptor[]{new SQLInteger()};
                this.dtds = new DataTypeDescriptor[1];
                this.dtds[0] = DataTypeDescriptor.getBuiltInDataTypeDescriptor(4, false);
                this.templateDVDRow = dvds;
            } else {
                this.dtds = new DataTypeDescriptor[this.colTypes.length];
                DataValueDescriptor[] dvds = new DataValueDescriptor[this.colTypes.length];
                for (int i = 0; i < this.colTypes.length; ++i) {
                    DataValueDescriptor dvd;
                    int typeId = this.colTypes[i];
                    dvds[i] = dvd = this.getNewNullDVD(typeId, i, this.dtds, this.precisions[i], this.scales[i]);
                }
                this.templateDVDRow = dvds;
            }
        }
    }

    public String[] getColumnNames() {
        return this.colNames;
    }

    public int[] getColumnTypes() {
        return this.colTypes;
    }

    public String[] getTableNames() {
        return this.tableNames;
    }

    public void prepareSend(LeadNodeExecutorMsg msg, LeadNodeExecutionObject execObject) {
        this.exec.packRows(msg, this, execObject);
    }

    public ExecRow getNextRow() {
        if (this.interpreterExecution) {
            return this.getInterpreterNextRow();
        }
        ByteArrayDataInput in = this.dis;
        if (in != null) {
            Iterator<ValueRow> execRows = this.execRows;
            if (execRows == null) {
                if (in.available() > 0) {
                    if (this.templateDVDRow == null) {
                        this.makeTemplateDVDArr();
                    }
                    this.execRows = execRows = CallbackFactoryProvider.getClusterCallbacks().getRowIterator(this.templateDVDRow, this.colTypes, this.precisions, this.scales, this.dataTypes, in);
                } else {
                    this.dis = null;
                    return null;
                }
            }
            if (execRows.hasNext()) {
                return execRows.next();
            }
        }
        this.dis = null;
        return null;
    }

    private ExecRow getInterpreterNextRow() {
        if (this.intpOutput != null) {
            if (this.execRows == null) {
                ArrayList<ValueRow> list = new ArrayList<ValueRow>();
                for (int i = 0; i < this.intpOutput.length; ++i) {
                    ValueRow vr = new ValueRow(1);
                    vr.setColumn(1, new SQLVarchar(this.intpOutput[i]));
                    list.add(vr);
                }
                this.execRows = list.iterator();
            }
            if (this.execRows.hasNext()) {
                ValueRow vr = this.execRows.next();
                return vr;
            }
        }
        return null;
    }

    private DataValueDescriptor getNewNullDVD(int storeType, int colNum, DataTypeDescriptor[] dtds, int precision, int scale) {
        return SnappyResultHolder.getNewNullDVD(storeType, colNum, dtds, precision, scale, this.nullability[colNum]);
    }

    public static DataValueDescriptor getNewNullDVD(int storeType, int colNum, DataTypeDescriptor[] dtds, int precision, int scale, boolean nullable) {
        DataTypeDescriptor dtd;
        DataType dvd;
        switch (storeType) {
            case 31: {
                dvd = new SQLTimestamp();
                int jdbcTypeId = 93;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 77: {
                dvd = new SQLBoolean();
                int jdbcTypeId = 16;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 298: {
                dvd = new SQLDate();
                int jdbcTypeId = 91;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 84: {
                dvd = new SQLLongint();
                int jdbcTypeId = -5;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 83: {
                dvd = new SQLSmallint();
                int jdbcTypeId = 5;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 199: {
                dvd = new SQLTinyint();
                int jdbcTypeId = 4;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 80: {
                dvd = new SQLInteger();
                int jdbcTypeId = 4;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 200: {
                dvd = new SQLDecimal();
                try {
                    dtd = DataTypeDescriptor.getSQLDataTypeDescriptor("java.math.BigDecimal", precision, scale, nullable, precision);
                    break;
                }
                catch (StandardException e) {
                    throw new GemFireXDRuntimeException(e);
                }
            }
            case 81: {
                dvd = new SQLReal();
                int jdbcTypeId = 7;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 79: {
                dvd = new SQLDouble();
                int jdbcTypeId = 8;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 447: {
                dvd = new SQLClob();
                int jdbcTypeId = 2005;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 85: {
                dvd = new SQLVarchar();
                int jdbcTypeId = 12;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable, precision);
                break;
            }
            case 78: {
                dvd = new SQLChar();
                int jdbcTypeId = 1;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable, precision);
                break;
            }
            case 443: {
                dvd = new SQLBlob();
                int jdbcTypeId = 2004;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            case 9: {
                dvd = new SQLClob();
                int jdbcTypeId = 2005;
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId, nullable);
                break;
            }
            default: {
                throw new IllegalStateException("SnappyResultHolder: cannot handle type: " + storeType);
            }
        }
        if (dtds != null) {
            dtds[colNum] = dtd;
        }
        return dvd;
    }

    public DataTypeDescriptor[] getDtds() {
        this.makeTemplateDVDArr();
        return this.dtds;
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public void close() {
        Iterator<ValueRow> execRows = this.execRows;
        if (execRows instanceof CloseableIterator) {
            ((CloseableIterator)execRows).close();
        } else if (execRows instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)execRows)).close();
            }
            catch (Exception e) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)"Exception in SnappyResultHolder.close()", (Throwable)e);
            }
        }
    }
}

