/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.util.ArrayList;
import java.util.Properties;

public final class QueryCancelFunction
implements Function,
Declarable {
    public static final String ID = "gfxd-QueryCancelFunction";

    public void init(Properties props) {
    }

    public boolean hasResult() {
        return false;
    }

    public void execute(FunctionContext context) {
        QueryCancelFunctionArgs args = (QueryCancelFunctionArgs)context.getArguments();
        GfxdConnectionWrapper wrapper = GfxdConnectionHolder.getHolder().getExistingWrapper(args.connectionId);
        EmbedStatement stmt = null;
        LanguageConnectionContext lcc = null;
        if (wrapper != null) {
            EmbedConnection conn = wrapper.getConnectionOrNull();
            stmt = wrapper.getStatementForCancellation(args.statementId, args.executionId);
            if (conn != null) {
                lcc = conn.getLanguageConnection();
            }
        }
        if (lcc == null) {
            lcc = this.getLccFromContextService(args.connectionId);
        }
        if (GemFireXDUtils.TraceExecution) {
            SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)(" QueryCancelFunction#execute wrapper=" + wrapper + " statement=" + stmt + " lcc=" + lcc + " connectionId=" + args.connectionId + " statementId=" + args.statementId + " executionId=" + args.executionId));
        }
        if (stmt instanceof CallableStatement) {
            Activation activationToBeCancelled = stmt.getActivation();
            if (!(activationToBeCancelled == null || activationToBeCancelled.isClosed() || (long)activationToBeCancelled.getExecutionID() != args.executionId && args.executionId != 0L)) {
                activationToBeCancelled.cancelOnUserRequest();
            }
            return;
        }
        if (Misc.isPrimaryLead()) {
            CallbackFactoryProvider.getClusterCallbacks().cancelJobGroup(String.valueOf(args.statementId));
        }
        if (lcc != null) {
            ArrayList<Activation> activationList = lcc.getAllActivations();
            Activation activation = null;
            for (int index = activationList.size() - 1; index >= 0; --index) {
                if (index >= activationList.size() || !this.needToCancelThisActivation(activation = activationList.get(index), args)) continue;
                activation.cancelOnUserRequest();
            }
        }
    }

    private LanguageConnectionContext getLccFromContextService(final long connectionId) {
        final LanguageConnectionContext[] result = new LanguageConnectionContext[1];
        GemFireXDUtils.Visitor<LanguageConnectionContext> getLcc = new GemFireXDUtils.Visitor<LanguageConnectionContext>(){

            @Override
            public boolean visit(LanguageConnectionContext lcc) {
                if (lcc.getConnectionId() == connectionId) {
                    result[0] = lcc;
                    return false;
                }
                return true;
            }
        };
        GemFireXDUtils.forAllContexts(getLcc);
        return result[0];
    }

    private boolean needToCancelThisActivation(Activation activation, QueryCancelFunctionArgs args) {
        return !(activation == null || activation.isClosed() || activation.getStatementID() != args.statementId && activation.getRootID() != args.statementId || (long)activation.getExecutionID() != args.executionId && args.executionId != 0L);
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return false;
    }

    public static QueryCancelFunctionArgs newQueryCancelFunctionArgs(long statementId, long connectionId) {
        return new QueryCancelFunctionArgs(statementId, 0L, connectionId);
    }

    public static QueryCancelFunctionArgs newQueryCancelFunctionArgs(long statementId, long executionId, long connectionId) {
        return new QueryCancelFunctionArgs(statementId, executionId, connectionId);
    }

    public static final class QueryCancelFunctionArgs
    extends GfxdDataSerializable
    implements Serializable {
        private long statementId;
        private long executionId;
        private long connectionId;

        public QueryCancelFunctionArgs() {
        }

        public QueryCancelFunctionArgs(long statementId, long executionId, long connectionId) {
            this.statementId = statementId;
            this.executionId = executionId;
            this.connectionId = connectionId;
        }

        @Override
        public byte getGfxdID() {
            return 105;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            GemFireXDUtils.writeCompressedHighLow(out, this.statementId);
            GemFireXDUtils.writeCompressedHighLow(out, this.executionId);
            GemFireXDUtils.writeCompressedHighLow(out, this.connectionId);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.statementId = GemFireXDUtils.readCompressedHighLow(in);
            this.executionId = GemFireXDUtils.readCompressedHighLow(in);
            this.connectionId = GemFireXDUtils.readCompressedHighLow(in);
        }
    }
}

