/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.hadoop.mapreduce;

import com.pivotal.gemfirexd.hadoop.mapreduce.Key;
import com.pivotal.gemfirexd.internal.engine.hadoop.mapreduce.OutputFormatUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowOutputFormat<VALUE>
extends OutputFormat<Key, VALUE> {
    public static final String OUTPUT_TABLE = "gfxd.output.tablename";
    public static final String OUTPUT_URL = "gfxd.output.dburl";
    public static final String OUTPUT_BATCH_SIZE = "gfxd.output.batchsize";
    public static final int OUTPUT_BATCH_SIZE_DEFAULT = 10000;
    private static final String OUTPUT_DRIVER_CLASS = "gfxd.output.driver";
    private static final String DRIVER = "io.snappydata.jdbc.ClientDriver";
    private OutputFormatUtil util = new OutputFormatUtil();
    private final Logger logger = LoggerFactory.getLogger(RowOutputFormat.class);

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        RowOutputFormat.validateConfiguration(context.getConfiguration());
    }

    protected static void validateConfiguration(Configuration conf) throws InvalidJobConfException {
        String url = conf.get(OUTPUT_URL);
        if (url == null || url.trim().isEmpty()) {
            throw new InvalidJobConfException("Output URL not configured.");
        }
        String table = conf.get(OUTPUT_TABLE);
        if (table == null || table.trim().isEmpty()) {
            throw new InvalidJobConfException("Output table name not provided.");
        }
    }

    protected static String getDriver(Configuration conf) {
        return conf.get(OUTPUT_DRIVER_CLASS, DRIVER);
    }

    public RecordWriter<Key, VALUE> getRecordWriter(TaskAttemptContext context) throws IOException {
        return new GfxdRecordWriter(context.getConfiguration());
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new NullOutputFormat().getOutputCommitter(context);
    }

    public class GfxdRecordWriter
    extends RecordWriter<Key, VALUE> {
        private final OutputFormatUtil.RowCommandBatchExecutor batchExecutor;
        List<Method> columnSetters = new ArrayList<Method>();
        private String tableName;

        public GfxdRecordWriter(Configuration conf) throws IOException {
            this.tableName = conf.get(RowOutputFormat.OUTPUT_TABLE);
            try {
                OutputFormatUtil outputFormatUtil = RowOutputFormat.this.util;
                outputFormatUtil.getClass();
                this.batchExecutor = new OutputFormatUtil.RowCommandBatchExecutor(outputFormatUtil, RowOutputFormat.getDriver(conf), conf.get(RowOutputFormat.OUTPUT_URL), conf.getInt(RowOutputFormat.OUTPUT_BATCH_SIZE, 10000));
            }
            catch (ClassNotFoundException e) {
                RowOutputFormat.this.logger.error("Gemfirexd client classes are missing from the classpath", (Throwable)e);
                throw new InvalidJobConfException((Throwable)e);
            }
        }

        public void write(Key key, VALUE value) throws IOException, InterruptedException {
            try {
                if (this.batchExecutor.isNotInitialized()) {
                    this.columnSetters = RowOutputFormat.this.util.spotTableColumnSetters(value);
                    String query = RowOutputFormat.this.util.createQuery(this.tableName, this.columnSetters);
                    RowOutputFormat.this.logger.debug("Query to be executed by record writer is: " + query);
                    this.batchExecutor.initStatement(query);
                }
                this.batchExecutor.executeWriteStatement(value, this.columnSetters);
            }
            catch (SQLException e) {
                RowOutputFormat.this.logger.error("Failed to upload data into Gemfirexd", (Throwable)e);
                throw new IOException(e);
            }
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.batchExecutor.close();
        }
    }
}

