/*
 * Decompiled with CFR 0.152.
 */
package io.snappydata.jdbc;

import com.pivotal.gemfirexd.internal.iapi.jdbc.JDBCBoot;
import io.snappydata.jdbc.AutoloadedDriver;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class EmbeddedDriver
implements Driver {
    private AutoloadedDriver _autoloadedDriver;

    public EmbeddedDriver() {
        EmbeddedDriver.boot();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.getDriverModule().acceptsURL(url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.getDriverModule().connect(url, info);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.getDriverModule().getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        try {
            return this.getDriverModule().getMajorVersion();
        }
        catch (SQLException se) {
            return 0;
        }
    }

    @Override
    public int getMinorVersion() {
        try {
            return this.getDriverModule().getMinorVersion();
        }
        catch (SQLException se) {
            return 0;
        }
    }

    @Override
    public boolean jdbcCompliant() {
        try {
            return this.getDriverModule().jdbcCompliant();
        }
        catch (SQLException se) {
            return false;
        }
    }

    private Driver getDriverModule() throws SQLException {
        return AutoloadedDriver.getDriverModule();
    }

    public static void boot() {
        PrintStream ps = DriverManager.getLogStream();
        if (ps == null) {
            ps = System.err;
        }
        new JDBCBoot().boot("jdbc:gemfirexd:", ps);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new AssertionError((Object)"should be overridden in JDBC 4.1");
    }

    static {
        EmbeddedDriver.boot();
    }
}

