/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Loggable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.RawContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class ContainerBasicOperation
implements Loggable {
    private long containerVersion;
    protected ContainerKey containerId;
    protected transient RawContainerHandle containerHdl = null;
    private transient boolean foundHere = false;

    protected ContainerBasicOperation(RawContainerHandle hdl) throws StandardException {
        this.containerHdl = hdl;
        this.containerId = hdl.getId();
        this.containerVersion = hdl.getContainerVersion();
    }

    public ContainerBasicOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.containerId.writeExternal(out);
        CompressedNumber.writeLong(out, this.containerVersion);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerId = ContainerKey.read(in);
        this.containerVersion = CompressedNumber.readLong(in);
    }

    @Override
    public ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public void releaseResource(Transaction tran) {
        if (!this.foundHere) {
            return;
        }
        if (this.containerHdl != null) {
            this.containerHdl.close();
            this.containerHdl = null;
        }
        this.foundHere = false;
    }

    @Override
    public int group() {
        return 256;
    }

    protected RawContainerHandle findContainer(Transaction tran) throws StandardException {
        this.releaseResource(tran);
        RawTransaction rtran = (RawTransaction)tran;
        this.containerHdl = rtran.openDroppedContainer(this.containerId, null);
        if (rtran.inRollForwardRecovery() && this.containerHdl == null) {
            if (SanityManager.DEBUG_ON((String)"LoadTran")) {
                SanityManager.DEBUG_PRINT((String)"Trace", (String)("cannot find container " + this.containerId + ", now attempt last ditch effort"));
            }
            this.containerHdl = this.findContainerForRedoRecovery(rtran);
            if (SanityManager.DEBUG_ON((String)"LoadTran")) {
                SanityManager.DEBUG_PRINT((String)"Trace", (String)(" findContainerForRedoRecovery, got container=" + (this.containerHdl != null)));
            }
        }
        if (this.containerHdl == null) {
            throw StandardException.newException("40XD2", this.containerId);
        }
        this.foundHere = true;
        return this.containerHdl;
    }

    protected RawContainerHandle findContainerForRedoRecovery(RawTransaction tran) throws StandardException {
        return null;
    }

    @Override
    public boolean needsRedo(Transaction xact) throws StandardException {
        this.findContainer(xact);
        long cVersion = this.containerHdl.getContainerVersion();
        if (cVersion == this.containerVersion) {
            return true;
        }
        this.releaseResource(xact);
        if (cVersion > this.containerVersion) {
            return false;
        }
        SanityManager.THROWASSERT((String)("log corrupted, missing log record: log container version = " + this.containerVersion + " container header version " + cVersion));
        return false;
    }

    public String toString() {
        return "Space Operation: " + this.containerId;
    }
}

