/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.heap;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostController;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostResult;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.GenericCostController;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.OpenConglomerate;
import java.util.Properties;

public class HeapCostController
extends GenericCostController
implements StoreCostController {
    long num_pages;
    long num_rows;
    long page_size;
    long row_size;

    @Override
    public void init(OpenConglomerate open_conglom) throws StandardException {
        super.init(open_conglom);
        ContainerHandle container = open_conglom.getContainer();
        this.num_rows = container.getEstimatedRowCount(0);
        if (this.num_rows == 0L) {
            this.num_rows = 1L;
        }
        this.num_pages = container.getEstimatedPageCount(0);
        Properties prop = new Properties();
        prop.put("gemfirexd.storage.pageSize", "");
        container.getContainerProperties(prop);
        this.page_size = Integer.parseInt(prop.getProperty("gemfirexd.storage.pageSize"));
        this.row_size = this.num_pages * this.page_size / this.num_rows;
    }

    @Override
    public double getFetchFromRowLocationCost(FormatableBitSet validColumns, int access_type) throws StandardException {
        double ret_cost = (double)this.row_size * 0.004;
        long num_pages_per_row = this.row_size / this.page_size + 1L;
        ret_cost = (access_type & 1) == 0 ? (ret_cost += 1.5 * (double)num_pages_per_row) : (ret_cost += 0.17 * (double)num_pages_per_row);
        return ret_cost;
    }

    @Override
    public void getScanCost(int scan_type, long row_count, int group_size, boolean forUpdate, FormatableBitSet scanColumnList, DataValueDescriptor[] template, DataValueDescriptor[] startKeyValue, int startSearchOperator, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, boolean reopen_scan, int access_type, StoreCostResult cost_result) throws StandardException {
        SanityManager.ASSERT((scan_type == 2 || scan_type == 1 ? 1 : 0) != 0);
        long estimated_row_count = row_count < 0L ? this.num_rows : row_count;
        double cost = (double)this.num_pages * 1.5;
        cost += (double)(estimated_row_count * this.row_size) * 0.004;
        long cached_row_count = estimated_row_count - this.num_pages;
        if (cached_row_count < 0L) {
            cached_row_count = 0L;
        }
        cost = scan_type == 2 ? (cost += (double)cached_row_count * 0.12) : (cost += (double)cached_row_count * 0.14);
        SanityManager.ASSERT((cost >= 0.0 ? 1 : 0) != 0);
        SanityManager.ASSERT((estimated_row_count >= 0L ? 1 : 0) != 0);
        cost_result.setEstimatedCost(cost);
        cost_result.setEstimatedRowCount(estimated_row_count);
    }
}

