/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.heap;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.SpaceInfo;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RecordHandle;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.RowPosition;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapScan;

class HeapCompressScan
extends HeapScan {
    private long pagenum_to_start_moving_rows = -1L;

    @Override
    public int fetchNextGroup(DataValueDescriptor[][] row_array, RowLocation[] old_rowloc_array, RowLocation[] new_rowloc_array) throws StandardException {
        return this.fetchRowsForCompress(row_array, old_rowloc_array, new_rowloc_array);
    }

    private int fetchRowsForCompress(DataValueDescriptor[][] row_array, RowLocation[] oldrowloc_array, RowLocation[] newrowloc_array) throws StandardException {
        int ret_row_count = 0;
        Object[] fetch_row = null;
        int max_rowcnt = row_array.length;
        SanityManager.ASSERT((row_array != null ? 1 : 0) != 0);
        SanityManager.ASSERT((row_array[0] != null ? 1 : 0) != 0, (String)"first array slot in fetchNextGroup() must be non-null.");
        if (this.getScanState() == 2) {
            this.positionAtResumeScan(this.scan_position);
        } else if (this.getScanState() == 1) {
            SpaceInfo info = this.open_conglom.getContainer().getSpaceInfo();
            this.pagenum_to_start_moving_rows = info.getNumAllocatedPages();
            this.positionAtStartForForwardScan(this.scan_position);
        } else if (this.getScanState() == 5) {
            this.reopenAfterEndTransaction();
            SanityManager.ASSERT((this.scan_position.current_rh != null ? 1 : 0) != 0, (String)this.toString());
            this.open_conglom.latchPageAndRepositionScan(this.scan_position);
            this.setScanState(2);
        } else if (this.getScanState() == 4) {
            this.reopenAfterEndTransaction();
            this.positionAtStartForForwardScan(this.scan_position);
        } else {
            SanityManager.ASSERT((this.getScanState() == 3 ? 1 : 0) != 0);
            return 0;
        }
        while (this.scan_position.current_page != null) {
            while (this.scan_position.current_slot + 1 < this.scan_position.current_page.recordCount()) {
                if (fetch_row == null) {
                    if (row_array[ret_row_count] == null) {
                        row_array[ret_row_count] = this.open_conglom.getRuntimeMem().get_row_for_export(this.open_conglom.getRawTran());
                    }
                    fetch_row = row_array[ret_row_count];
                }
                this.scan_position.positionAtNextSlot();
                int restart_slot = this.scan_position.current_slot;
                ++this.stat_numrows_visited;
                if (this.scan_position.current_page.isDeletedAtSlot(this.scan_position.current_slot)) {
                    this.scan_position.current_page.purgeAtSlot(this.scan_position.current_slot, 1, false);
                    this.scan_position.positionAtPrevSlot();
                    continue;
                }
                if (this.scan_position.current_page.getPageNumber() > this.pagenum_to_start_moving_rows) {
                    RecordHandle[] old_handle = new RecordHandle[1];
                    RecordHandle[] new_handle = new RecordHandle[1];
                    long[] new_pageno = new long[1];
                    if (this.scan_position.current_page.moveRecordForCompressAtSlot(this.scan_position.current_slot, fetch_row, old_handle, new_handle) == 1) {
                        this.scan_position.positionAtPrevSlot();
                        ++this.stat_numrows_qualified;
                        this.setRowLocationArray(oldrowloc_array, ++ret_row_count - 1, old_handle[0]);
                        this.setRowLocationArray(newrowloc_array, ret_row_count - 1, new_handle[0]);
                        fetch_row = null;
                    }
                }
                if (ret_row_count < max_rowcnt) continue;
                this.scan_position.current_rh = this.scan_position.current_page.getRecordHandleAtSlot(restart_slot);
                this.scan_position.unlatch();
                return ret_row_count;
            }
            ++this.stat_numpages_visited;
            if (this.scan_position.current_page.recordCount() == 0) {
                this.scan_position.current_pageno = this.scan_position.current_page.getPageNumber();
                this.open_conglom.getContainer().removePage(this.scan_position.current_page);
                this.scan_position.current_page = null;
            } else {
                this.positionAfterThisPage(this.scan_position);
                this.scan_position.unlatch();
            }
            if (ret_row_count > 0) {
                return ret_row_count;
            }
            this.positionAtResumeScan(this.scan_position);
        }
        this.positionAtDoneScan(this.scan_position);
        --this.stat_numpages_visited;
        return ret_row_count;
    }

    @Override
    protected void positionAtResumeScan(RowPosition pos) throws StandardException {
        this.open_conglom.latchPageAndRepositionScan(this.scan_position);
    }

    @Override
    protected void positionAtStartForForwardScan(RowPosition pos) throws StandardException {
        if (pos.current_rh == null) {
            pos.current_page = this.open_conglom.getContainer().getNextPage(1L);
            pos.current_slot = -1;
        } else {
            this.open_conglom.latchPageAndRepositionScan(pos);
            --pos.current_slot;
        }
        pos.current_rh = null;
        this.stat_numpages_visited = 1;
        this.setScanState(2);
    }

    private void positionAfterThisPage(RowPosition pos) throws StandardException {
        pos.current_rh = null;
        pos.current_pageno = pos.current_page.getPageNumber();
    }
}

