/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DMLVTIResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderImpl;
import java.sql.ResultSet;
import java.util.Properties;

class UpdateVTIResultSet
extends DMLVTIResultSet {
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public UpdateVTIResultSet(NoPutResultSet source, Activation activation) throws StandardException {
        super(source, activation);
    }

    @Override
    protected void openCore() throws StandardException {
        int rowLocationColumn = -1;
        boolean firstRow = true;
        this.rs = this.activation.getTargetVTI();
        ExecRow row = this.getNextRowCore(this.sourceResultSet);
        if (null != row) {
            rowLocationColumn = row.nColumns();
        }
        if (!this.firstExecute) {
            this.lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (null == this.rowHolder && this.constants.deferred) {
            Properties properties = new Properties();
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties);
        }
        try {
            while (row != null) {
                if (this.constants.deferred) {
                    if (firstRow) {
                        row.getColumn(rowLocationColumn).setValue(this.rs.getRow());
                        firstRow = false;
                    } else {
                        DataValueDescriptor rowLocation = row.cloneColumn(rowLocationColumn);
                        rowLocation.setValue(this.rs.getRow());
                        row.setColumn(rowLocationColumn, rowLocation);
                    }
                    this.rowHolder.insert(row);
                } else {
                    this.updateVTI(this.rs, row);
                }
                ++this.rowCount;
                if (this.constants.singleRowSource) {
                    row = null;
                    continue;
                }
                row = this.getNextRowCore(this.sourceResultSet);
            }
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        if (this.constants.deferred) {
            CursorResultSet tempRS = this.rowHolder.getResultSet();
            try {
                tempRS.open();
                while ((row = tempRS.getNextRow()) != null) {
                    int rowNumber = row.getColumn(rowLocationColumn).getInt();
                    this.rs.absolute(rowNumber);
                    this.updateVTI(this.rs, row);
                }
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                tempRS.close(false);
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }

    private void updateVTI(ResultSet target, ExecRow row) throws StandardException {
        int[] changedColumnIds = this.constants.changedColumnIds;
        try {
            for (int i = 0; i < changedColumnIds.length; ++i) {
                int columnId = changedColumnIds[i];
                DataValueDescriptor newValue = row.getColumn(i + 1);
                if (newValue.isNull()) {
                    target.updateNull(columnId);
                    continue;
                }
                newValue.setInto(target, columnId);
            }
            target.updateRow();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.visit(this);
    }
}

