/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.List;

public class DropHDFSStoreConstantAction
extends DDLConstantAction {
    final String hdfsStoreName;
    final boolean onlyIfExists;

    DropHDFSStoreConstantAction(String hdfsStoreName, boolean onlyIfExists) {
        this.hdfsStoreName = hdfsStoreName;
        this.onlyIfExists = onlyIfExists;
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return "__GFXD_INTERNAL_HDFSSTORE_" + this.hdfsStoreName;
    }

    @Override
    public final boolean isDropStatement() {
        return true;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        int rowsDeleted = 0;
        List<GemFireContainer> containers = Misc.getMemStore().getAllContainers();
        for (GemFireContainer container : containers) {
            String regionHDFSStoreName;
            if (container.getRegion() == null || !container.isApplicationTable() || (regionHDFSStoreName = container.getRegionAttributes().getHDFSStoreName()) == null || !regionHDFSStoreName.equalsIgnoreCase(this.hdfsStoreName)) continue;
            throw StandardException.newException("X0Y25.S", "DROP", (Object)("HDFSStore " + this.hdfsStoreName), (Object)"table", (Object)container.getQualifiedTableName());
        }
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionaryImpl dd = (DataDictionaryImpl)lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        ExecIndexRow keyRow = dd.getExecutionFactory().getIndexableRow(1);
        keyRow.setColumn(1, new SQLVarchar(this.hdfsStoreName));
        TabInfoImpl ti = dd.getNonCoreTI(24);
        rowsDeleted = ti.deleteRow(tc, keyRow, 0);
        if (rowsDeleted == 0) {
            if (this.onlyIfExists) {
                return;
            }
            throw StandardException.newException("42Y55", (Object)"DROP HDFSSTORE", (Object)this.hdfsStoreName);
        }
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("DropHDFSStore:: removed HDFSStore " + this.hdfsStoreName + " from SYS table"));
        if (!ServerGroupUtils.isDataStore()) {
            return;
        }
        HDFSStoreImpl store = Misc.getGemFireCache().findHDFSStore(this.hdfsStoreName);
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("DropHDFSStore :: found HDFSStore " + store));
        if (store != null) {
            Misc.getGemFireCache().removeHDFSStore(store);
        }
    }

    public String toString() {
        return this.constructToString("DROP HDFSSTORE ", this.hdfsStoreName);
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

